/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class FeatureSetGloss
extends Gloss {
    public static final int DLT_SIMPLE_DECOMP_FLAG_ALONE = 1;
    public static final int DLT_SIMPLE_DECOMP_FLAG_BEGINNING = 2;
    public static final int DLT_SIMPLE_DECOMP_FLAG_MIDDLE = 4;
    public static final int DLT_SIMPLE_DECOMP_FLAG_END = 8;
    public static final int DLT_SIMPLE_DECOMP_MASK_ANY = 15;
    public static final int DLT_SIMPLE_DECOMP_FLAG_INVALID = 16;
    private static String[] NAMEMAP = new String[11];
    private static final int OFF_BOFA = 8;
    private static final int OFF_COMPOSITIONAL = 15;
    private static final int OFF_DET = 16;
    private static final int OFF_STOP = 17;
    private static final int OFF_CORRECT = 18;
    private static final int OFF_SUGGEST = 19;
    private static final int OFF_USER = 20;
    private static final int MASK_POS = 255;
    private static final int MASK_BOFA_LOW = 31;
    private static final int MASK_DET = 65536;
    private static final int MASK_STOP = 131072;
    private static final int MASK_CORRECT = 262144;
    private static final int MASK_SUGGEST = 524288;
    private static final int MASK_COMPOSITIONAL = 32768;
    private static final int MASK_USER_LOW = 4095;
    private int allflags = 0;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static String getPOSName(int n) {
        return n > 0 && n < NAMEMAP.length ? NAMEMAP[n] : NAMEMAP[0];
    }

    public FeatureSetGloss() {
    }

    public FeatureSetGloss(int n, int n2, int n3, int n4, int n5) {
        this.allflags = n & 0xFF | (n2 & 0x1F) << 8 | (n3 & 1) << 16 | (n4 & 1) << 17 | 0x40000 | 0x80000 | (n5 & 0xFFF) << 20;
    }

    public FeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(n, n2, bl, bl2, bl3, bl4, false);
    }

    public FeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.allflags = n & 0xFF | (n2 & 0x1F) << 8 | (bl5 ? 1 : 0) << 15 | (bl ? 1 : 0) << 16 | (bl2 ? 1 : 0) << 17 | (bl3 ? 1 : 0) << 18 | (bl4 ? 1 : 0) << 19;
    }

    private static boolean getBoolean(List<?> list, int n, boolean bl) {
        if (list.size() <= n) {
            return bl;
        }
        Object obj = list.get(n);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Integer) {
            return (Integer)obj != 0;
        }
        if (obj instanceof String) {
            if (((String)obj).length() == 0) {
                return bl;
            }
            return Boolean.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Illegal argument (Boolean expected): " + obj);
    }

    private static int getBOFABit(String string, int n, int n2) {
        if (string.length() <= n) {
            return 0;
        }
        if (string.charAt(n) != '0') {
            return n2;
        }
        return 0;
    }

    public static FeatureSetGloss fromSpec(List<?> list) {
        Object obj;
        int n = 3;
        int n2 = 1;
        if (list.size() > 0) {
            obj = list.get(0);
            if (obj instanceof Integer) {
                n = (Integer)obj;
            } else if (obj instanceof String) {
                for (int i = 0; i < NAMEMAP.length; ++i) {
                    if (!NAMEMAP[i].equalsIgnoreCase((String)obj)) continue;
                    n = i;
                }
            } else {
                throw new IllegalArgumentException("Illegal POS: " + obj);
            }
        }
        if (list.size() > 1) {
            obj = list.get(1);
            if (obj instanceof Integer) {
                n2 = (Integer)obj;
            } else if (obj instanceof String) {
                String string = (String)obj;
                if (string.length() > 0) {
                    n2 = FeatureSetGloss.getBOFABit(string, 0, 1);
                    n2 |= FeatureSetGloss.getBOFABit(string, 1, 2);
                    n2 |= FeatureSetGloss.getBOFABit(string, 2, 4);
                    n2 |= FeatureSetGloss.getBOFABit(string, 3, 8);
                }
            } else {
                throw new IllegalArgumentException("Illegal BOFA: " + obj);
            }
        }
        return new FeatureSetGloss(n, n2, FeatureSetGloss.getBoolean(list, 2, false), FeatureSetGloss.getBoolean(list, 3, false), FeatureSetGloss.getBoolean(list, 4, true), FeatureSetGloss.getBoolean(list, 5, true), FeatureSetGloss.getBoolean(list, 6, false));
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.allflags = dataInputStream.readInt();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.allflags);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof FeatureSetGloss && this.allflags == ((FeatureSetGloss)object).allflags;
    }

    @Override
    public boolean isSimilar(Object object) {
        return object instanceof FeatureSetGloss && (this.allflags & 0xFF) == ((FeatureSetGloss)object).getPOS();
    }

    @Override
    public Gloss mergeGloss(Object object) {
        if (!(object instanceof FeatureSetGloss)) {
            return this;
        }
        FeatureSetGloss featureSetGloss = (FeatureSetGloss)object;
        if (this.getPOS() != featureSetGloss.getPOS()) {
            return this;
        }
        int n = this.getBOFA() | featureSetGloss.getBOFA();
        boolean bl = this.is(201) || featureSetGloss.is(201);
        boolean bl2 = this.is(200) || featureSetGloss.is(200);
        boolean bl3 = this.is(206) || featureSetGloss.is(206);
        boolean bl4 = this.is(207) || featureSetGloss.is(207);
        boolean bl5 = this.is(208) || featureSetGloss.is(208);
        return new FeatureSetGloss(this.getPOS(), n, bl, bl2, bl3, bl4, bl5);
    }

    @Override
    public int hashCode() {
        return this.allflags;
    }

    public final int getPOS() {
        return this.allflags & 0xFF;
    }

    public final int getBOFA() {
        return this.allflags >> 8 & 0x1F;
    }

    public final int getConstraintsMask() {
        return this.getBOFA();
    }

    @Deprecated
    public final int getDet() {
        return (this.allflags & 0x10000) >> 16;
    }

    @Deprecated
    public final int getStop() {
        return (this.allflags & 0x20000) >> 17;
    }

    public final int getUser() {
        return this.allflags >> 20 & 0xFFF;
    }

    @Deprecated
    public final boolean isCorrectSpelling() {
        return (this.allflags & 0x40000) != 0;
    }

    @Deprecated
    public final boolean isSuggestion() {
        return (this.allflags & 0x80000) != 0;
    }

    public final boolean isCompositional() {
        return (this.allflags & 0x8000) != 0;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("FSet(");
        stringBuilder.append(FeatureSetGloss.getPOSName(this.getPOS()));
        stringBuilder.append(',');
        if (this.is(105)) {
            stringBuilder.append('1');
        }
        stringBuilder.append(this.is(101) ? (char)'1' : '0');
        stringBuilder.append(this.is(102) ? (char)'1' : '0');
        stringBuilder.append(this.is(103) ? (char)'1' : '0');
        stringBuilder.append(this.is(104) ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.is(200) ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.is(201) ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.is(206) ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.is(207) ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.is(208) ? (char)'1' : '0');
        int n = this.getUser();
        if (n != 0) {
            stringBuilder.append(',');
            stringBuilder.append(n);
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    @Override
    public final boolean is(int n) {
        if (n >= 0 && n <= 100) {
            return n == this.getPOS();
        }
        switch (n) {
            case 101: {
                return (this.getBOFA() & 1) != 0;
            }
            case 102: {
                return (this.getBOFA() & 2) != 0;
            }
            case 104: {
                return (this.getBOFA() & 8) != 0;
            }
            case 103: {
                return (this.getBOFA() & 4) != 0;
            }
            case 105: {
                return (this.getBOFA() & 0x10) != 0;
            }
            case 206: {
                return this.isCorrectSpelling();
            }
            case 207: {
                return this.isSuggestion();
            }
            case 201: {
                return this.getDet() != 0;
            }
            case 200: {
                return this.getStop() != 0;
            }
            case 208: {
                return this.isCompositional();
            }
        }
        return false;
    }

    static {
        FeatureSetGloss.NAMEMAP[0] = "Unknown";
        FeatureSetGloss.NAMEMAP[1] = "Pronoun";
        FeatureSetGloss.NAMEMAP[2] = "Verb";
        FeatureSetGloss.NAMEMAP[3] = "Noun";
        FeatureSetGloss.NAMEMAP[4] = "Adjective";
        FeatureSetGloss.NAMEMAP[5] = "Adverb";
        FeatureSetGloss.NAMEMAP[6] = "Adposition";
        FeatureSetGloss.NAMEMAP[7] = "Interjection";
        FeatureSetGloss.NAMEMAP[8] = "Conjunction";
        FeatureSetGloss.NAMEMAP[9] = "Determiner";
        FeatureSetGloss.NAMEMAP[10] = "Quantifier";
    }

    public static interface FeatureTags {
        public static final int POS_UNKNOWN = 0;
        public static final int POS_PRONOUN = 1;
        public static final int POS_VERB = 2;
        public static final int POS_NOUN = 3;
        public static final int POS_ADJECTIVE = 4;
        public static final int POS_ADVERB = 5;
        public static final int POS_ADPOSITION = 6;
        public static final int POS_INTERJECTION = 7;
        public static final int POS_CONJUNCTION = 8;
        public static final int POS_DETERMINER = 9;
        public static final int POS_QUANTIFIER = 10;
        public static final int POS_MAX = 100;
        public static final int DECOMP_FLAG_ALONE = 101;
        public static final int DECOMP_FLAG_BEGINNING = 102;
        public static final int DECOMP_FLAG_MIDDLE = 103;
        public static final int DECOMP_FLAG_END = 104;
        public static final int DECOMP_FLAG_INVALID = 105;
        public static final int STOPWORD = 200;
        public static final int DETERMINER = 201;
        @Deprecated
        public static final int ENDOFSENTENCE = 202;
        @Deprecated
        public static final int PROPERCASE = 203;
        @Deprecated
        public static final int ABBREVIATION = 204;
        @Deprecated
        public static final int ACRONYM = 205;
        public static final int CORRECTLYSPELT = 206;
        public static final int SUGGESTION = 207;
        public static final int COMPOSITIONAL = 208;
    }
}

