/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossPool;
import java.util.Map;

public class GlossMapper {
    private final GlossPool[] glossPools;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GlossMapper(GlossPool[] glossPoolArray) {
        this.glossPools = glossPoolArray;
        this.assignGlossIndex();
    }

    private void assignGlossIndex() {
        int n = 0;
        for (int i = 0; i < this.glossPools.length; ++i) {
            if (this.glossPools[i] == null) continue;
            this.glossPools[i].ensureInterned();
            for (Map.Entry<Gloss, Object> entry : this.glossPools[i].glossHash.entrySet()) {
                entry.setValue(n++);
            }
        }
    }

    public void reAssign() {
        for (int i = 0; i < this.glossPools.length; ++i) {
            if (this.glossPools[i] == null) continue;
            for (Map.Entry<Gloss, Object> entry : this.glossPools[i].glossHash.entrySet()) {
                entry.setValue(entry.getKey());
            }
        }
    }

    public int getGlossIndex(Gloss gloss) throws DLTException {
        int n = gloss.getType();
        GlossPool glossPool = this.glossPools[n];
        if (glossPool == null) {
            throw new DLTException(Messages.format("cannot.savegloss", gloss));
        }
        Integer n2 = (Integer)glossPool.glossHash.get(gloss);
        if (n2 == null) {
            throw new DLTException(Messages.format("cannot.savegloss", gloss));
        }
        return n2;
    }
}

