/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.BackMapper;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.annotate.gloss.FeatureStructureGloss;
import com.ibm.dltj.annotate.gloss.IntegerFeatGloss;
import com.ibm.dltj.annotate.gloss.JavaPatternGloss;
import com.ibm.dltj.annotate.gloss.JavaRegexTransformGloss;
import com.ibm.dltj.annotate.gloss.StringArrayFeatGloss;
import com.ibm.dltj.annotate.gloss.StringFeatGloss;
import com.ibm.dltj.gloss.ArabicTransformCodeGloss;
import com.ibm.dltj.gloss.BytesClassLoader;
import com.ibm.dltj.gloss.CRFLabelSetGloss;
import com.ibm.dltj.gloss.CRFLearningRateGloss;
import com.ibm.dltj.gloss.CRFStateFeatureGloss;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.CatNameGloss;
import com.ibm.dltj.gloss.ConstraintCodeGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.HyphenationGloss;
import com.ibm.dltj.gloss.HyphenationRuleGloss;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.JkomCollectionGloss;
import com.ibm.dltj.gloss.KoMorphGloss;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.LemmaTransformCodeGloss;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MWEntryLemmaGloss;
import com.ibm.dltj.gloss.MWGloss;
import com.ibm.dltj.gloss.MWUGloss;
import com.ibm.dltj.gloss.MWValidationGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.MorphRuleGloss;
import com.ibm.dltj.gloss.PcodeGloss;
import com.ibm.dltj.gloss.PhoneticSpellingGloss;
import com.ibm.dltj.gloss.PosCollectionGloss;
import com.ibm.dltj.gloss.StemCutPasteGloss;
import com.ibm.dltj.gloss.StemGloss;
import com.ibm.dltj.gloss.StringArrayGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.SynonymGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.gloss.TransformClassGloss;
import com.ibm.dltj.gloss.TransformGloss;
import com.ibm.dltj.gloss.TransformRuleGloss;
import com.ibm.dltj.gloss.TypedArrayGloss;
import com.ibm.dltj.gloss.TypedDoubleGloss;
import com.ibm.dltj.gloss.TypedIntGloss;
import com.ibm.dltj.gloss.TypedStringGloss;
import com.ibm.dltj.gloss.TypedVectorGloss;
import com.ibm.dltj.gloss.UserDefinedDefaultGloss;
import com.ibm.dltj.gloss.ZhCposGloss;
import com.ibm.dltj.gloss.ZhDecompGloss;
import com.ibm.dltj.gloss.ZhFreqGloss;
import com.ibm.dltj.gloss.ZhLemmaGloss;
import com.ibm.dltj.gloss.ZhMorphGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class GlossPool {
    private static final int DLTGLS_HASHTABLE_SIZE = 1021;
    public final Map<Gloss, Object> glossHash = new Hashtable<Gloss, Object>(1021);
    private final Class<? extends Gloss> mainClass;
    private final Constructor<? extends Gloss> mainConstructor;
    private final byte[] classBytes;
    private Gloss[] localMap;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GlossPool() throws DLTException {
        this(IntegerGloss.class, null);
    }

    public GlossPool(Class<? extends Gloss> clazz) throws DLTException {
        this(clazz, null);
    }

    public GlossPool(Class<? extends Gloss> clazz, byte[] byArray) throws DLTException {
        this.mainClass = clazz;
        this.classBytes = byArray;
        if (clazz == null) {
            throw new DLTException(Messages.getString("null.class"));
        }
        if (!Gloss.class.isAssignableFrom(clazz)) {
            throw new DLTException(Messages.getString("cannot.createpool"));
        }
        try {
            this.mainConstructor = clazz.getConstructor(new Class[0]);
        }
        catch (SecurityException securityException) {
            throw new DLTException(Messages.format("dlt.access", clazz.getName()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DLTException(Messages.format("dlt.class", clazz.getName()));
        }
    }

    public static GlossPool instantiate(String string, ClassLoader classLoader) throws DLTException {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : Class.forName(string, true, classLoader);
            return new GlossPool(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DLTException(Messages.format("dlt.noclass", string));
        }
    }

    public static GlossPool instantiate(String string, BytesClassLoader bytesClassLoader, byte[] byArray) throws DLTException {
        Class<? extends Gloss> clazz = bytesClassLoader.loadClass(string, byArray);
        return new GlossPool(clazz, byArray);
    }

    public static GlossPool instantiate(int n) throws DLTException {
        GlossPool glossPool = null;
        switch (n) {
            case 1: {
                glossPool = new GlossPool(MidGloss.class);
                break;
            }
            case 11: {
                glossPool = new GlossPool(LemmaGloss.class);
                break;
            }
            case 12: {
                glossPool = new GlossPool(CutPasteGloss.class);
                break;
            }
            case 20: {
                glossPool = new GlossPool(StemGloss.class);
                break;
            }
            case 21: {
                glossPool = new GlossPool(StemCutPasteGloss.class);
                break;
            }
            case 13: {
                glossPool = new GlossPool(GrammarGloss.class);
                break;
            }
            case 14: {
                glossPool = new GlossPool(PcodeGloss.class);
                break;
            }
            case 2: {
                glossPool = new GlossPool(PosCollectionGloss.class);
                break;
            }
            case 22: {
                glossPool = new GlossPool(SynonymGloss.class);
                break;
            }
            case 30: {
                glossPool = new GlossPool(KoMorphGloss.class);
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                glossPool = new GlossPool(JaMorphGloss.class);
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                glossPool = new GlossPool(JaGramSetGloss.class);
                break;
            }
            case 15: {
                glossPool = new GlossPool(FeatureSetGloss.class);
                break;
            }
            case 40: {
                glossPool = new GlossPool(ZhMorphGloss.class);
                break;
            }
            case 41: {
                glossPool = new GlossPool(ZhLemmaGloss.class);
                break;
            }
            case 16: {
                glossPool = new GlossPool(LangNameGloss.class);
                break;
            }
            case 17: {
                glossPool = new GlossPool(TCRGloss.class);
                break;
            }
            case 19: {
                glossPool = new GlossPool(CatNameGloss.class);
                break;
            }
            case 26: {
                glossPool = new GlossPool(MorphRuleGloss.class);
                break;
            }
            case 27: {
                glossPool = new GlossPool(ConstraintCodeGloss.class);
                break;
            }
            case 28: {
                glossPool = new GlossPool(CaseGloss.class);
                break;
            }
            case 18: {
                glossPool = new GlossPool(IntegerGloss.class);
                break;
            }
            case 85: {
                glossPool = new GlossPool(TokenClassGloss.class);
                break;
            }
            case 4: {
                glossPool = new GlossPool(JkomCollectionGloss.class);
                break;
            }
            case 23: {
                glossPool = new GlossPool(PhoneticSpellingGloss.class);
                break;
            }
            case 55: {
                glossPool = new GlossPool(MWElementGloss.class);
                break;
            }
            case 56: {
                glossPool = new GlossPool(MWUGloss.class);
                break;
            }
            case 60: {
                glossPool = new GlossPool(StringGloss.class);
                break;
            }
            case 35: {
                glossPool = new GlossPool(TransformGloss.class);
                break;
            }
            case 36: {
                glossPool = new GlossPool(TransformClassGloss.class);
                break;
            }
            case 37: {
                glossPool = new GlossPool(TransformRuleGloss.class);
                break;
            }
            case 66: {
                glossPool = new GlossPool(TypedStringGloss.class);
                break;
            }
            case 67: {
                glossPool = new GlossPool(TypedIntGloss.class);
                break;
            }
            case 68: {
                glossPool = new GlossPool(TypedDoubleGloss.class);
                break;
            }
            case 69: {
                glossPool = new GlossPool(TypedVectorGloss.class);
                break;
            }
            case 70: {
                glossPool = new GlossPool(TypedArrayGloss.class);
                break;
            }
            case 71: {
                glossPool = new GlossPool(ArabicTransformCodeGloss.class);
                break;
            }
            case 72: {
                glossPool = new GlossPool(LemmaTransformCodeGloss.class);
                break;
            }
            case 80: {
                glossPool = new GlossPool(ZhFreqGloss.class);
                break;
            }
            case 81: {
                glossPool = new GlossPool(ZhCposGloss.class);
                break;
            }
            case 82: {
                glossPool = new GlossPool(ZhDecompGloss.class);
                break;
            }
            case 83: {
                glossPool = new GlossPool(HyphenationGloss.class);
                break;
            }
            case 0: {
                break;
            }
            case 84: {
                glossPool = new GlossPool(HyphenationRuleGloss.class);
                break;
            }
            case 57: {
                glossPool = new GlossPool(MWValidationGloss.class);
                break;
            }
            case 58: {
                glossPool = new GlossPool(MWEntryLemmaGloss.class);
                break;
            }
            case 59: {
                glossPool = new GlossPool(MWGloss.class);
                break;
            }
            case 86: {
                glossPool = new GlossPool(StringArrayGloss.class);
                break;
            }
            case 88: {
                glossPool = new GlossPool(FeatureStructureGloss.class);
                break;
            }
            case 89: {
                glossPool = new GlossPool(IntegerFeatGloss.class);
                break;
            }
            case 90: {
                glossPool = new GlossPool(StringFeatGloss.class);
                break;
            }
            case 91: {
                glossPool = new GlossPool(JavaRegexTransformGloss.class);
                break;
            }
            case 92: {
                glossPool = new GlossPool(JavaPatternGloss.class);
                break;
            }
            case 93: {
                glossPool = new GlossPool(StringArrayFeatGloss.class);
                break;
            }
            case 50: {
                glossPool = new GlossPool(CRFLabelSetGloss.class);
                break;
            }
            case 51: {
                glossPool = new GlossPool(CRFStateFeatureGloss.class);
                break;
            }
            case 52: {
                glossPool = new GlossPool(CRFTransitionFeatureGloss.class);
                break;
            }
            case 53: {
                glossPool = new GlossPool(CRFLearningRateGloss.class);
                break;
            }
            default: {
                if (n >= 128 && n < 255) {
                    glossPool = new GlossPool(UserDefinedDefaultGloss.class);
                    break;
                }
                throw new DLTException(Messages.getString("invalid.glosstype"));
            }
        }
        return glossPool;
    }

    public Iterator<Gloss> getGlossIterator() {
        if (this.localMap != null) {
            return Arrays.asList(this.localMap).iterator();
        }
        return this.glossHash.keySet().iterator();
    }

    public int getSize() {
        if (this.localMap != null) {
            return this.localMap.length;
        }
        return this.glossHash.size();
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public byte[] getMainClassBytes() {
        return this.classBytes;
    }

    private Gloss newGloss() throws DLTException {
        try {
            return this.mainConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DLTException(Messages.format("exception.encountered", illegalArgumentException));
        }
        catch (InstantiationException instantiationException) {
            throw new DLTException(Messages.format("exception.encountered", instantiationException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DLTException(Messages.format("exception.encountered", illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DLTException(Messages.format("exception.encountered", invocationTargetException));
        }
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        this.ensureInterned();
        dataOutputStream.writeInt(this.glossHash.size());
        for (Gloss gloss : this.glossHash.keySet()) {
            if (!this.glossHash.containsKey(gloss)) {
                throw new DLTException(Messages.getString("cannot.createpool"));
            }
            gloss.write(dataOutputStream, glossMapper);
        }
    }

    public int read(DataInputStream dataInputStream, int n, BackMapper backMapper) throws DLTException, IOException {
        if (backMapper == null) {
            throw new DLTException(Messages.getString("error.dict.glossmap"));
        }
        int n2 = dataInputStream.readInt();
        if (n2 < 0) {
            throw new DLTException(Messages.getString("error.dict.read"));
        }
        this.localMap = new Gloss[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = dataInputStream.readInt();
            switch (n) {
                case 15: 
                case 18: 
                case 26: 
                case 27: 
                case 28: 
                case 30: 
                case 32: 
                case 33: 
                case 36: 
                case 40: 
                case 51: 
                case 53: 
                case 57: 
                case 58: 
                case 67: 
                case 68: 
                case 80: 
                case 83: 
                case 84: 
                case 85: 
                case 89: 
                case 90: 
                case 91: 
                case 92: {
                    n3 = 0;
                    break;
                }
                default: {
                    n3 = dataInputStream.readInt();
                }
            }
            Gloss gloss = this.newGloss();
            gloss.read(dataInputStream, n3);
            backMapper.setGloss(n4, gloss);
            this.localMap[i] = gloss;
        }
        return n2;
    }

    public Gloss checkIn(Gloss gloss) throws DLTException {
        if (gloss.getClass() != this.mainClass) {
            throw new DLTException(Messages.getString("error.gloss.type"));
        }
        this.ensureInterned();
        Object object = this.glossHash.get(gloss);
        if (object == null) {
            this.glossHash.put(gloss, gloss);
            return gloss;
        }
        if (object instanceof Gloss) {
            return (Gloss)object;
        }
        throw new DLTException(Messages.getString("error.gloss.type"));
    }

    public void internGlosses() throws DLTException {
    }

    void ensureInterned() {
        if (this.localMap != null) {
            this.doInternGlosses();
        }
    }

    private void doInternGlosses() {
        for (int i = 0; i < this.localMap.length; ++i) {
            Gloss gloss = this.localMap[i];
            Object object = this.glossHash.put(gloss, gloss);
            assert (object == null);
        }
        this.localMap = null;
    }
}

