/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.gloss.GrammarGloss;

public abstract class GrammarFeatureExtractor {
    int OFF_INFINITIVE = -1;
    int OFF_SINGULAR = -1;
    int OFF_PLURAL = -1;
    int OFF_FIRST_P = -1;
    int OFF_SECOND_P = -1;
    int OFF_THIRD_P = -1;
    int OFF_FEMININE = -1;
    int OFF_MASCULINE = -1;
    int OFF_PRESENT = -1;
    int OFF_PAST = -1;
    int OFF_PRESENT_PARTICIPLE = -1;
    int OFF_PAST_PARTICIPLE = -1;
    int OFF_POSITIVE = -1;
    int OFF_COMPARATIVE = -1;
    int OFF_SUPERLATIVE = -1;
    int OFF_POSSESSIVE = -1;
    int OFF_PROPER_NOUN = -1;
    int OFF_PREFIX = -1;
    int OFF_DEMONSTRATIVE = -1;
    int OFF_REFLEXIVE = -1;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static boolean isSet(int n, GrammarGloss grammarGloss) {
        if (n == -1) {
            return false;
        }
        if (grammarGloss == null) {
            return false;
        }
        int n2 = grammarGloss.getMaskN();
        for (int i = 0; i < n2; ++i) {
            if ((grammarGloss.getMask(i) & 1 << n) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinitive(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_INFINITIVE, grammarGloss);
    }

    public boolean isSingular(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_SINGULAR, grammarGloss);
    }

    public boolean isPlural(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PLURAL, grammarGloss);
    }

    public boolean isFirstPerson(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_FIRST_P, grammarGloss);
    }

    public boolean isSecondPerson(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_SECOND_P, grammarGloss);
    }

    public boolean isThirdPerson(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_THIRD_P, grammarGloss);
    }

    public boolean isFeminine(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_FEMININE, grammarGloss);
    }

    public boolean isMasculine(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_MASCULINE, grammarGloss);
    }

    public boolean isPresent(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PRESENT, grammarGloss);
    }

    public boolean isPast(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PAST, grammarGloss);
    }

    public boolean isPresentParticiple(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PRESENT_PARTICIPLE, grammarGloss);
    }

    public boolean isPastParticiple(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PAST_PARTICIPLE, grammarGloss);
    }

    public boolean isPositive(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_POSITIVE, grammarGloss);
    }

    public boolean isComparative(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_COMPARATIVE, grammarGloss);
    }

    public boolean isSuperlative(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_SUPERLATIVE, grammarGloss);
    }

    public boolean isPossessive(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_POSSESSIVE, grammarGloss);
    }

    public boolean isProperNoun(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PROPER_NOUN, grammarGloss);
    }

    public boolean isPrefix(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_PREFIX, grammarGloss);
    }

    public boolean isDemonstrative(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_DEMONSTRATIVE, grammarGloss);
    }

    public boolean isReflexive(GrammarGloss grammarGloss) {
        return GrammarFeatureExtractor.isSet(this.OFF_REFLEXIVE, grammarGloss);
    }
}

