/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.util.ArrayUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GrammarGloss
extends Gloss {
    public int rtData;
    public int[] mask;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GrammarGloss() {
        this(null);
    }

    public GrammarGloss(int[] nArray) {
        this.mask = nArray != null ? nArray : ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.rtData = dataInputStream.readInt();
        this.mask = new int[n];
        for (int i = 0; i < n; ++i) {
            this.mask[i] = dataInputStream.readInt();
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.mask.length);
        dataOutputStream.writeInt(this.rtData);
        for (int n2 : this.mask) {
            dataOutputStream.writeInt(n2);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GrammarGloss && Arrays.equals(this.mask, ((GrammarGloss)object).mask);
    }

    @Override
    public boolean isSimilar(Object object) {
        return object instanceof GrammarGloss;
    }

    @Override
    public Gloss mergeGloss(Object object) {
        int n;
        if (!(object instanceof GrammarGloss)) {
            return this;
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (n = 0; n < this.getMaskN(); ++n) {
            this.addToMap(treeMap, this.getMask(n));
        }
        for (n = 0; n < ((GrammarGloss)object).getMaskN(); ++n) {
            this.addToMap(treeMap, ((GrammarGloss)object).getMask(n));
        }
        int[] nArray = new int[treeMap.size()];
        int n2 = treeMap.size() - 1;
        Set set = treeMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            nArray[n2] = (Integer)treeMap.get(iterator.next());
            --n2;
        }
        return new GrammarGloss(nArray);
    }

    private void addToMap(Map<String, Integer> map, int n) {
        String string = Integer.toBinaryString(n);
        int n2 = string.length();
        string = ("00000000000000000000000000000000" + string).substring(n2);
        map.put(string, n);
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int n2 : this.mask) {
            n = n * 37 + n2;
        }
        return n;
    }

    public int getRtData() {
        return this.rtData;
    }

    public int setRtData(int n) {
        this.rtData = n;
        return this.rtData;
    }

    @Override
    public int getType() {
        return 13;
    }

    public int getMaskN() {
        return this.mask.length;
    }

    public int getMask(int n) {
        return this.mask[n];
    }

    public boolean hasMask(int n) {
        for (int n2 : this.mask) {
            if ((n2 & n) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Gramm(");
        for (int i = 0; i < this.mask.length; ++i) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(Integer.toHexString(this.mask[i]));
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

