/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.HyphenationPoint;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.HyphenGenerator;
import com.ibm.dltj.util.ArrayResize;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HyphenationGloss
extends Gloss
implements HyphenGenerator {
    public static final char[] HYPHENS = new char[256];
    public static final char[] REAL_HYPHENS = new char[]{'-', '_', '=', '+', ','};
    public static final char[] TEMP_HYPHENS = new char[]{'<', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '%', '\u00c4', 'A', 'E', 'O', 'S', '[', '?'};
    private int hyphensCount;
    private static final int POSMASK = 65280;
    private static final int TYPEMASK = 255;
    private static final int TYPELENGTH = 8;
    int[] value;
    public static final int specialHyphensINDX = 220;
    public static final int intermediatHyphensINDX = 128;

    public HyphenationGloss(String string) {
        this.hyphensCount = 0;
        this.value = this.getHyphens(string);
    }

    public HyphenationGloss() {
    }

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getType() {
        return 83;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.hyphensCount = dataInputStream.readByte();
        this.read_(dataInputStream, this.hyphensCount);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        this.write_(dataOutputStream, glossMapper);
    }

    public final void read_(DataInputStream dataInputStream, int n) throws IOException {
        this.value = new int[n];
        for (int i = 0; i < n; ++i) {
            this.value[i] = dataInputStream.readInt();
        }
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            dataOutputStream.writeInt(this.value[i]);
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.value.length; ++i) {
            n = 31 * n + this.value[i];
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HyphenationGloss && Arrays.equals(((HyphenationGloss)object).value, this.value);
    }

    private int[] getHyphens(String string) {
        int[] nArray = new int[5];
        int n = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            for (int j = 0; j < HYPHENS.length; ++j) {
                if (HYPHENS[j] != string.charAt(i)) continue;
                if (this.hyphensCount >= nArray.length) {
                    nArray = this.expandHyphensCount(nArray);
                }
                nArray[this.hyphensCount] = n << 8 & 0xFF00;
                nArray[this.hyphensCount] = nArray[this.hyphensCount] | 0xFF & j;
                ++this.hyphensCount;
                n = 0;
                continue block0;
            }
            ++n;
        }
        return this.trimHyphensCount(nArray, this.hyphensCount);
    }

    private int[] expandHyphensCount(int[] nArray) {
        return (int[])ArrayResize.resize(nArray, nArray.length + 5);
    }

    private int[] trimHyphensCount(int[] nArray, int n) {
        return (int[])ArrayResize.resize(nArray, n);
    }

    @Override
    public List<HyphenationPoint> getHyphenationPoints(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() < this.getmaxposition()) {
            return this.getHyphenationPoints();
        }
        ArrayList<HyphenationPoint> arrayList = new ArrayList<HyphenationPoint>(this.hyphensCount);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.hyphensCount; ++i) {
            int n3;
            int n4 = this.value[i] & 0xFF;
            n = n3 = n + (this.value[i] >>> 8);
            if (stringBuffer.length() > n3 + n2) {
                char c;
                if (stringBuffer.charAt(n3 + n2) == '-') {
                    arrayList.add(new HyphenationPoint(n3 + n2, n4, stringBuffer.toString()));
                    if (stringBuffer.length() >= this.getmaxposition() - ++n2) continue;
                    return this.getHyphenationPoints();
                }
                if (stringBuffer.charAt(n2 + n3) == '\u00b7') {
                    c = stringBuffer.charAt(n2 + n3);
                    this.replaceChar(stringBuffer, n2 + n3, HYPHENS[n4]);
                    arrayList.add(new HyphenationPoint(n3 + n2, n4, stringBuffer.toString()));
                    this.replaceChar(stringBuffer, n2 + n3, c);
                    continue;
                }
                if (n2 + n3 > 0 && stringBuffer.charAt(n2 + n3 - 1) == '\u00b7') {
                    c = stringBuffer.charAt(n2 + n3 - 1);
                    this.replaceChar(stringBuffer, n2 + n3 - 1, HYPHENS[n4]);
                    arrayList.add(new HyphenationPoint(n3 + n2 - 1, n4, stringBuffer.toString()));
                    this.replaceChar(stringBuffer, n2 + n3 - 1, c);
                    continue;
                }
            }
            stringBuffer.insert(n3 + n2, HYPHENS[n4]);
            if (i + 1 < this.hyphensCount && (this.value[i + 1] & 0xFF) >= 220) {
                stringBuffer.insert(n3 + n2 + 1, HYPHENS[this.value[i + 1] & 0xFF]);
            }
            arrayList.add(new HyphenationPoint(n3 + n2, n4, stringBuffer.toString()));
            stringBuffer.deleteCharAt(n3 + n2);
        }
        return arrayList;
    }

    @Override
    public List<HyphenationPoint> getHyphenationPoints(String string) {
        return this.getHyphenationPoints(new StringBuffer(string));
    }

    @Override
    public List<HyphenationPoint> getHyphenationPoints() {
        ArrayList<HyphenationPoint> arrayList = new ArrayList<HyphenationPoint>(this.hyphensCount);
        int n = 0;
        for (int i = 0; i < this.hyphensCount; ++i) {
            int n2;
            int n3 = this.value[i] & 0xFF;
            n = n2 = n + (this.value[i] >>> 8);
            arrayList.add(new HyphenationPoint(n2, n3, ""));
        }
        return arrayList;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hyphen(");
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            int n2;
            stringBuffer.append('(');
            int n3 = this.value[i] & 0xFF;
            n = n2 = (this.value[i] >>> 8) + n;
            stringBuffer.append(n3);
            stringBuffer.append(',');
            stringBuffer.append(n2);
            stringBuffer.append(')');
        }
        stringBuffer.append(')');
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }

    public int getmaxposition() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n += (this.value[i] & 0xFF00) >>> 8;
        }
        return n;
    }

    @Override
    public List<HyphenationPoint> getHyphenationPoints(StringBuffer stringBuffer, int n) {
        if (stringBuffer == null || stringBuffer.length() < this.getmaxposition()) {
            return this.getHyphenationPoints();
        }
        ArrayList<HyphenationPoint> arrayList = new ArrayList<HyphenationPoint>(this.hyphensCount);
        int n2 = n;
        int n3 = 0;
        for (int i = 0; i < this.hyphensCount; ++i) {
            int n4;
            int n5 = this.value[i] & 0xFF;
            n2 = n4 = n2 + (this.value[i] >>> 8);
            if (n3 + n4 <= 0) continue;
            if (stringBuffer.length() > n4 + n3) {
                char c;
                if (stringBuffer.charAt(n4 + n3) == '-') {
                    arrayList.add(new HyphenationPoint(n4 + n3, n5, stringBuffer.toString()));
                    if (stringBuffer.length() >= this.getmaxposition() - ++n3) continue;
                    return this.getHyphenationPoints();
                }
                if (stringBuffer.charAt(n3 + n4) == '\u00b7') {
                    c = stringBuffer.charAt(n3 + n4);
                    this.replaceChar(stringBuffer, n3 + n4, HYPHENS[n5]);
                    arrayList.add(new HyphenationPoint(n4 + n3, n5, stringBuffer.toString()));
                    this.replaceChar(stringBuffer, n3 + n4, c);
                    continue;
                }
                if (stringBuffer.charAt(n3 + n4 - 1) == '\u00b7') {
                    c = stringBuffer.charAt(n3 + n4 - 1);
                    this.replaceChar(stringBuffer, n3 + n4 - 1, HYPHENS[n5]);
                    arrayList.add(new HyphenationPoint(n4 + n3 - 1, n5, stringBuffer.toString()));
                    this.replaceChar(stringBuffer, n3 + n4 - 1, c);
                    continue;
                }
            }
            stringBuffer.insert(n4 + n3, HYPHENS[n5]);
            if (i + 1 < this.hyphensCount && (this.value[i + 1] & 0xFF) >= 220) {
                stringBuffer.insert(n4 + n3 + 1, HYPHENS[this.value[i + 1] & 0xFF]);
            }
            arrayList.add(new HyphenationPoint(n4 + n3, n5, stringBuffer.toString()));
            stringBuffer.deleteCharAt(n4 + n3);
        }
        return arrayList;
    }

    public static void buildHyphens() {
        int n;
        for (n = 0; n < REAL_HYPHENS.length && n < 128; ++n) {
            HyphenationGloss.HYPHENS[n] = REAL_HYPHENS[n];
        }
        n = 0;
        for (int i = 128; n < TEMP_HYPHENS.length && i < 220; ++i, ++n) {
            HyphenationGloss.HYPHENS[i] = TEMP_HYPHENS[n];
        }
    }

    public static int addSpecialHyphen(char c) {
        int n = 220;
        while (HYPHENS[n] != '\u0000') {
            if (++n < 256) continue;
            return -1;
        }
        HyphenationGloss.HYPHENS[n] = c;
        return n;
    }

    public static boolean replaceSpecialHyphen(int n, char c) {
        if (n > 256 || n < 220) {
            return false;
        }
        HyphenationGloss.HYPHENS[n] = c;
        return true;
    }

    private void replaceChar(StringBuffer stringBuffer, int n, char c) {
        stringBuffer.deleteCharAt(n);
        stringBuffer.insert(n, c);
    }

    static {
        HyphenationGloss.buildHyphens();
    }
}

