/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.HyphenationGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HyphenationRuleGloss
extends HyphenationGloss {
    private int llscreen;
    private int brscreen;
    private int estate;
    private int ruleno;
    private int escapedCharacters;
    private String rightContext;
    private String leftContext;
    private int nState;
    private int state;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public HyphenationRuleGloss() {
    }

    public HyphenationRuleGloss(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(string3);
        this.escapedCharacters = n7;
        this.rightContext = string;
        this.leftContext = string2;
        this.llscreen = n;
        this.brscreen = n2;
        this.ruleno = n3;
        this.estate = n4;
        this.nState = n5;
        this.state = n6;
    }

    @Override
    public int getType() {
        return 84;
    }

    @Override
    public final void read(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        super.read(dataInputStream, n);
        this.escapedCharacters = dataInputStream.readByte();
        int n3 = dataInputStream.readChar();
        char[] cArray = new char[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = dataInputStream.readChar();
        }
        this.rightContext = String.valueOf(cArray);
        n3 = dataInputStream.readChar();
        cArray = new char[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = dataInputStream.readChar();
        }
        this.leftContext = String.valueOf(cArray);
        this.llscreen = dataInputStream.readByte();
        this.brscreen = dataInputStream.readByte();
        this.ruleno = dataInputStream.readInt();
        this.estate = dataInputStream.readByte();
        this.nState = dataInputStream.readByte();
        this.state = dataInputStream.readByte();
    }

    @Override
    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        super.write(dataOutputStream, glossMapper);
        dataOutputStream.writeByte(this.escapedCharacters);
        dataOutputStream.writeChar(this.rightContext.length());
        dataOutputStream.writeChars(this.rightContext);
        dataOutputStream.writeChar(this.leftContext.length());
        dataOutputStream.writeChars(this.leftContext);
        dataOutputStream.writeByte(this.llscreen);
        dataOutputStream.writeByte(this.brscreen);
        dataOutputStream.writeInt(this.ruleno);
        dataOutputStream.writeByte(this.estate);
        dataOutputStream.writeByte(this.nState);
        dataOutputStream.writeByte(this.state);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HyphenationRuleGloss && super.equals(object) && ((HyphenationRuleGloss)object).getRuleno() == this.getRuleno() && ((HyphenationRuleGloss)object).getRightContext().equals(this.rightContext) && ((HyphenationRuleGloss)object).getLeftContext().equals(this.leftContext) && this.llscreen == ((HyphenationRuleGloss)object).llscreen && this.brscreen == ((HyphenationRuleGloss)object).brscreen && this.ruleno == ((HyphenationRuleGloss)object).ruleno && this.estate == ((HyphenationRuleGloss)object).estate && this.nState == ((HyphenationRuleGloss)object).nState && this.state == ((HyphenationRuleGloss)object).state && this.escapedCharacters == ((HyphenationRuleGloss)object).getEscapedCharacters();
    }

    @Override
    public int hashCode() {
        return this.ruleno + super.hashCode();
    }

    public int getBrscreen() {
        return this.brscreen;
    }

    public int getEstate() {
        return this.estate;
    }

    public int getLlscreen() {
        return this.llscreen;
    }

    public int getRuleno() {
        return this.ruleno;
    }

    public int getEscapedCharacters() {
        return this.escapedCharacters;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(Hyphenation Rule");
        stringBuffer.append("(" + super.toString() + ")");
        stringBuffer.append(",(right context=" + this.rightContext + ")");
        stringBuffer.append(",(left context=" + this.leftContext + ")");
        stringBuffer.append(",(EState=" + this.estate + ")");
        stringBuffer.append(",(rule number=" + this.ruleno + ")");
        stringBuffer.append(",(llscreen=" + this.llscreen + ")");
        stringBuffer.append(",(BRscreen=" + this.brscreen + "))");
        return stringBuffer.toString();
    }

    public String getLeftContext() {
        return this.leftContext;
    }

    public String getRightContext() {
        return this.rightContext;
    }

    public int getNState() {
        return this.nState;
    }

    public int getState() {
        return this.state;
    }
}

