/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IntegerGloss
extends Gloss {
    public int weight;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public IntegerGloss() {
        this.weight = 0;
    }

    public IntegerGloss(int n) {
        this.weight = n;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.weight = dataInputStream.readInt();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.weight);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntegerGloss && this.weight == ((IntegerGloss)object).weight;
    }

    @Override
    public boolean isSimilar(Object object) {
        return object instanceof IntegerGloss && this.weight == ((IntegerGloss)object).weight;
    }

    @Override
    public Gloss mergeGloss(Object object) {
        if (!(object instanceof IntegerGloss)) {
            return this;
        }
        if (this.weight < ((IntegerGloss)object).weight) {
            return this;
        }
        return (Gloss)object;
    }

    @Override
    public int hashCode() {
        return this.weight;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public String toString() {
        return "Int(" + this.weight + ")";
    }
}

