/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.trellis.StateMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;

public final class JaGramSetGloss
extends Gloss {
    private StateMatrix matrix;
    private int extraWeightPerLength;
    private int hash = 1;
    public static final Comparator<Long> comparator = new Comparator<Long>(){

        @Override
        public int compare(Long l, Long l2) {
            long l3 = l;
            long l4 = l2;
            int n = JaGramSetGloss.getStartState(l3) - JaGramSetGloss.getStartState(l4);
            if (n != 0) {
                return n;
            }
            n = JaGramSetGloss.getEndState(l3) - JaGramSetGloss.getEndState(l4);
            if (n != 0) {
                return n;
            }
            n = JaGramSetGloss.getWeight(l3) - JaGramSetGloss.getWeight(l4);
            if (n != 0) {
                return n;
            }
            return 0;
        }
    };

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public JaGramSetGloss() {
        this(new StateMatrix(), 0);
    }

    public JaGramSetGloss(int[] nArray, int[] nArray2, int[] nArray3) {
        this(new StateMatrix(nArray, nArray2, nArray3), 0);
    }

    public JaGramSetGloss(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        this(new StateMatrix(nArray, nArray2, nArray3), n);
    }

    public JaGramSetGloss(long[] lArray) {
        this(JaGramSetGloss.getMatrix(lArray), 0);
    }

    public JaGramSetGloss(long[] lArray, int n) {
        this(JaGramSetGloss.getMatrix(lArray), n);
    }

    public JaGramSetGloss(StateMatrix stateMatrix) {
        this(stateMatrix, 0);
    }

    public JaGramSetGloss(StateMatrix stateMatrix, int n) {
        this.matrix = stateMatrix;
        this.extraWeightPerLength = n;
        this.updateHashCode();
    }

    @Override
    public int getType() {
        return 34;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        if (n <= 0) {
            throw new DLTException(Messages.getString("error.streamformat"));
        }
        this.extraWeightPerLength = dataInputStream.readInt();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = dataInputStream.readLong();
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        this.matrix = new StateMatrix(nArray, nArray2, nArray3);
        this.updateHashCode();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n;
        int n2;
        long[] lArray = new long[this.matrix.size()];
        int n3 = 0;
        for (n2 = 0; n2 <= this.matrix.last(); ++n2) {
            n = this.matrix.index(n2);
            if (n < 0) continue;
            int n4 = this.matrix.head(n);
            int n5 = this.matrix.tail(n);
            for (int i = n4; i != n5; ++i) {
                int n6 = this.matrix.endStates(i);
                int n7 = this.matrix.weights(i);
                lArray[n3++] = JaGramSetGloss.getFlag(n2, n6, n7);
            }
        }
        n2 = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(lArray.length);
        dataOutputStream.writeInt(this.extraWeightPerLength);
        for (n = 0; n < lArray.length; ++n) {
            dataOutputStream.writeLong(lArray[n]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JaGramSetGloss jaGramSetGloss = (JaGramSetGloss)object;
        if (this.extraWeightPerLength != jaGramSetGloss.extraWeightPerLength) {
            return false;
        }
        return !(this.matrix == null ? jaGramSetGloss.matrix != null : !this.matrix.equals(jaGramSetGloss.matrix));
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    private void updateHashCode() {
        int n = 31;
        n = 31 * n + (this.matrix == null ? 0 : this.matrix.hashCode());
        this.hash = n = 31 * n + this.extraWeightPerLength;
    }

    @Override
    public String toString() {
        return String.format("Grs(%d)", this.hash);
    }

    public void add(long[] lArray) {
        this.add(lArray, 0);
    }

    public void add(long[] lArray, int n) {
        int[] nArray = new int[lArray.length];
        int[] nArray2 = new int[lArray.length];
        int[] nArray3 = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        this.matrix.add(nArray, nArray2, nArray3);
        this.extraWeightPerLength = n;
        this.updateHashCode();
    }

    public StateMatrix getData() {
        return this.matrix;
    }

    public int getExt() {
        return this.extraWeightPerLength;
    }

    static final int getStartState(long l) {
        return (int)(l >> 16 & 0xFFFFL);
    }

    static final int getEndState(long l) {
        return (int)(l & 0xFFFFL);
    }

    static final int getWeight(long l) {
        return (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static StateMatrix getMatrix(long[] lArray) {
        int[] nArray = new int[lArray.length];
        int[] nArray2 = new int[lArray.length];
        int[] nArray3 = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        return new StateMatrix(nArray, nArray2, nArray3);
    }

    public static final long getFlag(int n, int n2, int n3) {
        long l = 0L;
        l = ((long)n & 0xFFFFL) << 16;
        l |= (long)n2 & 0xFFFFL;
        return l |= ((long)n3 & 0xFFFFFFFFFFFFFFFFL) << 32;
    }
}

