/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.um.JPOS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JaMorphGloss
extends Gloss {
    private int jkom;
    private int jpos;
    private int extra;
    private static final int OFF_DIVIDABLE = 16;
    private static final int OFF_PHSTART = 24;
    private static final int MASK_DIVIDABLE = 65536;
    private static final int MASK_PHSTART = -16777216;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public JaMorphGloss() {
    }

    @Deprecated
    public JaMorphGloss(int n, int n2, int n3) {
        this(n, n2, n3 == 1, false);
    }

    public JaMorphGloss(int n, int n2, boolean bl, boolean bl2) {
        this.jkom = n;
        this.jpos = n2;
        this.extra = (bl2 ? 1 : 0) << 16 | (bl ? 1 : 0) << 24;
    }

    @Override
    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.jkom = dataInputStream.readInt();
        this.jpos = dataInputStream.readInt();
        this.extra = dataInputStream.readInt();
    }

    @Override
    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.jkom);
        dataOutputStream.writeInt(this.jpos);
        dataOutputStream.writeInt(this.extra);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("JaMorph(");
        stringBuffer.append(this.jkom).append(':').append(this.jpos).append(':');
        stringBuffer.append(this.getPhraseStart());
        stringBuffer.append(':');
        stringBuffer.append(this.getDividable());
        stringBuffer.append(')');
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof JaMorphGloss)) {
            return false;
        }
        JaMorphGloss jaMorphGloss = (JaMorphGloss)object;
        return jaMorphGloss.jkom == this.jkom && jaMorphGloss.jpos == this.jpos && jaMorphGloss.extra == this.extra;
    }

    @Override
    public final int hashCode() {
        return this.jkom ^ this.jpos ^ this.extra & 0xFF000000 ^ this.extra & 0x10000;
    }

    public final int getJKOM() {
        return this.jkom;
    }

    public final int getJPOS() {
        return this.jpos;
    }

    public final int getPhraseStart() {
        return (this.extra & 0xFF000000) >>> 24;
    }

    public final int getDividable() {
        return (this.extra & 0x10000) >>> 16;
    }

    public final boolean isDividable() {
        return this.getDividable() == 1;
    }

    public final boolean isNoun() {
        int n = JPOS.toPOS(this.jpos);
        return n == 3 || n == 0;
    }

    @Override
    public final int getType() {
        return 32;
    }
}

