/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JkomCollectionGloss
extends AbstractGlossVectorGloss {
    private int allflags;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public JkomCollectionGloss() {
    }

    public JkomCollectionGloss(int n, Gloss[] glossArray, int n2) throws DLTException {
        super(glossArray);
        this.allflags = n;
    }

    @Override
    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.allflags = dataInputStream.readInt();
        super.read_(dataInputStream, n);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.allflags);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof JkomCollectionGloss && this.allflags == ((JkomCollectionGloss)object).allflags && super.equals(object);
    }

    @Override
    public final int hashCode() {
        return super.hashCode_();
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public final String toString() {
        return "JkomCollection(" + this.getJKOM() + ")";
    }

    public int getJKOM() {
        return this.allflags;
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss[] glossArray = this.applyProcessorToElements(glossProcessor);
        JkomCollectionGloss jkomCollectionGloss = glossArray == this.element ? this : new JkomCollectionGloss(this.getJKOM(), glossArray, this.rtData);
        return (Gloss)glossProcessor.process(jkomCollectionGloss);
    }
}

