/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.um.KMorph;
import com.ibm.dltj.um.KPOS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumSet;

public class KoMorphGloss
extends Gloss {
    private int morph;
    private int pos;
    private int extra;
    private static final int POS_MASK_KPOS = 65535;
    private static final int POS_OFF_FLAGS = 16;
    private static final int POS_MASK_EP1 = 65536;
    private static final int POS_MASK_EP2 = 131072;
    private static final int POS_MASK_EP3 = 262144;
    private static final int POS_MASK_EP4 = 524288;
    private static final int POS_MASK_EP5 = 0x100000;
    private static final int POS_MASK_EC = 0x200000;
    private static final int POS_MASK_EF = 0x400000;
    private static final int POS_MASK_ETM = 0x800000;
    private static final int POS_MASK_ETN = 0x1000000;
    private static final int POS_OFF_SMORPH = 25;
    private static final int EXTRA_OFF_DIVIDABLE = 16;
    private static final int EXTRA_OFF_PHSTART = 24;
    private static final int EXTRA_MASK_DIVIDABLE = 65536;
    private static final int EXTRA_MASK_PHSTART = -16777216;
    private static final String EMPTY = "";

    public KoMorphGloss() {
    }

    public KoMorphGloss(int n, int n2, boolean bl, boolean bl2) {
        this.morph = n;
        this.pos = n2;
        this.extra = (bl2 ? 1 : 0) << 16 | (bl ? 1 : 0) << 24;
    }

    @Override
    public final void read(DataInputStream dataInputStream, int n) throws IOException {
        this.morph = dataInputStream.readInt();
        this.pos = dataInputStream.readInt();
        this.extra = dataInputStream.readInt();
    }

    @Override
    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.morph);
        dataOutputStream.writeInt(this.pos);
        dataOutputStream.writeInt(this.extra);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("KoMorph(");
        stringBuffer.append(this.morph).append(':').append(this.pos).append(':');
        stringBuffer.append(this.getPhraseStart());
        stringBuffer.append(':');
        stringBuffer.append(this.getDividable());
        stringBuffer.append(')');
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof KoMorphGloss)) {
            return false;
        }
        KoMorphGloss koMorphGloss = (KoMorphGloss)object;
        return koMorphGloss.morph == this.morph && koMorphGloss.pos == this.pos && koMorphGloss.extra == this.extra;
    }

    @Override
    public final int hashCode() {
        return this.morph ^ this.pos ^ this.extra & 0xFF000000 ^ this.extra & 0x10000;
    }

    public final int getMorph() {
        return this.morph;
    }

    public final int getPOS() {
        return this.pos;
    }

    public final KPOS getKPOS() {
        return KPOS.createFromIntegerCode(this.pos & 0xFFFF);
    }

    public final int setInflectionFlags(EnumSet<KPOS> enumSet) {
        for (KPOS kPOS : enumSet) {
            switch (kPOS) {
                case EP1: {
                    this.pos |= 0x10000;
                    break;
                }
                case EP2: {
                    this.pos |= 0x20000;
                    break;
                }
                case EP3: {
                    this.pos |= 0x40000;
                    break;
                }
                case EP4: {
                    this.pos |= 0x80000;
                    break;
                }
                case EP5: {
                    this.pos |= 0x100000;
                    break;
                }
                case EC: {
                    this.pos |= 0x200000;
                    break;
                }
                case EF: {
                    this.pos |= 0x400000;
                    break;
                }
                case ETM: {
                    this.pos |= 0x800000;
                    break;
                }
                case ETN: {
                    this.pos |= 0x1000000;
                    break;
                }
            }
        }
        return this.pos;
    }

    public final int encodeShortMorphCode(int n) {
        int n2 = 0;
        KPOS kPOS = this.getKPOS();
        switch (kPOS) {
            case VV: 
            case VVJ: 
            case VCP: 
            case VCN: 
            case VA: {
                if (200 >= n || n >= 290) break;
                n2 = n - 200;
                break;
            }
            case VVX: 
            case VAX: {
                if (290 < n && n < 300) {
                    n2 = n - 290;
                    break;
                }
                if (76 > n || n > 79) break;
                n2 = n;
                break;
            }
            case VXV: 
            case VXJ: 
            case VXA: {
                if (400 >= n || n >= 464) break;
                n2 = n - 400;
                break;
            }
        }
        if (n2 != 0) {
            this.pos |= n2 << 25;
        }
        return n2;
    }

    public final boolean isInflected(KPOS kPOS) {
        switch (kPOS) {
            case EP1: {
                return (this.pos & 0x10000) != 0;
            }
            case EP2: {
                return (this.pos & 0x20000) != 0;
            }
            case EP3: {
                return (this.pos & 0x40000) != 0;
            }
            case EP4: {
                return (this.pos & 0x80000) != 0;
            }
            case EP5: {
                return (this.pos & 0x100000) != 0;
            }
            case EC: {
                return (this.pos & 0x200000) != 0;
            }
            case EF: {
                return (this.pos & 0x400000) != 0;
            }
            case ETM: {
                return (this.pos & 0x800000) != 0;
            }
            case ETN: {
                return (this.pos & 0x1000000) != 0;
            }
        }
        return false;
    }

    public final String getEncodedTags() {
        if (this.pos >>> 16 == 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.pos & 0x10000) != 0) {
            stringBuilder.append("_EP1");
        }
        if ((this.pos & 0x20000) != 0) {
            stringBuilder.append("_EP2");
        }
        if ((this.pos & 0x40000) != 0) {
            stringBuilder.append("_EP3");
        }
        if ((this.pos & 0x80000) != 0) {
            stringBuilder.append("_EP4");
        }
        if ((this.pos & 0x100000) != 0) {
            stringBuilder.append("_EP5");
        }
        if ((this.pos & 0x200000) != 0) {
            stringBuilder.append("_EC");
        }
        if ((this.pos & 0x400000) != 0) {
            stringBuilder.append("_EF");
        }
        if ((this.pos & 0x800000) != 0) {
            stringBuilder.append("_ETM");
        }
        if ((this.pos & 0x1000000) != 0) {
            stringBuilder.append("_ETN");
        }
        return stringBuilder.toString();
    }

    public final int getShortMorphCode() {
        return this.pos >>> 25;
    }

    public final int getPhraseStart() {
        return (this.extra & 0xFF000000) >>> 24;
    }

    public final int getDividable() {
        return (this.extra & 0x10000) >>> 16;
    }

    public final boolean isDividable() {
        return this.getDividable() == 1;
    }

    public final boolean isNoun() {
        KMorph kMorph = KMorph.createFromIntegerCode(this.morph);
        int n = kMorph.getPos();
        return n == 3 || n == 0;
    }

    @Override
    public final int getType() {
        return 30;
    }
}

