/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.AbstractCharVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class LemmaTransformCodeGloss
extends AbstractCharVectorGloss
implements LemmaGenerator.ForLemma {
    private static final char CODE_ACCEPT = '!';
    private static final char CODE_DELETE = '~';
    private static final char CODE_DELETE_ALL = '^';

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public LemmaTransformCodeGloss() {
    }

    public LemmaTransformCodeGloss(String string) {
        super(string);
    }

    protected CharacterIterator getAppropriateCharacterIterator(CharacterIterator characterIterator) {
        return characterIterator;
    }

    @Override
    public void appendLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) {
        int n3;
        char c;
        CharacterIterator characterIterator2 = this.getAppropriateCharacterIterator(characterIterator);
        int n4 = characterIterator2.getIndex();
        characterIterator2.setIndex(n2);
        boolean bl = true;
        block9: for (c = this.value.length() - 1; c >= '\u0000'; --c) {
            n3 = this.value.charAt(c);
            switch (n3) {
                case 33: 
                case 126: {
                    characterIterator2.previous();
                    continue block9;
                }
                case 94: {
                    bl = false;
                }
            }
        }
        if (bl) {
            Utils.makeString(stringBuilder, characterIterator2, n, characterIterator2.getIndex());
        }
        c = characterIterator2.current();
        block10: for (n3 = 0; n3 < this.value.length(); ++n3) {
            char c2 = this.value.charAt(n3);
            switch (c2) {
                case '~': {
                    c = characterIterator2.next();
                    continue block10;
                }
                case '!': {
                    stringBuilder.append(c);
                    c = characterIterator2.next();
                    continue block10;
                }
                case '^': {
                    continue block10;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        characterIterator2.setIndex(n4);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        this.appendLemma(characterIterator, n, n2, stringBuilder);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        stringBuffer.append((CharSequence)stringBuilder);
    }

    @Override
    public String getLemma(CharacterIterator characterIterator, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public int getType() {
        return 72;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        super.read_(dataInputStream, n);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        super.write_(dataOutputStream, glossMapper);
    }

    @Override
    public int getMinSourceLength() {
        return 0;
    }

    @Override
    public String toString() {
        return "TransformCode(" + this.value + ")";
    }

    @Override
    public int hashCode() {
        return this.hashCode_();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof LemmaTransformCodeGloss && super.equals(object);
    }

    public static Collection<Code> getCodes(String string, String string2) {
        return LemmaTransformCodeGloss.buildCode(string, string2, true, -1);
    }

    private static Collection<Code> buildCode(String string, String string2, boolean bl, int n) {
        ArrayList<Code> arrayList = new ArrayList<Code>(100);
        int n2 = LemmaTransformCodeGloss.findLongestSubstring(string, string2);
        if (n2 != 0 && (n == -1 || n2 < n)) {
            int n3 = 0;
            while (n3 + n2 < string2.length() + 1) {
                String string3;
                int n4 = 0;
                while (n4 + n2 < string.length() + 1 && (n4 = string.indexOf(string3 = string2.substring(n3, n3 + n2), n4)) >= 0) {
                    ArrayList<Code> arrayList2;
                    Collection<Code> collection;
                    String string4 = string2.substring(0, n3);
                    if (n4 > 0 && n3 > 0) {
                        collection = LemmaTransformCodeGloss.buildCode(string.substring(0, n4), string4, bl, n2);
                    } else {
                        arrayList2 = new StringBuilder();
                        if (n4 > 0) {
                            LemmaTransformCodeGloss.addDeletes((StringBuilder)((Object)arrayList2), n4, bl);
                        }
                        ((StringBuilder)((Object)arrayList2)).append(string4);
                        collection = new ArrayList<Code>(1);
                        collection.add(new Code(((StringBuilder)((Object)arrayList2)).toString()));
                    }
                    String string5 = string2.substring(n3 + n2);
                    if (string.length() - n4 - n2 > 0 && string2.length() - n3 - n2 > 0) {
                        arrayList2 = LemmaTransformCodeGloss.buildCode(string.substring(n4 + n2), string5, false, -1);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        LemmaTransformCodeGloss.addDeletes(stringBuilder, string.length() - n4 - n2, false);
                        stringBuilder.append(string5);
                        arrayList2 = new ArrayList<Code>(1);
                        arrayList2.add(new Code(stringBuilder.toString()));
                    }
                    for (Code code : collection) {
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            StringBuffer stringBuffer = new StringBuffer(code.getCode());
                            if (n4 > 0 | n3 > 0) {
                                for (int i = n2; i > 0; --i) {
                                    stringBuffer.append('!');
                                }
                            }
                            Code code2 = (Code)iterator.next();
                            stringBuffer.append(code2.getCode());
                            arrayList.add(new Code(stringBuffer.toString()));
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        LemmaTransformCodeGloss.addDeletes(stringBuilder, string.length(), bl);
        stringBuilder.append(string2);
        arrayList.add(new Code(stringBuilder.toString()));
        return arrayList;
    }

    private static void addDeletes(StringBuilder stringBuilder, int n, boolean bl) {
        if (bl) {
            stringBuilder.append('^');
        } else {
            for (int i = n; i > 0; --i) {
                stringBuilder.append('~');
            }
        }
    }

    private static int findLongestSubstring(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n2 + n < string2.length()) {
            String string3;
            int n3 = 0;
            while (n3 + n < string.length() && n2 + n < string2.length() && (n3 = string.indexOf(string3 = string2.substring(n2, n2 + n + 1), n3)) >= 0) {
                while (n2 + n + 1 < string2.length() && n3 + n + 1 < string.length() && string.charAt(n3 + n + 1) == string2.charAt(n2 + n + 1)) {
                    ++n;
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public static class Code {
        private final String _code;

        Code(String string) {
            this._code = string;
        }

        public String getCode() {
            return this._code;
        }

        public int insertedChars() {
            int n = 0;
            int n2 = this._code.length();
            if (n2 == 0) {
                return 0;
            }
            for (int i = 0; i < n2; ++i) {
                char c = this._code.charAt(i);
                if (c == '!' || c == '~' || c == '^') continue;
                n += 10;
            }
            return n;
        }
    }
}

