/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.util.SizedIOBuffers;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;

public class MWEntryLemmaGloss
extends MidGloss
implements LemmaGenerator {
    private int lemma_group;
    private LemmaGenerator lemma_gloss;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWEntryLemmaGloss(Gloss gloss, Gloss gloss2, int n) throws DLTException {
        Gloss[] glossArray;
        if (gloss2 == null) {
            Gloss[] glossArray2 = new Gloss[1];
            glossArray = glossArray2;
            glossArray2[0] = gloss;
        } else {
            Gloss[] glossArray3 = new Gloss[2];
            glossArray3[0] = gloss;
            glossArray = glossArray3;
            glossArray3[1] = gloss2;
        }
        super(glossArray);
        this.lemma_gloss = (LemmaGenerator)((Object)gloss);
        this.lemma_group = n;
    }

    private MWEntryLemmaGloss(Gloss[] glossArray, int n) {
        this.lemma_group = n;
        this.element = glossArray;
        this.lemma_gloss = (LemmaGenerator)((Object)glossArray[0]);
    }

    public MWEntryLemmaGloss() {
        this.lemma_group = -1;
        this.lemma_gloss = null;
        this.element = null;
    }

    public int getLemmaGroup() {
        return this.lemma_group;
    }

    @Override
    public int getType() {
        return 58;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        DataInput dataInput = SizedIOBuffers.allocateInput(dataInputStream);
        try {
            MapperGloss mapperGloss = new MapperGloss(dataInput.readInt());
            this.lemma_group = dataInput.readInt();
            this.lemma_gloss = null;
            n = dataInput.readInt() + 1;
            this.element = new Gloss[n];
            this.element[0] = mapperGloss;
            for (int i = 1; i < n; ++i) {
                this.element[i] = new MapperGloss(dataInput.readInt());
            }
        }
        finally {
            SizedIOBuffers.finalizeInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        DataOutput dataOutput = SizedIOBuffers.allocateOutput();
        try {
            dataOutput.writeInt(glossMapper.getGlossIndex(this.element[0]));
            dataOutput.writeInt(this.lemma_group);
            dataOutput.writeInt(this.element.length - 1);
            for (int i = 1; i < this.element.length; ++i) {
                dataOutput.writeInt(glossMapper.getGlossIndex(this.element[i]));
            }
        }
        finally {
            SizedIOBuffers.finalizeOutput(dataOutputStream);
        }
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        this.lemma_gloss = (LemmaGenerator)((Object)this.element[0]);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        this.lemma_gloss.getLemma(characterIterator, n, n2, stringBuilder);
    }

    @Override
    public void appendLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        this.lemma_gloss.appendLemma(characterIterator, n, n2, stringBuilder);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) throws DLTException {
        this.lemma_gloss.getLemma(characterIterator, n, n2, stringBuffer);
    }

    @Override
    public String getLemma(CharacterIterator characterIterator, int n, int n2) throws DLTException {
        return this.lemma_gloss.getLemma(characterIterator, n, n2);
    }

    @Override
    public int getMinSourceLength() {
        return this.lemma_gloss.getMinSourceLength();
    }

    @Override
    public int hashCode() {
        return Utils.combineHash(super.hashCode(), this.lemma_group);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof MWEntryLemmaGloss) {
            MWEntryLemmaGloss mWEntryLemmaGloss = (MWEntryLemmaGloss)object;
            return this.lemma_group == mWEntryLemmaGloss.lemma_group && super.equals(mWEntryLemmaGloss);
        }
        return false;
    }

    public boolean equalsIgnoreLemmaGroup(Object object) {
        if (object instanceof MWEntryLemmaGloss) {
            MWEntryLemmaGloss mWEntryLemmaGloss = (MWEntryLemmaGloss)object;
            return super.equals(mWEntryLemmaGloss);
        }
        return false;
    }

    @Override
    public String toString() {
        return "MWE(" + super.toString() + " group " + this.lemma_group + ")";
    }

    public MWEntryLemmaGloss copyNewLemmaGroup(int n) throws DLTException {
        return new MWEntryLemmaGloss(this.element, n);
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss[] glossArray = this.applyProcessorToElements(glossProcessor);
        MWEntryLemmaGloss mWEntryLemmaGloss = glossArray == this.element ? this : new MWEntryLemmaGloss(glossArray, this.lemma_group);
        return (Gloss)glossProcessor.process(mWEntryLemmaGloss);
    }
}

