/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.Validate;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MWValidationGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MWGloss
extends Gloss
implements LemmaGenerator {
    private int[] startOffsets;
    private int[] endOffsets;
    private final Gloss validationGloss;
    private final List<List<LemmaGenerator>> wordLemmaGlosses;
    static final Validate TrueValidator = new Validate(){

        @Override
        public boolean validate(AnnotateContext annotateContext) throws AnnotateException {
            return true;
        }
    };

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    MWGloss(int[] nArray, int[] nArray2, Gloss gloss, List<List<LemmaGenerator>> list) {
        assert (nArray != null);
        assert (nArray2 != null);
        this.startOffsets = nArray;
        this.endOffsets = nArray2;
        this.validationGloss = gloss;
        this.wordLemmaGlosses = list;
    }

    public static MWGloss createMWGloss(int[] nArray, int[] nArray2, Gloss gloss, List<List<LemmaGenerator>> list) {
        if (MWGloss.getUserGloss(gloss) instanceof Annotate) {
            return new AnnotateMWGloss(nArray, nArray2, gloss, list);
        }
        return new MWGloss(nArray, nArray2, gloss, list);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MWGloss)) {
            return false;
        }
        MWGloss mWGloss = (MWGloss)object;
        if (!Arrays.equals(this.startOffsets, mWGloss.startOffsets)) {
            return false;
        }
        if (!Arrays.equals(this.endOffsets, mWGloss.endOffsets)) {
            return false;
        }
        if (!this.validationGloss.equals(mWGloss.validationGloss)) {
            return false;
        }
        return ((Object)this.wordLemmaGlosses).equals(mWGloss.wordLemmaGlosses);
    }

    @Override
    public int getType() {
        return 59;
    }

    @Override
    public int hashCode() {
        return super.quickHashCode();
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws DLTException {
        throw new DLTException(Messages.getString("error.gloss.savetype"));
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws DLTException {
        throw new DLTException(Messages.getString("error.gloss.savetype"));
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        assert (false);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MW(");
        stringBuffer.append(Arrays.toString(this.startOffsets) + "; ");
        stringBuffer.append(Arrays.toString(this.endOffsets) + "; ");
        stringBuffer.append(this.getUserGloss() + ") ");
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }

    public int[] getEndOffsets() {
        return this.endOffsets;
    }

    public int[] getStartOffsets() {
        return this.startOffsets;
    }

    public List getWordLemmaGlosses() {
        return this.wordLemmaGlosses;
    }

    @Override
    public void appendLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        if (this.validationGloss instanceof MWValidationGloss) {
            LemmaGenerator lemmaGenerator;
            MWValidationGloss mWValidationGloss = (MWValidationGloss)this.validationGloss;
            if (mWValidationGloss.getUserGloss() instanceof LemmaGenerator) {
                ((LemmaGenerator)((Object)mWValidationGloss.getUserGloss())).appendLemma(characterIterator, n, n2, stringBuilder);
                return;
            }
            if (mWValidationGloss.getUserGloss() instanceof MidGloss && (lemmaGenerator = ((MidGloss)mWValidationGloss.getUserGloss()).getLemmaGloss()) != null) {
                lemmaGenerator.appendLemma(characterIterator, n, n2, stringBuilder);
                return;
            }
            if (this.wordLemmaGlosses != null) {
                int n3 = this.wordLemmaGlosses.size();
                int[] nArray = mWValidationGloss.getWordOrder();
                if (nArray == null) {
                    for (int i = 0; i < n3; ++i) {
                        LemmaGenerator lemmaGenerator2 = this.wordLemmaGlosses.get(n3 - 1 - i).get(0);
                        if (lemmaGenerator2 != null) {
                            lemmaGenerator2.appendLemma(characterIterator, n + this.startOffsets[i], n + this.endOffsets[i], stringBuilder);
                        } else {
                            Utils.makeString(stringBuilder, characterIterator, n + this.startOffsets[i], n + this.endOffsets[i]);
                        }
                        if (i >= n3 - 1) continue;
                        stringBuilder.append(' ');
                    }
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>(n3);
                    for (int i = 0; i < n3; ++i) {
                        List<LemmaGenerator> list = this.wordLemmaGlosses.get(n3 - 1 - i);
                        for (int j = 0; j < list.size(); ++j) {
                            LemmaGenerator lemmaGenerator3 = list.get(j);
                            if (lemmaGenerator3 != null) {
                                arrayList.add(lemmaGenerator3.getLemma(characterIterator, n + this.startOffsets[i], n + this.endOffsets[i]));
                                continue;
                            }
                            arrayList.add(Utils.makeString(characterIterator, n + this.startOffsets[i], n + this.endOffsets[i]));
                        }
                    }
                    Gloss[] glossArray = mWValidationGloss.getOptionalWords();
                    if (glossArray != null) {
                        for (int i = 0; i < glossArray.length; ++i) {
                            arrayList.add(((LemmaGloss)glossArray[i]).getValue());
                        }
                    }
                    Utils.removeDuplicates(arrayList);
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuilder.append((String)arrayList.get(nArray[i]));
                        if (i >= nArray.length - 1) continue;
                        stringBuilder.append(' ');
                    }
                }
                return;
            }
        } else if (this.validationGloss instanceof LemmaGenerator) {
            ((LemmaGenerator)((Object)this.validationGloss)).appendLemma(characterIterator, n, n2, stringBuilder);
            return;
        }
        for (int i = 0; i < this.startOffsets.length; ++i) {
            Utils.makeString(stringBuilder, characterIterator, n + this.startOffsets[i], n + this.endOffsets[i]);
            if (i >= this.startOffsets.length - 1) continue;
            stringBuilder.append(' ');
        }
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        stringBuilder.setLength(0);
        this.appendLemma(characterIterator, n, n2, stringBuilder);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) throws DLTException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        stringBuffer.append((CharSequence)stringBuilder);
    }

    public MWGloss getCopyWithAdjustedOffsets(int n, int n2) {
        int n3 = n - n2;
        if (n3 == 0) {
            return this;
        }
        int[] nArray = new int[this.startOffsets.length];
        int[] nArray2 = new int[this.endOffsets.length];
        System.arraycopy(this.startOffsets, 0, nArray, 0, this.startOffsets.length);
        System.arraycopy(this.endOffsets, 0, nArray2, 0, this.endOffsets.length);
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = n4;
            nArray[n5] = nArray[n5] + n3;
            int n6 = n4++;
            nArray2[n6] = nArray2[n6] + n3;
        }
        MWGloss mWGloss = MWGloss.createMWGloss(nArray, nArray2, this.validationGloss, this.wordLemmaGlosses);
        return mWGloss;
    }

    @Override
    public String getLemma(CharacterIterator characterIterator, int n, int n2) throws DLTException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public int getMinSourceLength() {
        return this.endOffsets[this.endOffsets.length - 1] - this.startOffsets[0];
    }

    public Gloss getUserGloss() {
        if (this.validationGloss instanceof MWValidationGloss) {
            return ((MWValidationGloss)this.validationGloss).getUserGloss();
        }
        return this.validationGloss;
    }

    private static Gloss getUserGloss(Gloss gloss) {
        if (gloss instanceof MWValidationGloss) {
            return ((MWValidationGloss)gloss).getUserGloss();
        }
        return gloss;
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        throw new DLTException(Messages.getString("error.gloss.savetype"));
    }

    private static class AnnotateMWGloss
    extends MWGloss
    implements Annotate,
    Validate {
        final Annotate annotate = (Annotate)((Object)this.getUserGloss());
        final Validate validate = this.annotate instanceof Validate ? (Validate)((Object)this.annotate) : TrueValidator;

        AnnotateMWGloss(int[] nArray, int[] nArray2, Gloss gloss, List<List<LemmaGenerator>> list) {
            super(nArray, nArray2, gloss, list);
        }

        @Override
        public void annotate(AnnotateContext annotateContext) throws AnnotateException {
            this.annotate.annotate(annotateContext);
        }

        @Override
        public boolean validate(AnnotateContext annotateContext) throws AnnotateException {
            return this.validate.validate(annotateContext);
        }
    }
}

