/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MWUGloss
extends AbstractGlossVectorGloss {
    private Gloss definitionGloss;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUGloss() {
    }

    public MWUGloss(Gloss gloss) {
        this.definitionGloss = gloss;
    }

    public MWUGloss(Gloss gloss, MWElementGloss[] mWElementGlossArray) throws DLTException {
        super(mWElementGlossArray);
        this.definitionGloss = gloss;
    }

    public Gloss getDefinitionGloss() {
        return this.definitionGloss;
    }

    @Override
    public int getType() {
        return 56;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        super.read_(dataInputStream, n);
        int n2 = dataInputStream.readInt();
        if (n2 >= 0) {
            this.definitionGloss = new MapperGloss(n2);
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        if (this.element.length == 0) {
            throw new DLTException(Messages.getString("error.length"));
        }
        super.write_(dataOutputStream, glossMapper);
        int n = -1;
        if (this.definitionGloss != null) {
            n = glossMapper.getGlossIndex(this.definitionGloss);
        }
        dataOutputStream.writeInt(n);
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        if (this.definitionGloss instanceof MapperGloss) {
            this.definitionGloss = glossArray[((MapperGloss)this.definitionGloss).map];
        }
    }

    public void addMWE(MWElementGloss mWElementGloss) {
        Gloss[] glossArray = new Gloss[this.element.length + 1];
        System.arraycopy(this.element, 0, glossArray, 0, this.element.length);
        glossArray[this.element.length] = mWElementGloss;
        this.element = glossArray;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public String toString() {
        return "MWUnit";
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss[] glossArray = this.applyProcessorToElements(glossProcessor);
        Gloss gloss = this.definitionGloss.applyGlossProcessor(glossProcessor);
        MWUGloss mWUGloss = glossArray == this.element && gloss == this.definitionGloss ? this : new MWUGloss(gloss, (MWElementGloss[])glossArray);
        return (Gloss)glossProcessor.process(mWUGloss);
    }
}

