/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.util.SizedIOBuffers;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MWValidationGloss
extends Gloss {
    private int separation_num = 0;
    private int[] word_order;
    private Gloss[] opt_words;
    private int lemma_group_index;
    private Gloss userGloss;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWValidationGloss() {
    }

    public MWValidationGloss(Gloss gloss, int n, int[] nArray, Gloss[] glossArray) {
        this.separation_num = n;
        this.word_order = nArray;
        this.lemma_group_index = -1;
        this.opt_words = glossArray;
        this.userGloss = gloss;
    }

    public MWValidationGloss(Gloss gloss, int n, int[] nArray, Gloss[] glossArray, int n2) {
        this.separation_num = n;
        this.word_order = nArray;
        this.lemma_group_index = n2;
        this.opt_words = glossArray;
        this.userGloss = gloss;
    }

    public MWValidationGloss(Gloss gloss, int n) {
        this.separation_num = n;
        this.lemma_group_index = -1;
        this.userGloss = gloss;
    }

    @Override
    public int getType() {
        return 57;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        DataInput dataInput = SizedIOBuffers.allocateInput(dataInputStream);
        try {
            int n2;
            this.separation_num = 0;
            this.lemma_group_index = 0;
            this.word_order = null;
            this.opt_words = null;
            this.userGloss = new MapperGloss(dataInput.readInt());
            this.separation_num = dataInput.readInt();
            this.lemma_group_index = dataInput.readInt();
            int n3 = dataInput.readInt();
            if (n3 > 0) {
                this.word_order = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.word_order[n2] = dataInput.readInt();
                }
            } else {
                this.word_order = null;
            }
            if ((n2 = dataInput.readInt()) > 0) {
                this.opt_words = new Gloss[n2];
                for (int i = 0; i < n2; ++i) {
                    this.opt_words[i] = new MapperGloss(dataInput.readInt());
                }
            } else {
                this.opt_words = null;
            }
        }
        finally {
            SizedIOBuffers.finalizeInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        DataOutput dataOutput = SizedIOBuffers.allocateOutput();
        try {
            int n2;
            dataOutput.writeInt(glossMapper.getGlossIndex(this.userGloss));
            dataOutput.writeInt(this.separation_num);
            dataOutput.writeInt(this.lemma_group_index);
            if (this.word_order == null) {
                dataOutput.writeInt(0);
            } else {
                dataOutput.writeInt(this.word_order.length);
                for (n2 = 0; n2 < this.word_order.length; ++n2) {
                    dataOutput.writeInt(this.word_order[n2]);
                }
            }
            if (this.opt_words != null) {
                dataOutput.writeInt(this.opt_words.length);
                for (n2 = 0; n2 < this.opt_words.length; ++n2) {
                    dataOutput.writeInt(glossMapper.getGlossIndex(this.opt_words[n2]));
                }
            } else {
                dataOutput.writeInt(0);
            }
        }
        finally {
            SizedIOBuffers.finalizeOutput(dataOutputStream);
        }
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        this.userGloss = glossArray[((MapperGloss)this.userGloss).map];
        if (this.opt_words != null && this.opt_words.length > 0 && this.opt_words[0] instanceof MapperGloss) {
            for (int i = 0; i < this.opt_words.length; ++i) {
                this.opt_words[i] = glossArray[((MapperGloss)this.opt_words[i]).map];
            }
        }
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = (n << 1 ^ this.separation_num) << 1 ^ this.lemma_group_index;
        if (this.word_order != null) {
            n = n << 1 ^ Arrays.hashCode(this.word_order);
        }
        if (this.opt_words != null) {
            n = n << 1 ^ Arrays.hashCode(this.opt_words);
        }
        if (this.userGloss != null) {
            n += this.userGloss.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MWValidation(");
        stringBuilder.append(this.separation_num);
        if (this.word_order != null) {
            stringBuilder.append("; " + Arrays.toString(this.word_order));
        }
        if (this.lemma_group_index != -1) {
            stringBuilder.append("; " + this.lemma_group_index);
        }
        stringBuilder.append("; " + this.userGloss.toString() + ")");
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public int getSeparationNumber() {
        return this.separation_num;
    }

    public int[] getWordOrder() {
        return this.word_order;
    }

    public Gloss[] getOptionalWords() {
        return this.opt_words;
    }

    public void setLemmaGroupIndex(int n) {
        this.lemma_group_index = n;
    }

    public int getLemmaGroupIndex() {
        return this.lemma_group_index;
    }

    public Gloss getUserGloss() {
        return this.userGloss;
    }

    @Override
    public int numChildren() {
        return 1 + (this.opt_words != null ? this.opt_words.length : 0);
    }

    @Override
    public Gloss getChild(int n) {
        if (n == 0) {
            return this.userGloss;
        }
        if (this.opt_words == null || n >= 1 + this.opt_words.length) {
            return null;
        }
        return this.opt_words[n - 1];
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MWValidationGloss)) {
            return false;
        }
        MWValidationGloss mWValidationGloss = (MWValidationGloss)object;
        if (this.separation_num != mWValidationGloss.separation_num) {
            return false;
        }
        if (this.lemma_group_index != mWValidationGloss.lemma_group_index) {
            return false;
        }
        if (!Arrays.equals(this.word_order, mWValidationGloss.word_order)) {
            return false;
        }
        if (!Arrays.equals(this.opt_words, mWValidationGloss.opt_words)) {
            return false;
        }
        return this.userGloss.equals(mWValidationGloss.userGloss);
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss[] glossArray = this.opt_words;
        if (this.opt_words != null) {
            glossArray = new Gloss[this.opt_words.length];
            boolean bl = false;
            for (int i = 0; i < this.opt_words.length; ++i) {
                glossArray[i] = this.opt_words[i].applyGlossProcessor(glossProcessor);
                bl = bl || glossArray[i] != this.opt_words[i];
            }
            if (!bl) {
                glossArray = this.opt_words;
            }
        }
        Gloss gloss = this.userGloss.applyGlossProcessor(glossProcessor);
        MWValidationGloss mWValidationGloss = glossArray == this.opt_words && gloss == this.userGloss ? this : new MWValidationGloss(gloss, this.separation_num, this.word_order, glossArray, this.lemma_group_index);
        return (Gloss)glossProcessor.process(mWValidationGloss);
    }

    public Gloss copyNewLemmaGroup(int n) {
        return new MWValidationGloss(this.userGloss, this.separation_num, this.word_order, this.opt_words, n);
    }
}

