/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class PosCollectionGloss
extends AbstractGlossVectorGloss {
    int allflags;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public PosCollectionGloss() {
    }

    public PosCollectionGloss(int n, Gloss[] glossArray, int n2) throws DLTException {
        super(glossArray);
        if ((n ^ n & 0xFF) != 0) {
            throw new DLTException(Messages.getString("invalid.pos"));
        }
        this.allflags = (n & 0xFF) << 24;
    }

    @Override
    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.allflags = dataInputStream.readInt();
        super.read_(dataInputStream, n);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.allflags);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof PosCollectionGloss && this.allflags == ((PosCollectionGloss)object).allflags && super.equals(object);
    }

    @Override
    public boolean isSimilar(Object object) {
        if (!(object instanceof PosCollectionGloss)) {
            return false;
        }
        return this.getPOS() == ((PosCollectionGloss)object).getPOS();
    }

    @Override
    public Gloss mergeGloss(Object object) {
        Object object2;
        int n;
        if (object.getClass() != this.getClass()) {
            return this;
        }
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>();
        PosCollectionGloss posCollectionGloss = (PosCollectionGloss)object;
        for (n = 0; n < this.element.length; ++n) {
            arrayList.add(this.element[n]);
        }
        for (n = 0; n < posCollectionGloss.numChildren(); ++n) {
            boolean bl = false;
            object2 = posCollectionGloss.getChild(n);
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                if (!((Gloss)object2).equals(arrayList.get(i))) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add((Gloss)object2);
        }
        Gloss[] glossArray = new Gloss[arrayList.size()];
        arrayList.toArray(glossArray);
        Class<?> clazz = this.getClass();
        try {
            object2 = clazz.getConstructor(Integer.TYPE, Gloss[].class, Integer.TYPE);
            return (Gloss)((Constructor)object2).newInstance(this.getPOS(), glossArray, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return this;
    }

    @Override
    public final int hashCode() {
        return super.hashCode_();
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PosCollection(" + FeatureSetGloss.getPOSName(this.getPOS()) + ": ");
        for (int i = 0; i < this.element.length; ++i) {
            stringBuffer.append(this.element[i].toString());
            stringBuffer.append(';');
        }
        stringBuffer.append(')');
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }

    public int getPOS() {
        return this.allflags >>> 24 & 0xFF;
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss[] glossArray = this.applyProcessorToElements(glossProcessor);
        PosCollectionGloss posCollectionGloss = glossArray == this.element ? this : new PosCollectionGloss(this.getPOS(), glossArray, this.rtData);
        return (Gloss)glossProcessor.process(posCollectionGloss);
    }
}

