/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class StringArrayGloss
extends Gloss {
    private String[] strings;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public StringArrayGloss() {
    }

    public StringArrayGloss(String[] stringArray) {
        this.strings = stringArray;
    }

    public StringArrayGloss(List<String> list) {
        this(list.toArray(new String[list.size()]));
    }

    public String[] getStrings() {
        return this.strings;
    }

    @Override
    public int getType() {
        return 86;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.strings = new String[n];
        for (int i = 0; i < n; ++i) {
            this.strings[i] = AutoGlossSupport.readString(dataInputStream);
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.strings.length);
        for (String string : this.strings) {
            AutoGlossSupport.writeString(dataOutputStream, string);
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.strings);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StringArrayGloss stringArrayGloss = (StringArrayGloss)object;
        return Arrays.equals(this.strings, stringArrayGloss.strings);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.strings);
    }
}

