/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TCRGloss
extends Gloss {
    public static final byte DLT_CORRECTION_TYPE_UNDEFINED = 0;
    public static final byte DLT_CORRECTION_TYPE_PHONETIC = 1;
    public static final byte DLT_CORRECTION_TYPE_KEYBOARD = 2;
    public static final byte DLT_CORRECTION_TYPE_OCR = 3;
    public static final byte DLT_CORRECTION_TYPE_SYNONYM = 4;
    public static final byte DLT_CORRECTION_TYPE_NATIONALKEYBOARD = 5;
    private int allflags;
    public char[] charValue;
    private static final char[] EMPTY = new char[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TCRGloss() {
        this.allflags = 0;
        this.charValue = EMPTY;
    }

    public TCRGloss(int n, int n2, int n3, String string) throws DLTException {
        if ((n & (n ^ 0xFF) | n2 & (n2 ^ 0xFF) | n3 & (n3 ^ 0xFF)) != 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        this.allflags = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        this.charValue = string.toCharArray();
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.allflags = dataInputStream.readInt();
        dataInputStream.readInt();
        this.charValue = new char[n];
        for (int i = 0; i < n; ++i) {
            this.charValue[i] = dataInputStream.readChar();
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.charValue.length);
        dataOutputStream.writeInt(this.allflags);
        dataOutputStream.writeInt(0);
        for (int i = 0; i < this.charValue.length; ++i) {
            dataOutputStream.writeChar(this.charValue[i]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TCRGloss)) {
            return false;
        }
        TCRGloss tCRGloss = (TCRGloss)object;
        if (this.allflags != tCRGloss.allflags) {
            return false;
        }
        return Arrays.equals(this.charValue, tCRGloss.charValue);
    }

    @Override
    public int hashCode() {
        int n = this.allflags;
        for (int i = 0; i < this.charValue.length; ++i) {
            n = n * 17 + this.charValue[i];
        }
        return n;
    }

    @Override
    public int getType() {
        return 17;
    }

    public int getBOFA() {
        return (this.allflags & 0xFF0000) >>> 16;
    }

    public int getCost() {
        return (this.allflags & 0xFF00) >> 8;
    }

    public int getRType() {
        return this.allflags & 0xFF;
    }

    @Deprecated
    public String getValue() {
        return String.valueOf(this.charValue);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(14 + this.charValue.length + 1);
        stringBuilder.append("TCR(");
        stringBuilder.append(this.getRType()).append(',');
        stringBuilder.append(this.getCost()).append(',');
        stringBuilder.append((this.getBOFA() & 1) != 0 ? (char)'1' : '0');
        stringBuilder.append((this.getBOFA() & 2) != 0 ? (char)'1' : '0');
        stringBuilder.append((this.getBOFA() & 4) != 0 ? (char)'1' : '0');
        stringBuilder.append((this.getBOFA() & 8) != 0 ? (char)'1' : '0');
        stringBuilder.append(',');
        stringBuilder.append(this.charValue);
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

