/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.trellis.TrellisPayload;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.SizedIOBuffers;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenClassGloss
extends Gloss {
    private int[] classes;
    Gloss case_gloss;
    GlossCollection payload;
    int flags;
    int length_adjust;
    TrellisPayload trellis_payload;
    static int[] empty_int_array = new int[0];
    public static final int TAG_BREAK = 1;
    public static final int TAG_DO_DICT_LOOKUP = 2;
    public static final int TAG_POST_STD = 4;
    public static final int TAG_POST_SENTENCE_BREAK = 16;
    public static final int TAG_POST_PARAGRAPH_BREAK = 32;
    public static final int TAG_POST_PUNCTUATION = 64;
    public static final int TAG_POST_UNKNOWN = 128;
    public static final int TAG_POST_UNKNOWN_WORD = 256;
    public static final int TAG_DONT_DECOMPOSE = 512;
    public static final int TAG_TOKEN = 452;
    static Map<String, Integer> stringMap = null;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TokenClassGloss() {
        this.classes = empty_int_array;
        this.case_gloss = null;
    }

    private TokenClassGloss(int[] nArray, CaseGloss caseGloss, int n, int n2, TrellisPayload trellisPayload, GlossCollection glossCollection) {
        this.classes = nArray;
        this.case_gloss = caseGloss;
        this.flags = n;
        this.length_adjust = n2;
        this.trellis_payload = trellisPayload;
        if (glossCollection != null && glossCollection.size() > 0) {
            this.payload = glossCollection;
        }
    }

    private static synchronized void initializeStringMap() {
        if (stringMap == null) {
            stringMap = new HashMap<String, Integer>();
            stringMap.put("break", 1);
            stringMap.put("lookup", 2);
            stringMap.put("eop", 32);
            stringMap.put("punct", 64);
            stringMap.put("eos", 16);
            stringMap.put("post", 4);
            stringMap.put("unknown", 128);
            stringMap.put("word", 256);
            stringMap.put("nodecomp", 512);
        }
    }

    public static TokenClassGloss fromSpec(List<?> list) {
        TokenClassGloss.initializeStringMap();
        int n = (Integer)list.get(0);
        int n2 = 0;
        int n3 = 0;
        TrellisPayload trellisPayload = TrellisPayload.values()[0];
        int n4 = 1;
        GlossCollection glossCollection = new GlossCollection();
        block5: for (int i = 1; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                String string = (String)obj;
                Integer n5 = stringMap.get(string);
                if (n5 == null) {
                    try {
                        trellisPayload = TrellisPayload.valueOf(string);
                        continue;
                    }
                    catch (EnumConstantNotPresentException enumConstantNotPresentException) {
                        throw new IllegalArgumentException("TokenClassGloss tag: " + string);
                    }
                }
                n2 |= n5.intValue();
                continue;
            }
            if (obj instanceof Integer) {
                switch (n4++) {
                    case 1: {
                        n3 = (Integer)obj;
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("TokenClassGloss integer: " + obj);
                    }
                }
            }
            if (!(obj instanceof Gloss)) continue;
            glossCollection.add((Gloss)obj);
        }
        return new TokenClassGloss(new int[]{n}, null, n2, n3, trellisPayload, glossCollection);
    }

    public static TokenClassGloss create(GlossCollection glossCollection) {
        IntArray intArray = new IntArray(glossCollection.size());
        Gloss gloss = null;
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        TrellisPayload trellisPayload = TrellisPayload.values()[0];
        GlossCollection glossCollection2 = null;
        for (Gloss gloss2 : glossCollection) {
            int n4;
            Gloss gloss3;
            if (gloss2 instanceof IntegerGloss) {
                gloss3 = (IntegerGloss)gloss2;
                int n5 = ((IntegerGloss)gloss3).weight;
                intArray.add(-n5);
                if (n2 < n5) {
                    n2 = n5;
                    n = 128;
                    n3 = 0;
                    trellisPayload = TrellisPayload.values()[0];
                    continue;
                }
                if (n2 != n5) continue;
                n |= 0x80;
                continue;
            }
            if (gloss2 instanceof CaseGloss) {
                gloss3 = (CaseGloss)gloss2;
                if (!((CaseGloss)gloss3).preferableTo((CaseGloss)gloss)) continue;
                gloss = gloss3;
                continue;
            }
            if (!(gloss2 instanceof TokenClassGloss)) continue;
            gloss3 = (TokenClassGloss)gloss2;
            CaseGloss caseGloss = ((TokenClassGloss)gloss3).getCaseGloss();
            if (caseGloss != null && caseGloss.preferableTo((CaseGloss)gloss)) {
                gloss = caseGloss;
            }
            if (n2 < (n4 = ((TokenClassGloss)gloss3).classes[0])) {
                n2 = n4;
                n = ((TokenClassGloss)gloss3).flags;
                n3 = ((TokenClassGloss)gloss3).length_adjust;
                trellisPayload = ((TokenClassGloss)gloss3).trellis_payload;
                glossCollection2 = new GlossCollection(((TokenClassGloss)gloss3).payload);
            } else if (n2 == n4) {
                n |= ((TokenClassGloss)gloss3).flags;
                if (glossCollection2 == null) {
                    glossCollection2 = new GlossCollection();
                }
                glossCollection2.addAll(((TokenClassGloss)gloss3).payload);
                if (n3 == 0) {
                    n3 = ((TokenClassGloss)gloss3).length_adjust;
                }
                if (((TokenClassGloss)gloss3).length_adjust != 0 && n3 != ((TokenClassGloss)gloss3).length_adjust) {
                    throw new IllegalArgumentException("Non-matching lengths " + n3 + "/" + ((TokenClassGloss)gloss3).length_adjust);
                }
                if (trellisPayload != ((TokenClassGloss)gloss3).trellis_payload) {
                    throw new IllegalArgumentException("Non-matching normalization data " + (Object)((Object)trellisPayload) + "/" + (Object)((Object)((TokenClassGloss)gloss3).trellis_payload));
                }
            }
            for (int n6 : ((TokenClassGloss)gloss3).classes) {
                intArray.add(-n6);
            }
        }
        if (intArray.isEmpty()) {
            return null;
        }
        intArray.removeDuplicates();
        Object object = intArray.toArray();
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = -object[i];
        }
        return new TokenClassGloss((int[])object, (CaseGloss)gloss, n, n3, trellisPayload, glossCollection2);
    }

    public static TokenClassGloss createBestOnly(GlossCollection glossCollection) {
        int n = -1;
        Gloss gloss = null;
        int n2 = 0;
        int n3 = 0;
        TrellisPayload trellisPayload = TrellisPayload.values()[0];
        GlossCollection glossCollection2 = null;
        for (Gloss gloss2 : glossCollection) {
            int n4;
            Gloss gloss3;
            if (gloss2 instanceof IntegerGloss) {
                gloss3 = (IntegerGloss)gloss2;
                int n5 = ((IntegerGloss)gloss3).weight;
                if (n < n5) {
                    n = n5;
                    n2 = 128;
                    n3 = 0;
                    trellisPayload = TrellisPayload.values()[0];
                    continue;
                }
                if (n != n5) continue;
                n2 |= 0x80;
                continue;
            }
            if (gloss2 instanceof CaseGloss) {
                gloss3 = (CaseGloss)gloss2;
                if (!((CaseGloss)gloss3).preferableTo((CaseGloss)gloss)) continue;
                gloss = gloss3;
                continue;
            }
            if (!(gloss2 instanceof TokenClassGloss)) continue;
            gloss3 = (TokenClassGloss)gloss2;
            CaseGloss caseGloss = ((TokenClassGloss)gloss3).getCaseGloss();
            if (caseGloss != null && caseGloss.preferableTo((CaseGloss)gloss)) {
                gloss = caseGloss;
            }
            if (n < (n4 = ((TokenClassGloss)gloss3).classes[0])) {
                n = n4;
                n2 = ((TokenClassGloss)gloss3).flags;
                n3 = ((TokenClassGloss)gloss3).length_adjust;
                trellisPayload = ((TokenClassGloss)gloss3).trellis_payload;
                glossCollection2 = new GlossCollection(((TokenClassGloss)gloss3).payload);
                continue;
            }
            if (n != n4) continue;
            n2 |= ((TokenClassGloss)gloss3).flags;
            if (glossCollection2 == null) {
                glossCollection2 = new GlossCollection();
            }
            glossCollection2.addAll(((TokenClassGloss)gloss3).payload);
            if (n3 == 0) {
                n3 = ((TokenClassGloss)gloss3).length_adjust;
            }
            if (((TokenClassGloss)gloss3).length_adjust != 0 && n3 != ((TokenClassGloss)gloss3).length_adjust) {
                throw new IllegalArgumentException("Non-matching lengths " + n3 + "/" + ((TokenClassGloss)gloss3).length_adjust);
            }
            if (trellisPayload == ((TokenClassGloss)gloss3).trellis_payload) continue;
            throw new IllegalArgumentException("Non-matching normalization data " + (Object)((Object)trellisPayload) + "/" + (Object)((Object)((TokenClassGloss)gloss3).trellis_payload));
        }
        if (n != -1) {
            return new TokenClassGloss(new int[]{n}, (CaseGloss)gloss, n2, n3, trellisPayload, glossCollection2);
        }
        return null;
    }

    public static TokenClassGloss create(GlossCollection glossCollection, boolean bl) {
        if (bl) {
            return TokenClassGloss.createBestOnly(glossCollection);
        }
        return TokenClassGloss.create(glossCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        DataInput dataInput = SizedIOBuffers.allocateInput(dataInputStream);
        try {
            int n2;
            int n3;
            int n4 = dataInput.readInt();
            this.classes = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.classes[n3] = dataInput.readInt();
            }
            n3 = dataInput.readInt();
            if (n3 > 0) {
                this.case_gloss = new MapperGloss(n3 - 1);
            }
            this.flags = dataInput.readInt();
            this.length_adjust = dataInput.readInt();
            int n5 = dataInput.readInt();
            if (n5 > 0) {
                this.payload = new GlossCollection();
                for (n2 = 0; n2 < n5; ++n2) {
                    this.payload.add(new MapperGloss(dataInput.readInt()));
                }
            }
            n2 = dataInput.readInt();
            this.trellis_payload = TrellisPayload.values()[n2];
        }
        finally {
            SizedIOBuffers.finalizeInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        DataOutput dataOutput = SizedIOBuffers.allocateOutput();
        try {
            int n2;
            dataOutput.writeInt(this.classes.length);
            for (n2 = 0; n2 < this.classes.length; ++n2) {
                dataOutput.writeInt(this.classes[n2]);
            }
            n2 = 0;
            if (this.case_gloss != null) {
                n2 = glossMapper.getGlossIndex(this.case_gloss) + 1;
            }
            dataOutput.writeInt(n2);
            dataOutput.writeInt(this.flags);
            dataOutput.writeInt(this.length_adjust);
            if (this.payload != null) {
                dataOutput.writeInt(this.payload.size());
                for (Gloss gloss : this.payload) {
                    dataOutput.writeInt(glossMapper.getGlossIndex(gloss));
                }
            } else {
                dataOutput.writeInt(0);
            }
            dataOutput.writeInt(this.trellis_payload.ordinal());
        }
        finally {
            SizedIOBuffers.finalizeOutput(dataOutputStream);
        }
    }

    @Override
    public void recalcPointers(final Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        if (this.case_gloss instanceof MapperGloss) {
            this.case_gloss = glossArray[((MapperGloss)this.case_gloss).map];
        }
        if (this.payload != null) {
            try {
                this.payload = this.payload.applyGlossProcessorShallow(new GlossProcessor(){

                    @Override
                    public Object process(Object object) throws DLTException {
                        if (object instanceof MapperGloss) {
                            return glossArray[((MapperGloss)object).map];
                        }
                        return object;
                    }

                    @Override
                    public void reset() {
                    }
                });
            }
            catch (DLTException dLTException) {
                throw new UnsupportedOperationException(dLTException);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TokenClassGloss)) {
            return false;
        }
        TokenClassGloss tokenClassGloss = (TokenClassGloss)object;
        return this.flags == tokenClassGloss.flags && this.length_adjust == tokenClassGloss.length_adjust && this.trellis_payload == tokenClassGloss.trellis_payload && Arrays.equals(this.classes, tokenClassGloss.classes) && (this.case_gloss == tokenClassGloss.case_gloss || this.case_gloss != null && this.case_gloss.equals(tokenClassGloss.case_gloss)) && (this.payload == tokenClassGloss.payload || this.payload != null && this.payload.equals(tokenClassGloss.payload));
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.classes);
        n = Utils.combineHash(n, this.flags);
        n = Utils.combineHash(n, this.length_adjust);
        n = Utils.combineHash(n, this.trellis_payload.ordinal());
        if (this.payload != null) {
            n = Utils.combineHash(n, this.payload.hashCode());
        }
        return this.case_gloss != null ? Utils.combineHash(n, this.case_gloss.hashCode()) : n;
    }

    @Override
    public int getType() {
        return 85;
    }

    @Override
    public String toString() {
        TokenClassGloss.initializeStringMap();
        StringBuilder stringBuilder = new StringBuilder("TokenClass");
        stringBuilder.append(Arrays.toString(this.classes));
        if (this.length_adjust != 0) {
            stringBuilder.append(',').append(this.length_adjust);
        }
        if (this.trellis_payload.ordinal() != 0) {
            stringBuilder.append(',').append((Object)this.trellis_payload);
        }
        for (Map.Entry<String, Integer> entry : stringMap.entrySet()) {
            if (!this.is(entry.getValue())) continue;
            stringBuilder.append(',').append(entry.getKey());
        }
        if (this.payload != null) {
            stringBuilder.append(':').append(this.payload.toString());
        }
        if (this.case_gloss != null) {
            stringBuilder.append(':').append(this.case_gloss.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        TokenClassGloss tokenClassGloss = this;
        Gloss gloss = this.case_gloss;
        if (this.case_gloss != null) {
            gloss = this.case_gloss.applyGlossProcessor(glossProcessor);
        }
        GlossCollection glossCollection = this.payload;
        if (this.payload != null) {
            this.payload = this.payload.applyGlossProcessor(glossProcessor);
        }
        if (gloss != this.case_gloss || glossCollection != this.payload) {
            tokenClassGloss = new TokenClassGloss(this.classes, (CaseGloss)gloss, this.flags, this.length_adjust, this.trellis_payload, glossCollection);
        }
        return (Gloss)glossProcessor.process(tokenClassGloss);
    }

    public int getBestClass() {
        return this.classes[0];
    }

    public int[] getClassesCopy() {
        return (int[])this.classes.clone();
    }

    public CaseGloss getCaseGloss() {
        return (CaseGloss)this.case_gloss;
    }

    @Override
    public boolean is(int n) {
        return (this.flags & n) != 0;
    }

    public GlossCollection getPostGloss() {
        return this.payload;
    }

    public int getMatchEnd(int n, int n2) {
        return n2 + this.length_adjust;
    }

    public TokenClassGloss cloneAddTag(int n) {
        return new TokenClassGloss(this.classes, (CaseGloss)this.case_gloss, this.flags | n, this.length_adjust, this.trellis_payload, this.payload);
    }

    public TrellisPayload getTrellisPayload() {
        return this.trellis_payload;
    }

    public void multiply(GlossCollection glossCollection, GlossProcessor glossProcessor) throws DLTException {
        if (this.payload != null) {
            for (Gloss gloss : this.payload) {
                TokenClassGloss tokenClassGloss = new TokenClassGloss(this.classes, (CaseGloss)this.case_gloss, this.flags, this.length_adjust, this.trellis_payload, new GlossCollection(gloss));
                Object object = glossProcessor.process(tokenClassGloss);
                if (object == null) continue;
                glossCollection.add((Gloss)object);
            }
        }
    }
}

