/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransformClassGloss
extends Gloss {
    private String _class;
    private int _position;
    private String _altLemma;
    private static final int MAX_POSITIONS = 5;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TransformClassGloss() {
    }

    public TransformClassGloss(String string, int n, String string2) {
        this._class = string.intern();
        this._position = n;
        this._altLemma = string2 != null ? string2.intern() : null;
    }

    public TransformClassGloss(String string, int[] nArray, String string2) {
        this._class = string.intern();
        if (nArray.length == 1) {
            this._position = nArray[0];
        } else {
            this._position = 3;
            for (int i = 5; i > 0; --i) {
                this._position <<= 6;
                if (nArray.length < i) continue;
                this._position |= nArray[i - 1] & 0x3F;
            }
        }
        this._altLemma = string2 != null ? string2.intern() : null;
    }

    @Override
    public int getType() {
        return 36;
    }

    public String getTransformClass() {
        return this._class;
    }

    @Deprecated
    public int getPosition() {
        return this.getPositions()[0];
    }

    public int[] getPositions() {
        int n;
        if (this._position > 0) {
            return new int[]{this._position};
        }
        for (n = 5; n > 1 && (this._position & 63 << (n - 1) * 6) == 0; --n) {
        }
        int[] nArray = new int[n];
        int n2 = this._position;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2 & 0x3F;
            n2 >>= 6;
        }
        return nArray;
    }

    public String getAltLemma() {
        return this._altLemma;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this._class = dataInputStream.readUTF().intern();
        this._position = dataInputStream.readInt();
        this._altLemma = dataInputStream.readUTF().intern();
        if (this._altLemma.length() == 0) {
            this._altLemma = null;
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeUTF(this._class);
        dataOutputStream.writeInt(this._position);
        if (this._altLemma != null) {
            dataOutputStream.writeUTF(this._altLemma);
        } else {
            dataOutputStream.writeUTF("");
        }
    }

    @Override
    public int hashCode() {
        int n = this._position;
        if (this._class != null) {
            n = n * 17 + this._class.hashCode();
        }
        if (this._altLemma != null) {
            n = n * 17 + this._altLemma.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TransformClassGloss)) {
            return false;
        }
        TransformClassGloss transformClassGloss = (TransformClassGloss)object;
        if (this._position != transformClassGloss._position) {
            return false;
        }
        return this._class == transformClassGloss._class && this._altLemma == transformClassGloss._altLemma;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransClass(");
        stringBuilder.append(this._class);
        stringBuilder.append(',');
        stringBuilder.append('(');
        int[] nArray = this.getPositions();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i + 1 >= nArray.length) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        if (this._altLemma != null) {
            stringBuilder.append(',');
            stringBuilder.append(this._altLemma);
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

