/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.gloss.TransformClassGloss;
import com.ibm.dltj.gloss.TransformRuleGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class TransformGloss
extends AbstractGlossVectorGloss {
    private Gloss _classGloss;
    private static final String WILD_CARDS = "~!@#$%^&*{[/]}+";
    private static final char CODE_INFLECT_PART = '?';
    private static final String CODE_SEPARATE_PART = ";";
    private static final char BEGIN_INSERT_PART = '(';
    private static final char END_INSERT_PART = ')';
    protected static final char ARABIC_DELETE = '\\';
    protected static final char ARABIC_INSERT = '^';
    protected static final char ARABIC_REPLACE = '=';
    protected static final char ARABIC_PREFIX = '<';
    static int RULE_DELETE = 0;
    static int RULE_INSERT = 1;
    static int RULE_REPLACE = 2;
    static int RULE_PREFIX = 3;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TransformGloss() {
    }

    public TransformGloss(TransformClassGloss transformClassGloss, TransformRuleGloss[] transformRuleGlossArray) throws DLTException {
        super(transformRuleGlossArray);
        this._classGloss = transformClassGloss;
    }

    public Gloss getTransformClassGloss() {
        return this._classGloss;
    }

    @Override
    public int getType() {
        return 35;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        super.read_(dataInputStream, n);
        int n2 = dataInputStream.readInt();
        if (n2 >= 0) {
            this._classGloss = new MapperGloss(n2);
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        if (this.element.length == 0) {
            throw new DLTException(Messages.getString("error.length"));
        }
        super.write_(dataOutputStream, glossMapper);
        int n = -1;
        if (this._classGloss != null) {
            n = glossMapper.getGlossIndex(this._classGloss);
        }
        dataOutputStream.writeInt(n);
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        if (this._classGloss instanceof MapperGloss) {
            this._classGloss = glossArray[((MapperGloss)this._classGloss).map];
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode_();
        if (this._classGloss != null) {
            n = n * 17 + this._classGloss.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TransformGloss)) {
            return false;
        }
        TransformGloss transformGloss = (TransformGloss)object;
        if (this._classGloss == null ? transformGloss._classGloss != null : !this._classGloss.equals(transformGloss._classGloss)) {
            return false;
        }
        return super.equals(transformGloss);
    }

    @Override
    public boolean isSimilar(Object object) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transform(");
        if (this._classGloss != null) {
            stringBuilder.append(this._classGloss.toString());
            stringBuilder.append(';');
        }
        for (int i = 0; i < this.element.length; ++i) {
            stringBuilder.append(this.element[i].toString());
            stringBuilder.append(';');
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public boolean doesRuleApply(int n, String string) {
        return this.getSurfaceform(n, string) != null;
    }

    public int getPOS(int n) {
        if (n < 0 || n > this.numChildren() - 1) {
            return 0;
        }
        if (!(this.getChild(n) instanceof TransformRuleGloss)) {
            return 0;
        }
        return ((TransformRuleGloss)this.getChild(n)).getPOS();
    }

    public int getFeatureMaskCount(int n) {
        if (n < 0 || n > this.numChildren() - 1) {
            return 0;
        }
        if (!(this.getChild(n) instanceof TransformRuleGloss)) {
            return 0;
        }
        return ((TransformRuleGloss)this.getChild(n)).getMaskN();
    }

    public int getFeatureMask(int n, int n2) {
        if (n < 0 || n > this.numChildren() - 1) {
            return 0;
        }
        if (!(this.getChild(n) instanceof TransformRuleGloss)) {
            return 0;
        }
        return ((TransformRuleGloss)this.getChild(n)).getMask(n2);
    }

    public String getSurfaceform(int n, String string) {
        int n2;
        if (n < 0 || n > this.numChildren() - 1) {
            return null;
        }
        if (!(this.getChild(n) instanceof TransformRuleGloss)) {
            return null;
        }
        LinkedList<ArabicRule> linkedList = new LinkedList<ArabicRule>();
        TransformRuleGloss transformRuleGloss = (TransformRuleGloss)this.getChild(n);
        String string2 = string;
        if (((TransformClassGloss)this.getTransformClassGloss()).getAltLemma() != null && ((TransformClassGloss)this.getTransformClassGloss()).getAltLemma().length() > 0) {
            string2 = ((TransformClassGloss)this.getTransformClassGloss()).getAltLemma();
        }
        String string3 = string2;
        String string4 = transformRuleGloss.getMatch();
        int n3 = 0;
        if (string4.length() > 1 && string4.charAt(string4.length() - 2) == '?' && string4.charAt(string4.length() - 1) - 48 > 0 && string4.charAt(string4.length() - 1) - 48 < 10) {
            n3 = string4.charAt(string4.length() - 1) - 48;
            string4 = string4.substring(0, string4.length() - 2);
        }
        if (n3 != 0) {
            String[] stringArray = string2.split("-| ");
            if (n3 > stringArray.length) {
                return null;
            }
            string3 = stringArray[n3 - 1];
        }
        if ((n2 = string3.length() - string4.length()) < 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(WILD_CARDS);
        for (int i = 0; i < string4.length(); ++i) {
            int n4 = WILD_CARDS.indexOf(string4.charAt(i));
            if (n4 != -1) {
                if (stringBuffer.charAt(n4) == WILD_CARDS.charAt(n4)) {
                    stringBuffer.setCharAt(n4, string3.charAt(n2 + i));
                    continue;
                }
                if (stringBuffer.charAt(n4) == string3.charAt(n2 + i)) continue;
                return null;
            }
            if (string4.charAt(i) == string3.charAt(n2 + i)) continue;
            return null;
        }
        String string5 = this.ExtractArabicRules(transformRuleGloss.getReplace(), linkedList);
        String[] stringArray = string5.split(CODE_SEPARATE_PART);
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        int[] nArray = ((TransformClassGloss)this.getTransformClassGloss()).getPositions();
        int n5 = 0;
        if (nArray.length == 1 && linkedList.isEmpty()) {
            n5 = nArray[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer2 = this.inflectPart(stringArray[i], stringBuffer2, stringBuffer, n5, string4, n3);
        }
        if (stringBuffer2 == null) {
            return null;
        }
        if (stringBuffer2.length() == 0) {
            return null;
        }
        if (!linkedList.isEmpty() && (stringBuffer2 = this.applyArabicRules(stringBuffer2, nArray, linkedList)) == null) {
            return null;
        }
        if (n5 == -1 && (transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_GE) || transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_GEX) || transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_ZU) || transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.SPLIT_WORD))) {
            return null;
        }
        if (transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_GEX)) {
            if (stringBuffer2.charAt(n5) == 'e') {
                stringBuffer2.setCharAt(n5, '\u00eb');
            } else if (stringBuffer2.charAt(n5) == 'i') {
                stringBuffer2.setCharAt(n5, '\u00ef');
            } else if (stringBuffer2.charAt(n5) == 'u') {
                stringBuffer2.setCharAt(n5, '\u00fc');
            }
        }
        if (transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_GE) || transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_GEX)) {
            stringBuffer2.insert(n5, "ge");
        } else if (transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.INSERT_ZU)) {
            stringBuffer2.insert(n5, "zu");
        } else if (transformRuleGloss.isFlagSet(TransformRuleGloss.Flag.SPLIT_WORD)) {
            stringBuffer2.append(' ').append(stringBuffer2.substring(0, n5));
            stringBuffer2.delete(0, n5);
        }
        return stringBuffer2.toString();
    }

    String ExtractArabicRules(String string, List<ArabicRule> list) {
        String string2 = string.replaceAll("\u200e", "").replaceAll("\u200f", "");
        while (string2.indexOf(40) != -1) {
            ArabicRule arabicRule;
            int n = string2.indexOf(40);
            int n2 = string2.indexOf(41, n);
            if (n2 == -1 || n2 - n < 3) {
                return string2;
            }
            if (string2.charAt(n + 1) - 48 > 0 && string2.charAt(n + 1) - 48 < 10 && string2.charAt(n + 2) == '\\') {
                arabicRule = new ArabicRule(string2.charAt(n + 1) - 48, RULE_DELETE, "");
            } else if (string2.charAt(n + 1) == '<') {
                arabicRule = new ArabicRule(0, RULE_PREFIX, string2.substring(n + 2, n2));
            } else {
                if (n2 == -1 || n2 - n < 4) {
                    return string2;
                }
                if (string2.charAt(n + 1) - 48 > 0 && string2.charAt(n + 1) - 48 < 10 && string2.charAt(n + 2) == '^') {
                    arabicRule = new ArabicRule(string2.charAt(n + 1) - 48, RULE_INSERT, string2.substring(n + 3, n2));
                } else if (string2.charAt(n + 1) - 48 > 0 && string2.charAt(n + 1) - 48 < 10 && string2.charAt(n + 2) == '=') {
                    arabicRule = new ArabicRule(string2.charAt(n + 1) - 48, RULE_REPLACE, string2.substring(n + 3, n2));
                } else {
                    return string2;
                }
            }
            list.add(arabicRule);
            String string3 = "";
            if (n > 0) {
                string3 = string2.substring(0, n);
            }
            String string4 = "";
            if (n2 < string2.length()) {
                string4 = string2.substring(n2 + 1);
            }
            string2 = string3 + string4;
        }
        return string2;
    }

    private StringBuffer inflectPart(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, int n, String string2, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        String string3 = string;
        if (string3.length() > 1 && string3.charAt(string3.length() - 2) == '?' && string3.charAt(string3.length() - 1) - 48 > 0 && string3.charAt(string3.length() - 1) - 48 < 10) {
            n5 = string3.charAt(string3.length() - 1) - 48;
            string3 = string3.substring(0, string3.length() - 2);
        }
        StringBuffer stringBuffer3 = stringBuffer;
        int n6 = stringBuffer3.length();
        if (n5 != 0) {
            n4 = n5;
            n3 = 0;
            for (n3 = 0; n3 < stringBuffer3.length(); ++n3) {
                if (stringBuffer3.charAt(n3) == '-' || stringBuffer3.charAt(n3) == ' ') {
                    --n4;
                }
                if (n4 != 0) continue;
                n6 = n3;
                break;
            }
        }
        if (n6 < 0) {
            return null;
        }
        if (string2.length() > 0 && n5 == n2) {
            stringBuffer3.delete(n6 -= string2.length(), n6 + string2.length());
        }
        for (n4 = 0; n4 < string3.length(); ++n4) {
            n3 = WILD_CARDS.indexOf(string3.charAt(n4));
            if (n3 == -1) {
                stringBuffer3.insert(n6 + n4, string3.charAt(n4));
                continue;
            }
            stringBuffer3.insert(n6 + n4, stringBuffer2.charAt(n3));
        }
        if (n >= stringBuffer3.length()) {
            return null;
        }
        return stringBuffer3;
    }

    private StringBuffer applyArabicRules(StringBuffer stringBuffer, int[] nArray, List<ArabicRule> list) {
        Object object;
        TreeMap<Integer, ArabicRule> treeMap = new TreeMap<Integer, ArabicRule>();
        for (ArabicRule object2 : list) {
            object = object2.getTransformPos(nArray);
            if (object == null) {
                return null;
            }
            treeMap.put((Integer)object, object2);
        }
        while (!treeMap.isEmpty()) {
            Integer n = (Integer)treeMap.lastKey();
            object = (ArabicRule)treeMap.get(n);
            treeMap.remove(n);
            if ((stringBuffer = ((ArabicRule)object).applyRule(stringBuffer, n)) != null) continue;
            return null;
        }
        return stringBuffer;
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        TransformClassGloss transformClassGloss = (TransformClassGloss)this._classGloss.applyGlossProcessor(glossProcessor);
        TransformRuleGloss[] transformRuleGlossArray = (TransformRuleGloss[])this.applyProcessorToElements(glossProcessor);
        TransformGloss transformGloss = transformRuleGlossArray != this.element || transformClassGloss != this._classGloss ? new TransformGloss(transformClassGloss, transformRuleGlossArray) : this;
        return (Gloss)glossProcessor.process(transformGloss);
    }

    public class ArabicRule {
        private final int _positionIndex;
        private final int _type;
        private final String _insertReplace;

        protected ArabicRule(int n, int n2, String string) {
            this._positionIndex = n;
            this._type = n2;
            this._insertReplace = string;
        }

        protected Integer getTransformPos(int[] nArray) {
            if (this._positionIndex > nArray.length) {
                return null;
            }
            if (this._positionIndex == 0) {
                return 0;
            }
            return nArray[this._positionIndex - 1];
        }

        protected StringBuffer applyRule(StringBuffer stringBuffer, int n) {
            if (stringBuffer.length() < n) {
                return null;
            }
            if (this._type == RULE_DELETE) {
                stringBuffer.deleteCharAt(n - 1);
            } else if (this._type == RULE_INSERT) {
                stringBuffer.insert(n, this._insertReplace);
            } else if (this._type == RULE_REPLACE) {
                stringBuffer.insert(n, this._insertReplace);
                stringBuffer.deleteCharAt(n - 1);
            } else if (this._type == RULE_PREFIX) {
                stringBuffer.insert(0, this._insertReplace);
            }
            return stringBuffer;
        }
    }
}

