/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.GrammarGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransformRuleGloss
extends GrammarGloss {
    private String _match;
    private String _replace;
    private String _pcode;
    private int _flags;
    private static final String POS_CHAR = "XPVNJARICDQ";
    private static final char ALT_ADJECTIVE = 'T';

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TransformRuleGloss() {
    }

    public TransformRuleGloss(String string, String string2, String string3, Flag[] flagArray, int[] nArray) {
        super(nArray);
        this._match = string.intern();
        this._replace = string2.intern();
        this._pcode = string3.intern();
        this._flags = Flag.toFlagInt(flagArray);
    }

    public String getMatch() {
        return this._match;
    }

    public String getReplace() {
        return this._replace;
    }

    public String getPCode() {
        return this._pcode;
    }

    public boolean isFlagSet(Flag flag) {
        return flag.isSet(this._flags);
    }

    public int getPOS() {
        int n;
        if (this._pcode == null || this._pcode.length() < 1) {
            return 0;
        }
        int n2 = this._pcode.charAt(this._pcode.length() - 1);
        if (n2 == 84) {
            n2 = 74;
        }
        if ((n = POS_CHAR.indexOf(n2)) == -1) {
            return 0;
        }
        return n;
    }

    @Override
    public int getType() {
        return 37;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        super.read(dataInputStream, n);
        this._match = dataInputStream.readUTF().intern();
        this._replace = dataInputStream.readUTF().intern();
        this._pcode = dataInputStream.readUTF().intern();
        this._flags = dataInputStream.readInt();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        super.write(dataOutputStream, glossMapper);
        dataOutputStream.writeUTF(this._match);
        dataOutputStream.writeUTF(this._replace);
        dataOutputStream.writeUTF(this._pcode);
        dataOutputStream.writeInt(this._flags);
    }

    @Override
    public int hashCode() {
        int n = this._flags;
        n = n * 13 + super.hashCode();
        if (this._match != null) {
            n = n * 13 + this._match.hashCode();
        }
        if (this._replace != null) {
            n = n * 13 + this._replace.hashCode();
        }
        if (this._pcode != null) {
            n = n * 13 + this._pcode.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TransformRuleGloss)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TransformRuleGloss transformRuleGloss = (TransformRuleGloss)object;
        return this._match == transformRuleGloss._match && this._replace == transformRuleGloss._replace && this._pcode == transformRuleGloss._pcode && this._flags == transformRuleGloss._flags;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransRule(");
        stringBuilder.append(this._match);
        stringBuilder.append(',');
        stringBuilder.append(this._replace);
        stringBuilder.append(',');
        stringBuilder.append(this._pcode);
        stringBuilder.append(',');
        stringBuilder.append(Integer.toBinaryString(this._flags));
        for (int i = 0; i < this.mask.length; ++i) {
            stringBuilder.append(i > 0 ? (char)';' : ',');
            stringBuilder.append(Integer.toHexString(this.mask[i]));
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public static class Flag {
        private final int _value;
        public static final Flag SPLIT_WORD = new Flag(1);
        public static final Flag INSERT_GE = new Flag(2);
        public static final Flag INSERT_ZU = new Flag(4);
        public static final Flag INSERT_GEX = new Flag(8);

        private Flag(int n) {
            this._value = n;
        }

        boolean isSet(int n) {
            return (n & this._value) == this._value;
        }

        static int toFlagInt(Flag[] flagArray) {
            if (flagArray == null) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < flagArray.length; ++i) {
                n |= flagArray[i]._value;
            }
            return n;
        }
    }
}

