/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.TypedGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TypedIntGloss
extends TypedGloss {
    public int value;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TypedIntGloss() {
    }

    public TypedIntGloss(StringGloss stringGloss, int n, int n2) {
        super(stringGloss, n2);
        this.value = n;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.rtData = dataInputStream.readInt();
        this.value = dataInputStream.readInt();
        this.typeIndex = dataInputStream.readInt();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.rtData);
        dataOutputStream.writeInt(this.value);
        this.typeIndex = glossMapper.getGlossIndex(this.type);
        dataOutputStream.writeInt(this.typeIndex);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TypedIntGloss)) {
            return false;
        }
        if (!this.type.equals(((TypedGloss)object).type)) {
            return false;
        }
        if (this.rtData != ((TypedIntGloss)object).rtData) {
            return false;
        }
        return this.value == ((TypedIntGloss)object).value;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + this.value;
        return n;
    }

    @Override
    public int getType() {
        return 67;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public String toString() {
        return "TypeName:'" + this.type.value + "' " + "value:'" + this.value + "'";
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss gloss = this.type.applyGlossProcessor(glossProcessor);
        TypedIntGloss typedIntGloss = gloss == this.type ? this : new TypedIntGloss((StringGloss)gloss, this.value, this.rtData);
        return (Gloss)glossProcessor.process(typedIntGloss);
    }
}

