/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ZhFreqGloss
extends Gloss {
    int freq;
    short kwetag;
    short clrtag;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getType() {
        return 80;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.freq = dataInputStream.readUnsignedShort();
        this.kwetag = dataInputStream.readByte();
        this.clrtag = dataInputStream.readByte();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeChar(this.freq);
        dataOutputStream.writeByte(this.kwetag);
        dataOutputStream.writeByte(this.clrtag);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ZhFreqGloss)) {
            return false;
        }
        ZhFreqGloss zhFreqGloss = (ZhFreqGloss)object;
        return zhFreqGloss.freq == this.freq && zhFreqGloss.clrtag == this.clrtag && zhFreqGloss.kwetag == this.kwetag;
    }

    @Override
    public int hashCode() {
        return this.freq << 8 | this.kwetag | this.clrtag << 7;
    }

    public short getClrtag() {
        return this.clrtag;
    }

    public int getFreq() {
        return this.freq;
    }

    public short getKwetag() {
        return this.kwetag;
    }

    public void setClrtag(byte by) {
        this.clrtag = by;
    }

    public void setFreq(char c) {
        this.freq = c;
    }

    public void setKwetag(byte by) {
        this.kwetag = by;
    }

    public void setClrtag(int n) {
        this.clrtag = (byte)n;
    }

    public void setFreq(int n) {
        if (n > 65535) {
            n = 65535;
        } else if (n < 0) {
            n = 0;
        }
        this.freq = n;
    }

    public void setKwetag(int n) {
        this.kwetag = (byte)n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ZhFreq(");
        stringBuilder.append(this.freq);
        stringBuilder.append(',').append(this.kwetag);
        stringBuilder.append(',').append(this.clrtag);
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

