/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.RegExBuilder;
import java.text.StringCharacterIterator;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Approximation
extends NonDeterministicNodeAdapter
implements RegExBuilder.RegExElement {
    public int cost_rem = 40;
    public int cost_sub = 65;
    public int cost_trans = 35;
    public int cost_ins = 35;
    public int cost_whitespace = 185;
    public int cost_extra1 = 10;
    public int cost_extra2 = 10;
    public int cost_error = 0;
    private final RegExBuilder.RegExElement data;
    private final RegExBuilder.RegExElement space;
    private final int distance;
    private final NetGenericDictionary rules;
    private final RegExBuilder builder;
    final CharacterMap char_map;
    Node rules_root;
    private int loopnest;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public Approximation(RegExBuilder.RegExElement regExElement, RegExBuilder.RegExElement regExElement2, int n, RegExBuilder regExBuilder, CharacterMap characterMap, Dictionary dictionary) throws DLTException {
        super(regExBuilder.net);
        this.data = regExElement;
        this.space = regExElement2;
        this.distance = n;
        this.builder = regExBuilder;
        this.char_map = characterMap;
        this.rules = new NetGenericDictionary();
        if (dictionary != null) {
            this.rules.append(dictionary.getNet().first(), new GlossProcessor(){

                @Override
                public Object process(Object object) throws DLTException {
                    if (object instanceof TCRGloss) {
                        return object;
                    }
                    if (object instanceof GlossCollection) {
                        return ((GlossCollection)object).applyGlossProcessor(this);
                    }
                    return null;
                }

                @Override
                public void reset() {
                }
            });
        }
    }

    void addTranspositions() throws DLTException {
        if (this.distance > this.cost_trans) {
            int n = this.net.getFirstLinkIndex();
            int n2 = this.net.getMaxIndex();
            for (int i = n; i < n2; ++i) {
                for (int j = i + 1; j < n2; ++j) {
                    String string = String.valueOf(this.char_map.invert(j)) + String.valueOf(this.char_map.invert(i));
                    String string2 = String.valueOf(this.char_map.invert(i)) + String.valueOf(this.char_map.invert(j));
                    TCRGloss tCRGloss = new TCRGloss(0, this.cost_trans, 15, string2);
                    this.rules.add(new StringCharacterIterator(string), 2, tCRGloss);
                    tCRGloss = new TCRGloss(0, this.cost_trans, 15, string);
                    this.rules.add(new StringCharacterIterator(string2), 2, tCRGloss);
                }
            }
        }
        this.rules_root = this.rules.first();
    }

    @Override
    public int build(int n) throws DLTException {
        if (this.rules_root == null) {
            this.addTranspositions();
        }
        this.loopnest = this.builder.loopnest++;
        BitSet bitSet = new BitSet();
        bitSet.set(this.loopnest);
        int n2 = this.net.getPayloadManipulator(1).merge(-1, bitSet);
        NetGenericFullAccess netGenericFullAccess = (NetGenericFullAccess)this.net;
        netGenericFullAccess.getReferences().addReference(-1, n);
        int n3 = netGenericFullAccess.modifyNode(-1, 1, n2);
        netGenericFullAccess.getReferences().addReference(-1, n3);
        int n4 = this.data.build(n3);
        netGenericFullAccess.getReferences().addReference(-1, n4);
        int n5 = this.space.build(n3);
        netGenericFullAccess.getReferences().addReference(-1, n5);
        --this.builder.loopnest;
        NonDeterministicBuildNode nonDeterministicBuildNode = NonDeterministicNodeAdapter.nonDeterministicNode(netGenericFullAccess, n3);
        BuildNode buildNode = Approximation.createAdapter(new ApproximationNode(n4, n5, this.distance, nonDeterministicBuildNode), netGenericFullAccess);
        buildNode = netGenericFullAccess.adaptBuildNode(buildNode);
        int n6 = this.builder.merger.buildAndIntegrate(buildNode);
        netGenericFullAccess.getReferences().addReference(-1, n6);
        netGenericFullAccess.getReferences().removeReference(-1, n3);
        netGenericFullAccess.getReferences().removeReference(-1, n4);
        netGenericFullAccess.getReferences().removeReference(-1, n5);
        int n7 = this.builder.loopMaker.attachTrail(n6, n, this.loopnest);
        netGenericFullAccess.getReferences().removeReference(-1, n);
        netGenericFullAccess.getReferences().removeReferenceKeeping(-1, n6, n7);
        return n7;
    }

    @Override
    public Object getNode(Object object) throws DLTException {
        throw new UnsupportedOperationException();
    }

    boolean isFinal(int n) throws DLTException {
        BitSet bitSet = (BitSet)this.net.getPayload(n, 1, null);
        return bitSet != null && bitSet.get(this.loopnest);
    }

    @Override
    Set<NonDeterministicBuildNode> makeSet(int n) {
        return new ApproximationNodeSet(n);
    }

    public NonDeterministicNodeAdapter.AdapterBase createAdapter(NonDeterministicBuildNode nonDeterministicBuildNode) {
        if (this.net.getMaxIndex() <= 128) {
            return new NonDeterministicNodeAdapter.Direct((NonDeterministicNodeAdapter)this, nonDeterministicBuildNode);
        }
        return new NonDeterministicNodeAdapter.Mapped((NonDeterministicNodeAdapter)this, nonDeterministicBuildNode);
    }

    class TCRPossibilityNode
    extends NoDistTCRNode
    implements DistanceNode {
        int dist_at_start;
        int index;
        Node cur_child;
        Iterator<?> gloss_iter;

        public TCRPossibilityNode(int n, int n2, Node node, int n3, NonDeterministicBuildNode nonDeterministicBuildNode) {
            super(n, n2, node, nonDeterministicBuildNode);
            assert (node != null);
            this.dist_at_start = n3;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.index = 0;
            if (!this.TCR_node.isFinal()) {
                return false;
            }
            this.gloss_iter = this.TCR_node.getGloss().iterator();
            return true;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            int n;
            TCRGloss tCRGloss;
            Gloss gloss = null;
            while (true) {
                if (!this.gloss_iter.hasNext()) {
                    return null;
                }
                gloss = (Gloss)this.gloss_iter.next();
                if (!(gloss instanceof TCRGloss) || (tCRGloss = (TCRGloss)gloss).getCost() > this.dist_at_start) continue;
                n = this.data_node;
                for (int i = 0; i < tCRGloss.charValue.length; ++i) {
                    n = Approximation.this.net.takeTransition(n, Approximation.this.char_map.translate(tCRGloss.charValue[i]), -1);
                }
                if (n != -1) break;
            }
            return new ApproximationNode(n, this.space_node, this.dist_at_start - tCRGloss.getCost(), this.trail);
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.index = Approximation.this.net.getFirstLinkIndex() - 1;
        }

        @Override
        public void endEnumeration() {
        }

        @Override
        public Object getChild() throws DLTException {
            return new TCRPossibilityNode(this.data_node, Approximation.this.net.takeTransition(this.space_node, this.index, -1), this.cur_child, this.dist_at_start, this.trail);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean nextTransition() {
            while (++this.index < Approximation.this.net.getMaxIndex()) {
                if (!Approximation.this.net.transitionPresent(this.space_node, this.index)) continue;
                this.cur_child = this.TCR_node.next(Approximation.this.char_map.invert(this.index));
                if (this.cur_child == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.dist_at_start;
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            TCRPossibilityNode tCRPossibilityNode = (TCRPossibilityNode)object;
            return tCRPossibilityNode == null || this.dist_at_start == tCRPossibilityNode.dist_at_start;
        }

        @Override
        public Object nonDist() {
            return new NoDistTCRNode(this);
        }

        @Override
        public boolean covers(Object object) {
            if (!(object instanceof TCRPossibilityNode)) {
                return false;
            }
            TCRPossibilityNode tCRPossibilityNode = (TCRPossibilityNode)object;
            return this.dist_at_start >= tCRPossibilityNode.dist_at_start;
        }

        public String toString() {
            return "~T(" + this.data_node + ',' + this.space_node + ',' + this.dist_at_start + ')';
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }
    }

    class NoDistTCRNode {
        int data_node;
        int space_node;
        Node TCR_node;
        NonDeterministicBuildNode trail;

        public NoDistTCRNode(int n, int n2, Node node, NonDeterministicBuildNode nonDeterministicBuildNode) {
            this.data_node = n;
            this.space_node = n2;
            this.TCR_node = node;
            this.trail = nonDeterministicBuildNode;
        }

        public NoDistTCRNode(NoDistTCRNode noDistTCRNode) {
            this(noDistTCRNode.data_node, noDistTCRNode.space_node, noDistTCRNode.TCR_node, noDistTCRNode.trail);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.TCR_node == null ? 0 : this.TCR_node.hashCode());
            n = 31 * n + this.data_node;
            n = 31 * n + this.space_node;
            n = 31 * n + (this.trail == null ? 0 : this.trail.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NoDistTCRNode noDistTCRNode = (NoDistTCRNode)object;
            if (!this.getOuterType().equals(noDistTCRNode.getOuterType())) {
                return false;
            }
            if (this.TCR_node == null ? noDistTCRNode.TCR_node != null : !this.TCR_node.equals(noDistTCRNode.TCR_node)) {
                return false;
            }
            if (this.data_node != noDistTCRNode.data_node) {
                return false;
            }
            if (this.space_node != noDistTCRNode.space_node) {
                return false;
            }
            return !(this.trail == null ? noDistTCRNode.trail != null : !this.trail.equals(noDistTCRNode.trail));
        }

        private Approximation getOuterType() {
            return Approximation.this;
        }
    }

    class ApproximationNode
    extends NoDistApproxNode
    implements DistanceNode {
        int dist;
        int index;
        int[] data_links;

        public ApproximationNode(int n, int n2, int n3, NonDeterministicBuildNode nonDeterministicBuildNode) {
            super(n, n2, nonDeterministicBuildNode);
            this.dist = n3;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.data_links = Approximation.this.net.gatherNodeLinks(this.data_node);
            int n = 0;
            if (Approximation.this.rules_root != null && this.dist >= Approximation.this.cost_error) {
                ++n;
            }
            if (this.dist >= Approximation.this.cost_rem) {
                n += this.data_links.length;
            }
            this.index = Approximation.this.isFinal(this.data_node) && Approximation.this.isFinal(this.space_node) ? -1 : 0;
            return n > this.index;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            ++this.index;
            if (this.index == 0) {
                return this.trail;
            }
            int n = this.index - 1;
            if (Approximation.this.rules_root != null && this.dist >= Approximation.this.cost_error) {
                if (n == 0) {
                    return new TCRPossibilityNode(this.data_node, this.space_node, Approximation.this.rules_root, this.dist - Approximation.this.cost_error, this.trail);
                }
                --n;
            }
            if (this.dist < Approximation.this.cost_rem) {
                return null;
            }
            if (n >= this.data_links.length) {
                return null;
            }
            return new ApproximationNode(Approximation.this.net.transitionValue(this.data_node, this.data_links[n]), this.space_node, this.dist - Approximation.this.cost_rem, this.trail);
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.index = Approximation.this.net.getFirstLinkIndex() - 1;
        }

        @Override
        public void endEnumeration() {
        }

        void addAdjusted(Set<NonDeterministicBuildNode> set, int n, int n2, int n3, int n4, NonDeterministicBuildNode nonDeterministicBuildNode) {
            if (n3 < n4) {
                return;
            }
            set.add(new ApproximationNode(n, n2, n3 - n4, nonDeterministicBuildNode));
        }

        @Override
        public Object getChild() throws DLTException {
            HashSet<NonDeterministicBuildNode> hashSet = new HashSet<NonDeterministicBuildNode>();
            int n = Approximation.this.net.takeTransition(this.data_node, this.index, -1);
            int n2 = Approximation.this.net.takeTransition(this.space_node, this.index, -1);
            if (n != -1) {
                hashSet.add(new ApproximationNode(n, n2, this.dist, this.trail));
            }
            this.addAdjusted(hashSet, this.data_node, n2, this.dist, Approximation.this.cost_ins, this.trail);
            for (int n3 : this.data_links) {
                if (n3 == this.index) continue;
                this.addAdjusted(hashSet, Approximation.this.net.transitionValue(this.data_node, n3), n2, this.dist, Approximation.this.cost_sub, this.trail);
            }
            if (hashSet.size() == 0) {
                return null;
            }
            if (hashSet.size() == 1) {
                return hashSet.iterator().next();
            }
            return new RegExBuilder.RegExNode(hashSet.toArray(new NonDeterministicBuildNode[hashSet.size()]));
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean nextTransition() {
            while (++this.index < Approximation.this.net.getMaxIndex()) {
                if (!Approximation.this.net.transitionPresent(this.space_node, this.index)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.dist;
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            ApproximationNode approximationNode = (ApproximationNode)object;
            return approximationNode == null || this.dist == approximationNode.dist;
        }

        @Override
        public Object nonDist() {
            return new NoDistApproxNode(this);
        }

        @Override
        public boolean covers(Object object) {
            if (!(object instanceof ApproximationNode)) {
                return false;
            }
            ApproximationNode approximationNode = (ApproximationNode)object;
            return this.dist >= approximationNode.dist;
        }

        public String toString() {
            return "~(" + this.data_node + ',' + this.space_node + ',' + this.dist + ')';
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }
    }

    class NoDistApproxNode {
        NonDeterministicBuildNode trail;
        int data_node;
        int space_node;

        public NoDistApproxNode(NoDistApproxNode noDistApproxNode) {
            this.trail = noDistApproxNode.trail;
            this.data_node = noDistApproxNode.data_node;
            this.space_node = noDistApproxNode.space_node;
        }

        public NoDistApproxNode(int n, int n2, NonDeterministicBuildNode nonDeterministicBuildNode) {
            this.trail = nonDeterministicBuildNode;
            this.data_node = n;
            this.space_node = n2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.data_node;
            n = 31 * n + this.space_node;
            n = 31 * n + (this.trail == null ? 0 : this.trail.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NoDistApproxNode noDistApproxNode = (NoDistApproxNode)object;
            if (!this.getOuterType().equals(noDistApproxNode.getOuterType())) {
                return false;
            }
            if (this.data_node != noDistApproxNode.data_node) {
                return false;
            }
            if (this.space_node != noDistApproxNode.space_node) {
                return false;
            }
            return !(this.trail == null ? noDistApproxNode.trail != null : !this.trail.equals(noDistApproxNode.trail));
        }

        private Approximation getOuterType() {
            return Approximation.this;
        }
    }

    static interface DistanceNode
    extends NonDeterministicBuildNode {
        public Object nonDist();

        public boolean covers(Object var1);
    }

    class ApproximationNodeSet
    implements Set<NonDeterministicBuildNode> {
        final Map<Object, NonDeterministicBuildNode> map;

        public ApproximationNodeSet(int n) {
            this.map = new HashMap<Object, NonDeterministicBuildNode>(n);
        }

        @Override
        public boolean add(NonDeterministicBuildNode nonDeterministicBuildNode) {
            if (nonDeterministicBuildNode instanceof DistanceNode) {
                DistanceNode distanceNode = (DistanceNode)nonDeterministicBuildNode;
                Object object = distanceNode.nonDist();
                DistanceNode distanceNode2 = (DistanceNode)this.map.get(object);
                if (distanceNode2 == null || !distanceNode2.covers(distanceNode)) {
                    assert (distanceNode2 == null || distanceNode.covers(distanceNode2));
                    this.map.put(object, distanceNode);
                    return true;
                }
                return false;
            }
            NonDeterministicBuildNode nonDeterministicBuildNode2 = this.map.get(nonDeterministicBuildNode);
            if (nonDeterministicBuildNode2 == null) {
                this.map.put(nonDeterministicBuildNode, nonDeterministicBuildNode);
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends NonDeterministicBuildNode> collection) {
            boolean bl = false;
            for (NonDeterministicBuildNode nonDeterministicBuildNode : collection) {
                bl |= this.add(nonDeterministicBuildNode);
            }
            return bl;
        }

        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<NonDeterministicBuildNode> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.map.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.map.values().toArray(TArray);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.map.values()).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.map.values()).hashCode();
        }

        public String toString() {
            return this.map.values().toString();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }
}

