/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.LoopReferenceCounter;
import com.ibm.dltj.netgeneric.NetGenericImpl;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildEngine {
    static final int OFFSET_CHILD_INDEX = 0;
    static final int OFFSET_NODE_PTR = 1;
    static final int OFFSET_BACKTRACK_POS = 2;
    static final int OFFSET_CURRENT_DEPTH = 3;
    static final int STACK_MUL = 4;
    static final int INITIAL_SIZE = 32;
    static final int ALLOC_CHUNK = 256;
    final NetGenericImpl net;
    Map<BuildNode, BuildNode> node_map = null;
    BuildNode[] node_stack;
    int[] index_stack;
    List<MinimizerNode> minimizerList;
    static final int HASH_FACTOR = 3;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public BuildEngine(NetGenericImpl netGenericImpl) {
        this.net = netGenericImpl;
    }

    public int buildAndIntegrate(BuildNode buildNode) throws DLTException {
        int n;
        int n2 = 32 + this.net.getMaxIndex();
        int[] nArray = new int[n2];
        this.node_stack = new BuildNode[n2];
        this.index_stack = new int[n2];
        this.net.ensureModifyStarted();
        this.node_map = new HashMap<BuildNode, BuildNode>();
        buildNode = this.remapNode(buildNode);
        int n3 = 0;
        int n4 = 1;
        int n5 = -1;
        int n6 = n4 - 1;
        int n7 = n = 4;
        int n8 = this.buildNode(buildNode, n4);
        int n9 = n8 + 1;
        buildNode.setDepth(n3);
        while (true) {
            if (++n6 < n8) {
                BuildNode buildNode2 = this.node_stack[n6];
                int n10 = buildNode2.getDepth();
                if (n10 == Integer.MIN_VALUE) {
                    nArray[n3 + 1] = n4;
                    nArray[n3 + 0] = n6;
                    nArray[n3 + 3] = n7;
                    nArray[n3 + 2] = n5;
                    n5 = n3;
                    buildNode = buildNode2;
                    n3 = n;
                    n4 = n9;
                    n6 = n4 - 1;
                    nArray = Utils.assureIntArrayRoom(nArray, n + 4, 256);
                    n8 = this.buildNode(buildNode, n4);
                    n9 = n8 + 1;
                    buildNode.setDepth(n3);
                    n7 = n += 4;
                    continue;
                }
                n7 = Math.min(n7, n10);
                continue;
            }
            if (n7 == n3) {
                n9 = this.removeEmptyLinks(n4, n9);
                this.integrateLoop(n4, n9);
                n = n3;
                n9 = n4;
            } else if (n7 > n3) {
                this.removeEmptyLinks(n4, n9);
                this.integrateNonLooping(n4);
                assert (n == n3 + 4);
                n = n3;
                n9 = n4;
            }
            if (n5 == -1) break;
            n3 = n5;
            n4 = nArray[n3 + 1];
            n6 = nArray[n3 + 0];
            n5 = nArray[n3 + 2];
            n7 = Math.min(n7, nArray[n3 + 3]);
            buildNode = this.node_stack[n4 - 1];
            n8 = this.index_stack[n4 - 1];
        }
        buildNode = this.node_stack[0];
        this.node_stack = null;
        this.index_stack = null;
        this.node_map = null;
        return buildNode.getAssignedNode();
    }

    private int removeEmptyLinks(int n, int n2) {
        int n3 = n;
        int n4 = n;
        while (n4 < n2) {
            int n5;
            int n6 = this.index_stack[n4 - 1];
            int n7 = n3;
            for (n5 = n4; n5 < n6; ++n5) {
                if (this.node_stack[n5].getAssignedNode() == -1) continue;
                this.node_stack[n7] = this.node_stack[n5];
                this.index_stack[n7] = this.index_stack[n5];
                ++n7;
            }
            this.index_stack[n3 - 1] = n7;
            this.node_stack[n7] = this.node_stack[n5];
            n3 = n7 + 1;
            n4 = n6 + 1;
        }
        assert (n4 == n2);
        return n3;
    }

    private int buildNode(BuildNode buildNode, int n) throws DLTException {
        int n2 = n;
        buildNode.updateMaxIndex();
        buildNode.startEnumeration();
        while (buildNode.nextTransition()) {
            BuildNode[] buildNodeArray;
            if (this.node_stack.length < n2 + this.net.getMaxIndex()) {
                this.index_stack = Utils.assureIntArrayRoom(this.index_stack, n2 + this.net.getMaxIndex(), 256);
                buildNodeArray = new BuildNode[n2 + this.net.getMaxIndex() + 256];
                System.arraycopy(this.node_stack, 0, buildNodeArray, 0, this.node_stack.length);
                this.node_stack = buildNodeArray;
            }
            buildNodeArray = buildNode.getChild();
            buildNodeArray = this.remapNode((BuildNode)buildNodeArray);
            this.node_stack[n2] = buildNodeArray;
            this.index_stack[n2] = buildNode.getIndex();
            ++n2;
        }
        buildNode.endEnumeration();
        this.node_stack[n - 1] = buildNode;
        this.index_stack[n - 1] = n2;
        return n2;
    }

    private BuildNode remapNode(BuildNode buildNode) throws DLTException {
        if (buildNode.getAssignedNode() == Integer.MIN_VALUE) {
            BuildNode buildNode2 = this.node_map.get(buildNode);
            if (buildNode2 == null) {
                BuildNode buildNode3 = buildNode.expandNode();
                if (buildNode3 != buildNode && (buildNode2 = this.node_map.get(buildNode3)) == null) {
                    this.node_map.put(buildNode3, buildNode3);
                }
                this.node_map.put(buildNode, buildNode3);
                buildNode2 = buildNode3;
            }
            return buildNode2;
        }
        return buildNode;
    }

    private boolean tryLoopCopy(int n, int n2, int n3, int n4) {
        this.node_stack[n - 1].setAssignedNode(n3);
        this.node_stack[n - 1].setDepth(n4);
        int n5 = n;
        while (n5 < n2) {
            BuildNode buildNode = this.node_stack[n5 - 1];
            n3 = buildNode.getAssignedNode();
            assert (n3 != Integer.MIN_VALUE);
            assert (buildNode.getDepth() == n4);
            int n6 = this.index_stack[n5 - 1];
            int n7 = this.net.getMaxIndex();
            int n8 = 1;
            for (int i = n5; i < n6; ++i) {
                while (n8 < this.index_stack[i]) {
                    if (this.net.transitionPresent(n3, n8)) {
                        return false;
                    }
                    ++n8;
                }
                BuildNode buildNode2 = this.node_stack[i];
                int n9 = this.net.takeTransition(n3, this.index_stack[i], -1);
                if (buildNode2.getDepth() == n4 || buildNode2.isFinalized()) {
                    if (buildNode2.getAssignedNode() != n9) {
                        return false;
                    }
                } else {
                    buildNode2.setDepth(n4);
                    buildNode2.setAssignedNode(n9);
                }
                ++n8;
            }
            while (n8 < n7) {
                if (this.net.transitionPresent(n3, n8)) {
                    return false;
                }
                ++n8;
            }
            n5 = n6 + 1;
        }
        return true;
    }

    private void separateClasses() {
        HashMap<MinimizerNode, MinimizerNode> hashMap = new HashMap<MinimizerNode, MinimizerNode>(this.minimizerList.size() * 3 + 1, 0.33333334f);
        while (true) {
            boolean bl = false;
            for (MinimizerNode minimizerNode : this.minimizerList) {
                MinimizerNode minimizerNode2 = (MinimizerNode)hashMap.get(minimizerNode);
                if (minimizerNode2 == null) {
                    hashMap.put(minimizerNode, minimizerNode);
                    minimizerNode2 = minimizerNode;
                }
                minimizerNode.new_class_node = minimizerNode2;
                bl = bl || minimizerNode2 != minimizerNode.class_node;
            }
            if (!bl) {
                return;
            }
            for (MinimizerNode minimizerNode : this.minimizerList) {
                minimizerNode.class_node = minimizerNode.new_class_node;
            }
            hashMap.clear();
        }
    }

    private void minimizeAndIntegrateLoop(int n, int n2) throws DLTException {
        Object object2;
        this.minimizerList = new ArrayList<MinimizerNode>();
        int n3 = n;
        while (n3 < n2) {
            object2 = this.node_stack[n3 - 1];
            assert (!object2.isFinalized());
            object2.setDepth(this.minimizerList.size());
            object2.setAssignedNode(Integer.MIN_VALUE);
            MinimizerNode object3 = new MinimizerNode(n3);
            this.minimizerList.add(object3);
            n3 = this.index_stack[n3 - 1] + 1;
        }
        MinimizerNode minimizerNode = this.minimizerList.get(0);
        for (MinimizerNode minimizerNode2 : this.minimizerList) {
            minimizerNode2.class_node = minimizerNode;
        }
        this.separateClasses();
        object2 = this.net.getReferences();
        BuildNode buildNode = this.minimizerList.get(0).getNode();
        assert (this.minimizerList.get((int)0).class_node == this.minimizerList.get(0));
        int n4 = 0;
        for (MinimizerNode minimizerNode3 : this.minimizerList) {
            int n5;
            if (minimizerNode3 == minimizerNode3.class_node) {
                n5 = this.net.reserveFitForTrans(this.index_stack, minimizerNode3.node_pos, this.index_stack[minimizerNode3.node_pos - 1]);
                minimizerNode3.getNode().setAssignedNode(n5);
                ((LoopReferenceCounter)object2).createSelfReference(n5, buildNode.getAssignedNode());
                continue;
            }
            n5 = minimizerNode3.class_node.getNode().getAssignedNode();
            minimizerNode3.getNode().setAssignedNode(n5);
            ++n4;
        }
        for (MinimizerNode minimizerNode3 : this.minimizerList) {
            if (minimizerNode3 != minimizerNode3.class_node) continue;
            this.net.addSCCNode(minimizerNode3.getNode().getAssignedNode(), this.index_stack, this.node_stack, minimizerNode3.node_pos, this.index_stack[minimizerNode3.node_pos - 1]);
        }
    }

    private boolean findLoopCopy(int n, int n2) {
        if (this.tryLoopCopy(n, n2, -1, 1)) {
            return true;
        }
        IntArray intArray = this.net.getSCCMatchCandidates(this.index_stack, this.node_stack, n, this.index_stack[n - 1]);
        if (intArray != null) {
            int n3 = intArray.size();
            for (int i = 0; i < n3; ++i) {
                if (!this.tryLoopCopy(n, n2, intArray.get(i), -i)) continue;
                return true;
            }
        }
        return false;
    }

    private void integrateLoop(int n, int n2) throws DLTException {
        if (!this.findLoopCopy(n, n2)) {
            this.minimizeAndIntegrateLoop(n, n2);
        }
        int n3 = n;
        while (n3 < n2) {
            BuildNode buildNode = this.node_stack[n3 - 1];
            assert (buildNode.getAssignedNode() != Integer.MIN_VALUE);
            buildNode.setFinalized();
            n3 = this.index_stack[n3 - 1] + 1;
        }
    }

    private void integrateNonLooping(int n) throws DLTException {
        BuildNode buildNode = this.node_stack[n - 1];
        buildNode.setAssignedNode(this.net.addNode(this.index_stack, this.node_stack, n, this.index_stack[n - 1]));
        buildNode.setFinalized();
    }

    private class MinimizerNode {
        int node_pos;
        MinimizerNode class_node;
        MinimizerNode new_class_node;

        MinimizerNode(int n) {
            this.node_pos = n;
        }

        BuildNode getNode() {
            return BuildEngine.this.node_stack[this.node_pos - 1];
        }

        public int hashCode() {
            int n = 1;
            int n2 = BuildEngine.this.index_stack[this.node_pos - 1];
            for (int i = this.node_pos; i < n2; ++i) {
                int n3 = BuildEngine.this.node_stack[i].getAssignedNode();
                int n4 = BuildEngine.this.index_stack[i];
                if (n3 == Integer.MIN_VALUE) {
                    MinimizerNode minimizerNode = BuildEngine.this.minimizerList.get(BuildEngine.this.node_stack[i].getDepth());
                    n3 = -minimizerNode.class_node.node_pos;
                }
                n = Utils.combineHash(n, n4, n3);
            }
            return n;
        }

        public boolean equals(Object object) {
            MinimizerNode minimizerNode = (MinimizerNode)object;
            if (this.node_pos == minimizerNode.node_pos) {
                return true;
            }
            int n = BuildEngine.this.index_stack[this.node_pos - 1] - this.node_pos;
            if (BuildEngine.this.index_stack[minimizerNode.node_pos - 1] - minimizerNode.node_pos != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                if (BuildEngine.this.index_stack[this.node_pos + i] != BuildEngine.this.index_stack[minimizerNode.node_pos + i]) {
                    return false;
                }
                BuildNode buildNode = BuildEngine.this.node_stack[this.node_pos + i];
                BuildNode buildNode2 = BuildEngine.this.node_stack[minimizerNode.node_pos + i];
                if (buildNode == buildNode2) continue;
                int n3 = buildNode.getAssignedNode();
                if (n3 != (n2 = buildNode2.getAssignedNode())) {
                    return false;
                }
                if (buildNode.getAssignedNode() != Integer.MIN_VALUE) continue;
                MinimizerNode minimizerNode2 = BuildEngine.this.minimizerList.get(buildNode.getDepth());
                MinimizerNode minimizerNode3 = BuildEngine.this.minimizerList.get(buildNode2.getDepth());
                if (minimizerNode2.class_node == minimizerNode3.class_node) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getNode().toString();
        }
    }
}

