/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;

public abstract class BuildNodeBase
implements BuildNode {
    protected int depth = Integer.MIN_VALUE;
    int assigned_node = Integer.MIN_VALUE;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getAssignedNode() {
        return this.assigned_node;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int n) {
        this.depth = n;
    }

    @Override
    public void setAssignedNode(int n) {
        this.assigned_node = n;
    }

    @Override
    public BuildNode getChild() throws DLTException {
        return null;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public boolean nextTransition() {
        return false;
    }

    @Override
    public void updateMaxIndex() throws DLTException {
    }

    @Override
    public void startEnumeration() throws DLTException {
        this.depth = -1;
    }

    @Override
    public void endEnumeration() {
        this.depth = Integer.MIN_VALUE;
    }

    public String toString() {
        return "A" + this.assigned_node;
    }

    @Override
    public BuildNode expandNode() throws DLTException {
        return this;
    }

    protected static BuildNode makeAssignedNode(int n) {
        return new AssignedBuildNode(n);
    }

    @Override
    public int markEnumeration() {
        return this.depth;
    }

    @Override
    public void resumeEnumeration(int n) {
        this.depth = n;
    }

    @Override
    public boolean isFinalized() {
        return this.depth == Integer.MAX_VALUE;
    }

    @Override
    public void setFinalized() {
        this.depth = Integer.MAX_VALUE;
    }

    static class AssignedBuildNode
    extends BuildNodeBase {
        AssignedBuildNode(int n) {
            this.assigned_node = n;
            this.depth = Integer.MAX_VALUE;
        }

        public boolean equals(Object object) {
            if (object instanceof AssignedBuildNode) {
                return ((AssignedBuildNode)object).assigned_node == this.assigned_node;
            }
            if (object instanceof BuildNode) {
                BuildNode buildNode = (BuildNode)object;
                return buildNode.isFinalized() && buildNode.getAssignedNode() == this.assigned_node;
            }
            return false;
        }

        public int hashCode() {
            return this.assigned_node;
        }
    }
}

