/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeCompiled;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;

public final class BuildNodeIntersector
extends BuildNodeCompiled {
    final BuildNode left;
    final BuildNode right;
    final NetGeneric net;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private BuildNodeIntersector(BuildNode buildNode, BuildNode buildNode2, NetGeneric netGeneric) {
        assert (buildNode != null && buildNode2 != null);
        this.left = buildNode;
        this.right = buildNode2;
        this.net = netGeneric;
    }

    public static BuildNode makeNodeIntersector(BuildNode buildNode, BuildNode buildNode2, NetGeneric netGeneric) {
        if (buildNode == null || buildNode2 == null) {
            return BuildNodeIntersector.makeAssignedNode(-1);
        }
        if (buildNode.equals(buildNode2)) {
            return buildNode;
        }
        return new BuildNodeIntersector(buildNode, buildNode2, netGeneric);
    }

    public static BuildNode makeNodeIntersector(NonDeterministicBuildNode nonDeterministicBuildNode, NonDeterministicBuildNode nonDeterministicBuildNode2, NetGeneric netGeneric) {
        return new BuildNodeIntersector(NonDeterministicNodeAdapter.createAdapter(nonDeterministicBuildNode, netGeneric), NonDeterministicNodeAdapter.createAdapter(nonDeterministicBuildNode2, netGeneric), netGeneric);
    }

    @Override
    public BuildNode expandNode() throws DLTException {
        BuildNode buildNode = this.left.expandNode();
        BuildNode buildNode2 = this.right.expandNode();
        if (buildNode != this.left || buildNode2 != this.right) {
            return BuildNodeIntersector.makeNodeIntersector(buildNode, buildNode2, this.net);
        }
        return this;
    }

    @Override
    public void updateMaxIndex() throws DLTException {
        this.left.updateMaxIndex();
        this.right.updateMaxIndex();
    }

    @Override
    public void startEnumeration() throws DLTException {
        this.enumerate(this.left);
        if (this.indices.isEmpty()) {
            super.startEnumeration();
            return;
        }
        int n = 0;
        this.right.startEnumeration();
        block0: while (n < this.indices.size() && this.right.nextTransition()) {
            int n2 = this.right.getIndex();
            while (this.indices.get(n) < n2) {
                this.indices.remove(n);
                this.children.remove(n);
                if (n < this.indices.size()) continue;
                break block0;
            }
            if (n2 != this.indices.get(n)) continue;
            this.children.set(n, this.getChild(n2, (BuildNode)this.children.get(n), this.right.getChild()));
            ++n;
        }
        this.right.endEnumeration();
        while (n < this.indices.size()) {
            this.indices.remove(n);
            this.children.remove(n);
        }
        super.startEnumeration();
    }

    private BuildNode getChild(int n, BuildNode buildNode, BuildNode buildNode2) throws DLTException {
        if (n < this.net.getFirstLinkIndex()) {
            return BuildNodeIntersector.makeAssignedNode(this.net.getPayloadManipulator(n).intersectInternal(buildNode.getAssignedNode(), buildNode2.getAssignedNode()));
        }
        return BuildNodeIntersector.makeNodeIntersector(buildNode, buildNode2, this.net);
    }

    @Override
    public String toString() {
        return "<" + this.left + '&' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.left == null ? 0 : this.left.hashCode());
        n = 31 * n + (this.right == null ? 0 : this.right.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BuildNodeIntersector buildNodeIntersector = (BuildNodeIntersector)object;
        if (!this.left.equals(buildNodeIntersector.left)) {
            return false;
        }
        return this.right.equals(buildNodeIntersector.right);
    }
}

