/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericImpl;

public class BuildNodeMerger
extends BuildEngine
implements NetGeneric.ChangeEncapsulator {
    BuildNode rroot;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    BuildNodeMerger(NetGenericImpl netGenericImpl, BuildNode buildNode) {
        super(netGenericImpl);
        this.rroot = buildNode;
    }

    void reset(BuildNode buildNode) {
        this.rroot = buildNode;
    }

    @Override
    public int Apply(int n) throws DLTException {
        if (this.rroot == null) {
            return n;
        }
        BuildNode buildNode = this.rroot;
        if (n != -1) {
            buildNode = new NetAndBuildNode(n, this.rroot);
        }
        int n2 = this.buildAndIntegrate(buildNode);
        return n2;
    }

    class NetAndBuildNode
    extends BuildNodeBase {
        int left;
        BuildNode right;
        int next_right;

        public NetAndBuildNode(int n, BuildNode buildNode) {
            this.left = n;
            this.right = buildNode;
        }

        @Override
        public BuildNode expandNode() throws DLTException {
            BuildNode buildNode = this.right.expandNode();
            if (buildNode != this.right) {
                return new NetAndBuildNode(this.left, buildNode);
            }
            return this;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            this.right.updateMaxIndex();
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.right.startEnumeration();
            this.depth = 0;
            this.next_right = this.right.nextTransition() ? this.right.getIndex() : Integer.MAX_VALUE;
        }

        @Override
        public void endEnumeration() {
            super.endEnumeration();
            this.right.endEnumeration();
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            int n2 = BuildNodeMerger.this.net.takeTransition(this.left, n, -1);
            if (this.next_right > n) {
                return NetAndBuildNode.makeAssignedNode(n2);
            }
            BuildNode buildNode = this.right.getChild();
            if (n < BuildNodeMerger.this.net.getFirstLinkIndex()) {
                return NetAndBuildNode.makeAssignedNode(BuildNodeMerger.this.net.getPayloadManipulator(n).mergeInternal(n2, buildNode.getAssignedNode()));
            }
            return new NetAndBuildNode(n2, buildNode);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth + 1;
            if (n > this.next_right) {
                this.next_right = this.right.nextTransition() ? this.right.getIndex() : Integer.MAX_VALUE;
            }
            int n2 = Math.min(BuildNodeMerger.this.net.getMaxIndex(), this.next_right);
            while (n < n2) {
                if (BuildNodeMerger.this.net.transitionPresent(this.left, n)) {
                    this.depth = n;
                    return true;
                }
                ++n;
            }
            this.depth = n;
            return n == this.next_right;
        }

        public int hashCode() {
            return 31 * this.right.hashCode() + this.left;
        }

        public boolean equals(Object object) {
            NetAndBuildNode netAndBuildNode = (NetAndBuildNode)object;
            return this.left == netAndBuildNode.left && this.right.equals(netAndBuildNode.right);
        }

        @Override
        public String toString() {
            return "<" + this.left + ',' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }
    }
}

