/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.netgeneric.UnicodeSetTransition;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class CharRuleState
implements RegExBuilder.RegExElement {
    boolean final_state = false;
    List<UnicodeSet> transition_sets = new ArrayList<UnicodeSet>();
    List<String> transition_states = new ArrayList<String>();
    UnicodeSetTransition.SetToCode codemap;
    RegExBuilder builder;
    Map<String, CharRuleState> states;
    List<String> epsilons = new ArrayList<String>();

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CharRuleState(UnicodeSetTransition.SetToCode setToCode, RegExBuilder regExBuilder, Map<String, CharRuleState> map) {
        this.codemap = setToCode;
        this.builder = regExBuilder;
        this.states = map;
    }

    public void markFinal() {
        this.final_state = true;
    }

    public void addTransition(UnicodeSet unicodeSet, String string) {
        this.transition_sets.add(unicodeSet);
        this.transition_states.add(string);
    }

    public void addEpsilonTransition(String string) {
        this.epsilons.add(string);
    }

    @Override
    public int build(int n) throws DLTException {
        NetGenericFullAccess netGenericFullAccess = this.builder.net;
        int n2 = this.builder.loopnest;
        BitSet bitSet = new BitSet();
        bitSet.set(n2);
        int n3 = netGenericFullAccess.getPayloadManipulator(1).merge(-1, bitSet);
        RegExBuilder.RegExNode regExNode = new RegExBuilder.RegExNode(1, n3);
        BuildNode buildNode = NonDeterministicNodeAdapter.createAdapter(new Node(regExNode), netGenericFullAccess);
        buildNode = netGenericFullAccess.adaptBuildNode(buildNode);
        int n4 = this.builder.merger.buildAndIntegrate(buildNode);
        netGenericFullAccess.getReferences().addReference(-1, n);
        netGenericFullAccess.getReferences().addReference(-1, n4);
        int n5 = this.builder.loopMaker.attachTrail(n4, n, n2);
        netGenericFullAccess.getReferences().removeReference(-1, n);
        netGenericFullAccess.getReferences().removeReferenceKeeping(-1, n4, n5);
        return n5;
    }

    CharRuleState getState(String string) {
        CharRuleState charRuleState = this.states.get(string);
        if (charRuleState == null) {
            throw new IllegalArgumentException(Messages.format("error.argument.unknownstate", string));
        }
        return charRuleState;
    }

    @Override
    public NonDeterministicBuildNode getNode(Object object) throws DLTException {
        return new Node(NonDeterministicNodeAdapter.nonDeterministicNode(this.builder.net, object));
    }

    public String toString() {
        for (Map.Entry<String, CharRuleState> entry : this.states.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return "??";
    }

    class Node
    implements NonDeterministicBuildNode {
        NonDeterministicBuildNode trail;
        int index;
        int subindex;
        BitSet cur_set;
        Object cur_state;

        Node(NonDeterministicBuildNode nonDeterministicBuildNode) {
            this.trail = nonDeterministicBuildNode;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.index = CharRuleState.this.final_state ? -2 : -1;
            return CharRuleState.this.epsilons.size() > this.index + 1;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            Node node;
            ++this.index;
            if (this.index == -1) {
                return this.trail;
            }
            if (this.index < CharRuleState.this.epsilons.size()) {
                CharRuleState charRuleState = CharRuleState.this.getState(CharRuleState.this.epsilons.get(this.index));
                charRuleState.getClass();
                node = charRuleState.new Node(this.trail);
            } else {
                node = null;
            }
            return node;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.index = -1;
        }

        @Override
        public void endEnumeration() {
        }

        @Override
        public Object getChild() throws DLTException {
            return this.cur_state;
        }

        @Override
        public int getIndex() {
            return this.subindex;
        }

        @Override
        public boolean nextTransition() {
            this.subindex = this.index >= 0 ? this.cur_set.nextSetBit(this.subindex + 1) : -1;
            while (this.subindex < 0) {
                ++this.index;
                if (this.index >= CharRuleState.this.transition_sets.size()) {
                    return false;
                }
                this.cur_set = CharRuleState.this.codemap.getCodes(CharRuleState.this.transition_sets.get(this.index));
                CharRuleState charRuleState = CharRuleState.this.getState(CharRuleState.this.transition_states.get(this.index));
                charRuleState.getClass();
                this.cur_state = charRuleState.new Node(this.trail);
                this.subindex = this.cur_set.nextSetBit(0);
            }
            return true;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.trail == null ? 0 : this.trail.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Node node = (Node)object;
            if (!this.getOuterType().equals(node.getOuterType())) {
                return false;
            }
            return !(this.trail == null ? node.trail != null : !this.trail.equals(node.trail));
        }

        private CharRuleState getOuterType() {
            return CharRuleState.this;
        }

        public String toString() {
            return CharRuleState.this.toString() + this.trail;
        }
    }
}

