/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.RegExBuilder;

public class CharacterMapper
implements RegExBuilder.RegExElement {
    final int stages;
    final int stagebits;
    final int stagemask;
    final NetGenericFullAccess net;
    char[] map;
    int first;
    int nodesize;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CharacterMapper(int n, NetGeneric netGeneric) throws DLTException {
        this.stages = n;
        this.stagebits = 15 / n + 1;
        this.stagemask = (1 << this.stagebits) - 1;
        this.net = (NetGenericFullAccess)netGeneric;
        netGeneric.setMaxIndex(Math.max(netGeneric.getMaxIndex(), 4 + this.stagemask + 1));
    }

    @Override
    public int build(int n) throws DLTException {
        this.net.setMaxIndex(Math.max(this.net.getMaxIndex(), 4 + this.stagemask + 1));
        BuildNode buildNode = this.getNode(null);
        buildNode = this.net.adaptBuildNode(buildNode);
        int n2 = this.net.getInPlaceMerger().buildAndIntegrate(buildNode);
        return n2;
    }

    @Override
    public BuildNode getNode(Object object) throws DLTException {
        this.net.setMaxIndex(Math.max(this.net.getMaxIndex(), 4 + this.stagemask + 1));
        return new LowercaseMapperNode(1 << (this.stages - 1) * this.stagebits, 0);
    }

    void transform() {
        int n;
        int[] nArray = new int[this.net.getSize()];
        int n2 = this.net.getMaxIndex() - 4;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (!this.net.getReferences().allocated(n) || this.net.transitionPresent(n, 3)) continue;
            nArray[n] = n3 += n2;
        }
        this.map = new char[n3 += n2];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            for (int i = 0; i < n2; ++i) {
                if (!this.net.transitionPresent(n, i + 4)) continue;
                int n4 = this.net.transitionValue(n, i + 4);
                n4 = this.net.transitionPresent(n4, 3) ? this.net.transitionValue(n4, 3) : nArray[n4];
                this.map[nArray[n] + i] = (char)n4;
            }
        }
        this.first = (char)nArray[this.net.first_base()];
        this.nodesize = (char)n2;
        System.out.println("First: " + this.first);
        System.out.println("Transformed size: " + this.map.length);
    }

    int findFullFit(char[] cArray, int n, int n2) {
        int n3;
        block0: for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < this.nodesize; ++i) {
                if (cArray[n3 + i] != this.map[n2 + i]) continue block0;
            }
        }
        return n3;
    }

    int calcOverlap(char[] cArray, int n, int n2) {
        int n3;
        block0: for (n3 = 0; n3 < this.nodesize; ++n3) {
            int n4 = 0;
            while (n3 + n4 < this.nodesize) {
                if (cArray[n + n3 + n4] != this.map[n2 + n4]) continue block0;
                ++n4;
            }
            break block0;
        }
        return this.nodesize - n3;
    }

    /*
     * Unable to fully structure code
     */
    void optimize() {
        var1_1 = this.map.length / this.nodesize;
        var2_2 = new int[var1_1];
        var2_2[this.first / this.nodesize] = -1;
        for (var3_3 = 1; var3_3 < this.stages; ++var3_3) {
            for (var4_5 = 0; var4_5 < var1_1; ++var4_5) {
                if (var2_2[var4_5] != -var3_3) continue;
                for (var5_6 = 0; var5_6 < this.nodesize; ++var5_6) {
                    if (this.map[var4_5 * this.nodesize + var5_6] == '\u0000') continue;
                    var2_2[this.map[var4_5 * this.nodesize + var5_6] / this.nodesize] = -1 - var3_3;
                }
            }
        }
        var3_4 = new char[this.map.length];
        var4_5 = 0;
        var2_2[0] = 0;
        var5_6 = 0;
        block3: for (var6_7 = -this.stages; var6_7 <= -1; ++var6_7) {
            if (var6_7 != -this.stages) {
                for (var7_8 = 0; var7_8 < var1_1; ++var7_8) {
                    if (var2_2[var7_8] != var6_7) continue;
                    for (var8_9 = 0; var8_9 < this.nodesize; ++var8_9) {
                        this.map[var7_8 * this.nodesize + var8_9] = (char)var2_2[this.map[var7_8 * this.nodesize + var8_9] / this.nodesize];
                    }
                }
            }
            block6: while (true) {
                var7_8 = -1;
                var8_9 = -1;
                for (var10_11 = 0; var10_11 < var1_1; ++var10_11) {
                    if (var2_2[var10_11] != var6_7) continue;
                    var9_10 = this.findFullFit(var3_4, var4_5, var10_11 * this.nodesize);
                    if (var9_10 < var4_5) {
                        var2_2[var10_11] = var9_10;
                        var5_6 += this.nodesize;
                        continue block6;
                    }
                    var9_10 = this.calcOverlap(var3_4, var4_5, var10_11 * this.nodesize);
                    if (var9_10 <= var8_9) continue;
                    var8_9 = var9_10;
                    var7_8 = var10_11;
                }
                if (var7_8 == -1) continue block3;
                var2_2[var7_8] = var4_5 + this.nodesize - var8_9;
                var5_6 += var8_9;
                var4_5 = var2_2[var7_8];
                var10_11 = var7_8 * this.nodesize;
                var11_12 = var8_9;
                while (true) {
                    if (var11_12 < this.nodesize) ** break;
                    continue block6;
                    var3_4[var4_5 + var11_12] = this.map[var10_11 + var11_12];
                    ++var11_12;
                }
                break;
            }
        }
        if (var5_6 > 0) {
            System.out.format("Saving %d cells with overlap to %d\n", new Object[]{var5_6, this.map.length - var5_6});
            this.map = new char[var4_5 + this.nodesize];
            System.arraycopy(var3_4, 0, this.map, 0, this.map.length);
            this.first = (char)var2_2[this.first / this.nodesize];
        }
    }

    class FinalNode
    extends BuildNodeBase {
        int diff;

        @Override
        public String toString() {
            return "F" + this.diff;
        }

        public FinalNode(int n) {
            this.diff = n;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.diff;
            return n;
        }

        @Override
        public BuildNode getChild() throws DLTException {
            return FinalNode.makeAssignedNode(this.diff);
        }

        @Override
        public int getIndex() {
            return 3;
        }

        @Override
        public boolean nextTransition() {
            return ++this.depth == 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FinalNode finalNode = (FinalNode)object;
            if (!this.getOuterType().equals(finalNode.getOuterType())) {
                return false;
            }
            return this.diff == finalNode.diff;
        }

        private CharacterMapper getOuterType() {
            return CharacterMapper.this;
        }
    }

    class LowercaseMapperNode
    extends BuildNodeBase {
        final int stagemul;
        final int stageofs;

        @Override
        public String toString() {
            return "S" + this.stagemul + ',' + this.stageofs;
        }

        public LowercaseMapperNode(int n, int n2) {
            this.stagemul = n;
            this.stageofs = n2;
        }

        @Override
        public boolean nextTransition() {
            if (this.stageofs >= 65536) {
                return false;
            }
            return ++this.depth <= CharacterMapper.this.stagemask;
        }

        @Override
        public BuildNode getChild() throws DLTException {
            if (this.stagemul == 1) {
                int n = this.stageofs + this.depth;
                int n2 = Character.toLowerCase(n);
                char c = (char)(n2 - n);
                if (c == '\u0000') {
                    return LowercaseMapperNode.makeAssignedNode(-1);
                }
                return new FinalNode(c);
            }
            int n = this.stagemul >> CharacterMapper.this.stagebits;
            return new LowercaseMapperNode(n, this.stageofs + this.depth * this.stagemul);
        }

        @Override
        public int getIndex() {
            return this.depth + 4;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.stagemul;
            n = 31 * n + this.stageofs;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LowercaseMapperNode lowercaseMapperNode = (LowercaseMapperNode)object;
            if (!this.getOuterType().equals(lowercaseMapperNode.getOuterType())) {
                return false;
            }
            if (this.stagemul != lowercaseMapperNode.stagemul) {
                return false;
            }
            return this.stageofs == lowercaseMapperNode.stageofs;
        }

        private CharacterMapper getOuterType() {
            return CharacterMapper.this;
        }
    }
}

