/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionConjunction;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DecompositionTerm
implements DecompositionAtom {
    private final Collection<DecompositionAtom> pos_atoms;
    private final Collection<DecompositionAtom> neg_atoms;
    static final Collection<DecompositionAtom> EMPTY_SET = new LinkedHashSet<DecompositionAtom>();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private DecompositionTerm(Collection<DecompositionAtom> collection, Collection<DecompositionAtom> collection2) {
        this.pos_atoms = collection;
        this.neg_atoms = collection2;
    }

    public static DecompositionTerm createTerm(DecompositionAtom decompositionAtom) {
        assert (!(decompositionAtom instanceof DecompositionTerm));
        LinkedHashSet<DecompositionAtom> linkedHashSet = new LinkedHashSet<DecompositionAtom>(1);
        linkedHashSet.add(decompositionAtom);
        return new DecompositionTerm(linkedHashSet, EMPTY_SET);
    }

    public static DecompositionTerm createNegation(DecompositionAtom decompositionAtom) {
        assert (!(decompositionAtom instanceof DecompositionTerm));
        LinkedHashSet<DecompositionAtom> linkedHashSet = new LinkedHashSet<DecompositionAtom>(1);
        linkedHashSet.add(decompositionAtom);
        return new DecompositionTerm(EMPTY_SET, linkedHashSet);
    }

    public static DecompositionTerm createConjunction(DecompositionTerm decompositionTerm, DecompositionTerm decompositionTerm2) {
        if (decompositionTerm == null || decompositionTerm2 == null) {
            return null;
        }
        LinkedHashSet<DecompositionAtom> linkedHashSet = new LinkedHashSet<DecompositionAtom>(decompositionTerm.pos_atoms);
        LinkedHashSet<DecompositionAtom> linkedHashSet2 = new LinkedHashSet<DecompositionAtom>(decompositionTerm.neg_atoms);
        for (DecompositionAtom decompositionAtom : decompositionTerm2.pos_atoms) {
            if (decompositionTerm.neg_atoms.contains(decompositionAtom)) {
                return null;
            }
            linkedHashSet.add(decompositionAtom);
        }
        for (DecompositionAtom decompositionAtom : decompositionTerm2.neg_atoms) {
            if (decompositionTerm.pos_atoms.contains(decompositionAtom)) {
                return null;
            }
            linkedHashSet2.add(decompositionAtom);
        }
        return new DecompositionTerm(linkedHashSet, linkedHashSet2);
    }

    @Override
    public boolean test(Gloss gloss, int n, int n2, DecompositionAtom.ExtraInfoAccess extraInfoAccess) {
        for (DecompositionAtom decompositionAtom : this.pos_atoms) {
            if (decompositionAtom.test(gloss, n, n2, extraInfoAccess)) continue;
            return false;
        }
        for (DecompositionAtom decompositionAtom : this.neg_atoms) {
            if (!decompositionAtom.test(gloss, n, n2, extraInfoAccess)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getType() {
        return 128;
    }

    @Override
    public void save(DataOutput dataOutput) throws IOException {
        this.toConjunction().save(dataOutput);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecompositionTerm)) {
            return false;
        }
        DecompositionTerm decompositionTerm = (DecompositionTerm)object;
        return ((Object)decompositionTerm.pos_atoms).equals(this.pos_atoms) && ((Object)decompositionTerm.neg_atoms).equals(this.neg_atoms);
    }

    public int hashCode() {
        return ((Object)this.pos_atoms).hashCode() ^ ((Object)this.neg_atoms).hashCode() << 1;
    }

    public String toString() {
        String string = "[";
        boolean bl = false;
        Iterator<DecompositionAtom> iterator = this.pos_atoms.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                string = string + '&';
            } else {
                bl = true;
            }
            string = string + iterator.next().toString();
        }
        iterator = this.neg_atoms.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                string = string + '&';
            } else {
                bl = true;
            }
            string = string + '~' + iterator.next().toString();
        }
        string = string + ']';
        return string;
    }

    public Set<DecompositionTerm> getNegatedTermsList() {
        LinkedHashSet<DecompositionTerm> linkedHashSet = new LinkedHashSet<DecompositionTerm>();
        for (DecompositionAtom decompositionAtom : this.pos_atoms) {
            linkedHashSet.add(DecompositionTerm.createNegation(decompositionAtom));
        }
        for (DecompositionAtom decompositionAtom : this.neg_atoms) {
            linkedHashSet.add(DecompositionTerm.createTerm(decompositionAtom));
        }
        return linkedHashSet;
    }

    @Override
    public DecompositionAtom negate() {
        return null;
    }

    @Override
    public boolean perSurfaceForm() {
        for (DecompositionAtom decompositionAtom : this.pos_atoms) {
            if (decompositionAtom.perSurfaceForm()) continue;
            return false;
        }
        for (DecompositionAtom decompositionAtom : this.neg_atoms) {
            if (decompositionAtom.perSurfaceForm()) continue;
            return false;
        }
        return true;
    }

    public DecompositionAtom toConjunction() {
        if (this.pos_atoms.size() == 1 && this.neg_atoms.isEmpty()) {
            return this.pos_atoms.iterator().next();
        }
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>(this.pos_atoms);
        for (DecompositionAtom decompositionAtom : this.neg_atoms) {
            arrayList.add(decompositionAtom.negate());
        }
        DecompositionAtom decompositionAtom = DecompositionConjunction.makeConjunction(arrayList);
        return decompositionAtom;
    }
}

