/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.DecompositionTerm;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.RegExBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DecompositionTermSet
implements RegExBuilder.RegExElement {
    final Set<DecompositionTerm> disjuncts;
    final NetGenericFullAccess net;
    final List<DecompositionTerm> atoms;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private DecompositionTermSet(NetGeneric netGeneric, List<DecompositionTerm> list, Set<DecompositionTerm> set) {
        this.atoms = list;
        this.net = (NetGenericFullAccess)netGeneric;
        this.disjuncts = set;
        this.createTransitions();
    }

    private DecompositionTermSet(Set<DecompositionTerm> set, NetGenericFullAccess netGenericFullAccess, List<DecompositionTerm> list) {
        this.disjuncts = set;
        this.net = netGenericFullAccess;
        this.atoms = list;
        this.createTransitions();
    }

    public static DecompositionTermSet createSet(NetGeneric netGeneric, List<DecompositionTerm> list, DecompositionTerm decompositionTerm) {
        LinkedHashSet<DecompositionTerm> linkedHashSet = new LinkedHashSet<DecompositionTerm>(1);
        linkedHashSet.add(decompositionTerm);
        return new DecompositionTermSet(netGeneric, list, linkedHashSet);
    }

    public static DecompositionTermSet createDisjunction(DecompositionTermSet decompositionTermSet, DecompositionTermSet decompositionTermSet2) {
        LinkedHashSet<DecompositionTerm> linkedHashSet = new LinkedHashSet<DecompositionTerm>(decompositionTermSet.disjuncts);
        linkedHashSet.addAll(decompositionTermSet2.disjuncts);
        return new DecompositionTermSet(linkedHashSet, decompositionTermSet.net, decompositionTermSet.atoms);
    }

    public static DecompositionTermSet createConjunction(DecompositionTermSet decompositionTermSet, DecompositionTermSet decompositionTermSet2) {
        LinkedHashSet<DecompositionTerm> linkedHashSet = new LinkedHashSet<DecompositionTerm>();
        for (DecompositionTerm decompositionTerm : decompositionTermSet.disjuncts) {
            for (DecompositionTerm decompositionTerm2 : decompositionTermSet2.disjuncts) {
                DecompositionTerm decompositionTerm3 = DecompositionTerm.createConjunction(decompositionTerm, decompositionTerm2);
                if (decompositionTerm3 == null) continue;
                linkedHashSet.add(decompositionTerm3);
            }
        }
        return new DecompositionTermSet(linkedHashSet, decompositionTermSet.net, decompositionTermSet.atoms);
    }

    private static DecompositionTermSet createNegation(DecompositionTerm decompositionTerm, NetGenericFullAccess netGenericFullAccess, List<DecompositionTerm> list) {
        Set<DecompositionTerm> set = decompositionTerm.getNegatedTermsList();
        return new DecompositionTermSet(set, netGenericFullAccess, list);
    }

    public static DecompositionTermSet createNegation(DecompositionTermSet decompositionTermSet) {
        DecompositionTermSet decompositionTermSet2 = null;
        for (DecompositionTerm decompositionTerm : decompositionTermSet.disjuncts) {
            DecompositionTermSet decompositionTermSet3 = DecompositionTermSet.createNegation(decompositionTerm, decompositionTermSet.net, decompositionTermSet.atoms);
            if (decompositionTermSet2 == null) {
                decompositionTermSet2 = decompositionTermSet3;
                continue;
            }
            decompositionTermSet2 = DecompositionTermSet.createConjunction(decompositionTermSet2, decompositionTermSet3);
        }
        return decompositionTermSet2;
    }

    public Iterator<DecompositionTerm> iterator() {
        return this.disjuncts.iterator();
    }

    int createTransition(DecompositionTerm decompositionTerm) {
        int n = this.atoms.indexOf(decompositionTerm);
        if (n == -1) {
            n = this.atoms.size();
            this.atoms.add(decompositionTerm);
        }
        return n + 4;
    }

    int[] createTransitions() {
        int[] nArray = new int[this.disjuncts.size()];
        int n = 0;
        for (DecompositionTerm decompositionTerm : this.disjuncts) {
            nArray[n++] = this.createTransition(decompositionTerm);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    @Override
    public int build(int n) throws DLTException {
        int[] nArray = this.createTransitions();
        this.net.setMaxIndex(this.atoms.size() + 4);
        return this.net.addNode(nArray, n, nArray.length);
    }

    @Override
    public Object getNode(Object object) throws DLTException {
        return null;
    }

    public String toString() {
        return this.disjuncts.toString();
    }
}

