/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.gloss.FeatureStructureGloss;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.StringArrayGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.util.IntArray;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DictInserter
implements RegExBuilder.RegExElement {
    final NetGeneric net;
    final NetGenericDictionary dict;
    final CharacterMap char_map;
    final RegExBuilder builder;
    CharacterMap.MapMergeData merge_data;
    final BitSet final_val;
    final Gloss gloss_filter;
    static Map<Object, Boolean> randomMap = new HashMap<Object, Boolean>();
    Random random = new Random(1L);

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DictInserter(RegExBuilder regExBuilder, CharacterMap characterMap, NetGenericDictionary netGenericDictionary, Gloss gloss) throws DLTException {
        this.dict = netGenericDictionary;
        this.net = netGenericDictionary.getNet();
        this.gloss_filter = gloss;
        this.char_map = characterMap;
        this.builder = regExBuilder;
        this.final_val = new BitSet();
    }

    public void adjustCharacterMap(CharacterMap characterMap) {
        characterMap.combineMaps(this.dict.getCharacterMap(), this.dict.isStaged());
    }

    @Override
    public int build(int n) throws DLTException {
        int n2 = this.builder.loopnest;
        this.final_val.clear();
        this.final_val.set(n2);
        NetGenericFullAccess netGenericFullAccess = this.builder.net;
        int n3 = this.char_map.getMaxIndex();
        this.merge_data = this.char_map.combineMaps(this.dict.getCharacterMap(), this.dict.isStaged());
        assert (n3 == this.char_map.getMaxIndex());
        assert (this.merge_data.destDuplications == null);
        this.merge_data.destToSource.set(1, 3);
        this.merge_data.destToSource.set(3, 1);
        RegExBuilder.RegExNode regExNode = new RegExBuilder.RegExNode(1, this.builder.loopMaker.loop_nests.merge(-1, this.final_val));
        BuildNode buildNode = NonDeterministicNodeAdapter.createAdapter(new DictionaryMapping(this.net.first_base(), regExNode), netGenericFullAccess);
        buildNode = netGenericFullAccess.adaptBuildNode(buildNode);
        int n4 = this.builder.merger.buildAndIntegrate(buildNode);
        if (n4 == -1) {
            netGenericFullAccess.getReferences().addReference(-1, n);
            netGenericFullAccess.getReferences().removeReference(-1, n);
            return -1;
        }
        netGenericFullAccess.getReferences().addReference(-1, n);
        netGenericFullAccess.getReferences().addReference(-1, n4);
        int n5 = this.builder.loopMaker.attachTrail(n4, n, n2);
        netGenericFullAccess.getReferences().removeReference(-1, n);
        netGenericFullAccess.getReferences().removeReferenceKeeping(-1, n4, n5);
        return n5;
    }

    boolean randomize(Object object, int n) {
        Boolean bl = randomMap.get(object);
        if (bl == null) {
            bl = this.random.nextInt(n) == n / 2;
            randomMap.put(object, bl);
        }
        return bl;
    }

    boolean validateMidGloss(MidGloss midGloss, MidGloss midGloss2, int n) throws DLTException {
        for (int i = n; i < midGloss2.numChildren(); ++i) {
            Gloss gloss = midGloss2.getChild(i);
            Gloss gloss2 = midGloss.getGloss(gloss.getClass());
            if (this.validateGloss(gloss2, gloss)) continue;
            return false;
        }
        return true;
    }

    boolean validateGloss(Gloss gloss, Gloss gloss2) throws DLTException {
        if (gloss == null) {
            return false;
        }
        if (gloss2 == null) {
            return true;
        }
        if (gloss2 instanceof StringArrayGloss) {
            return true;
        }
        if (gloss2 instanceof FeatureStructureGloss) {
            if (gloss.getType() != gloss2.getType()) {
                return false;
            }
            FeatureStructureGloss featureStructureGloss = (FeatureStructureGloss)gloss;
            FeatureStructureGloss featureStructureGloss2 = (FeatureStructureGloss)gloss2;
            if (!featureStructureGloss.getFSType().equals(featureStructureGloss2.getFSType())) {
                return false;
            }
            String[] stringArray = featureStructureGloss2.getFeatureSpec();
            Object[] objectArray = (String[])featureStructureGloss.getFeatureSpec().clone();
            Arrays.sort(objectArray);
            int n = featureStructureGloss2.numChildren() - 1 - stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = Arrays.binarySearch(objectArray, stringArray[i]);
                if (n2 < 0) {
                    return false;
                }
                if (this.validateGloss(featureStructureGloss.getChild(n2), featureStructureGloss2.getChild(i + n))) continue;
                return false;
            }
            return this.validateMidGloss(featureStructureGloss, featureStructureGloss2, stringArray.length);
        }
        if (gloss2 instanceof TokenClassGloss) {
            if (gloss.getType() != gloss2.getType()) {
                return false;
            }
            TokenClassGloss tokenClassGloss = (TokenClassGloss)gloss;
            TokenClassGloss tokenClassGloss2 = (TokenClassGloss)gloss2;
            if (tokenClassGloss2.getMatchEnd(0, 16384) != tokenClassGloss.getMatchEnd(0, 16384)) {
                return false;
            }
            if (tokenClassGloss2.getBestClass() > tokenClassGloss.getBestClass()) {
                return false;
            }
            for (int i = 1; i != 0; i <<= 1) {
                if (!tokenClassGloss2.is(i) || tokenClassGloss.is(i)) continue;
                return false;
            }
            return tokenClassGloss2.getPostGloss() == null || this.validateGloss(tokenClassGloss.getPostGloss(), tokenClassGloss2.getPostGloss().first());
        }
        if (gloss2 instanceof Annotate) {
            if (!(gloss instanceof Annotate)) {
                return false;
            }
            if (!this.sameAnnoTypes(gloss2, gloss)) {
                return false;
            }
        }
        if (gloss2 instanceof MidGloss && gloss instanceof MidGloss) {
            return this.validateMidGloss((MidGloss)gloss, (MidGloss)gloss2, 0);
        }
        if (gloss2 instanceof MidGloss) {
            return false;
        }
        if (gloss instanceof MidGloss) {
            gloss = ((MidGloss)gloss).getGloss(gloss2.getClass());
        }
        if (gloss2 instanceof FeatureSetGloss && gloss instanceof FeatureSetGloss) {
            FeatureSetGloss featureSetGloss = (FeatureSetGloss)gloss;
            FeatureSetGloss featureSetGloss2 = (FeatureSetGloss)gloss2;
            return (featureSetGloss.getBOFA() & featureSetGloss2.getBOFA()) != 0;
        }
        return gloss2.equals(gloss);
    }

    private boolean sameAnnoTypes(Gloss gloss, Gloss gloss2) {
        String string = gloss.toString();
        String string2 = gloss2.toString();
        string = string.substring(0, string.indexOf(40));
        string2 = string2.substring(0, string2.indexOf(40));
        return string.equals(string2);
    }

    boolean validateGloss(GlossCollection glossCollection) throws DLTException {
        for (Gloss gloss : glossCollection) {
            if (!this.validateGloss(gloss, this.gloss_filter)) continue;
            return true;
        }
        return false;
    }

    boolean validateGloss(GlossCollection glossCollection, Gloss gloss) throws DLTException {
        for (Gloss gloss2 : glossCollection) {
            if (!this.validateGloss(gloss2, gloss)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonDeterministicBuildNode getNode(Object object) throws DLTException {
        int n = this.char_map.getMaxIndex();
        this.merge_data = this.char_map.combineMaps(this.dict.getCharacterMap(), this.dict.isStaged());
        assert (n == this.char_map.getMaxIndex());
        assert (this.merge_data.destDuplications == null);
        return new DictionaryMapping(this.net.first_base(), NonDeterministicNodeAdapter.nonDeterministicNode(this.builder.net, object));
    }

    public String toString() {
        return "@" + this.gloss_filter;
    }

    class MultiMappedMergerNode
    implements Merger.MergerNode {
        final int node;

        MultiMappedMergerNode(int n) {
            this.node = n;
        }

        @Override
        public boolean startCopy() throws DLTException {
            return true;
        }

        @Override
        public int[] gatherLinks() {
            int[] nArray = DictInserter.this.net.gatherNodeLinks(this.node);
            IntArray intArray = new IntArray(nArray.length);
            for (int n : nArray) {
                intArray.addAll(DictInserter.this.merge_data.sourceToDest[n]);
            }
            int[] nArray2 = intArray.toArray();
            Arrays.sort(nArray2);
            return nArray2;
        }

        @Override
        public boolean transitionPresent(int n) {
            if ((n = DictInserter.this.merge_data.destToSource.get(n)) == 3) {
                try {
                    GlossCollection glossCollection = (GlossCollection)DictInserter.this.net.getPayload(this.node, n, null);
                    return glossCollection != null && DictInserter.this.validateGloss(glossCollection);
                }
                catch (DLTException dLTException) {
                    throw new IllegalArgumentException(dLTException);
                }
            }
            return DictInserter.this.net.transitionPresent(this.node, n);
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            if (DictInserter.this.net.transitionPresent(this.node, n = DictInserter.this.merge_data.destToSource.get(n)) && DictInserter.this.validateGloss((GlossCollection)DictInserter.this.net.getPayload(this.node, n, null))) {
                return DictInserter.this.final_val;
            }
            return null;
        }

        @Override
        public Merger.MergerNode getTransition(int n) {
            n = DictInserter.this.merge_data.destToSource.get(n);
            return new MultiMappedMergerNode(DictInserter.this.net.transitionValue(this.node, n));
        }

        @Override
        public void finalizeCopy() {
        }

        @Override
        public int hashCode() {
            return this.node;
        }

        @Override
        public boolean equals(Object object) {
            return this.node == ((MultiMappedMergerNode)object).node;
        }

        public String toString() {
            return Integer.toString(this.node);
        }
    }

    class DictionaryMapping
    implements NonDeterministicBuildNode {
        final int node;
        NonDeterministicBuildNode trail;
        int index;
        int subindex;
        DictionaryMapping cur_child;
        IntArray cur_set;
        int[] links;

        public DictionaryMapping(int n, NonDeterministicBuildNode nonDeterministicBuildNode) {
            this.node = n;
            this.trail = nonDeterministicBuildNode;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.index = -1;
            GlossCollection glossCollection = (GlossCollection)DictInserter.this.net.getPayload(this.node, 3, null);
            return glossCollection != null && DictInserter.this.validateGloss(glossCollection);
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            ++this.index;
            return this.index == 0 ? this.trail : null;
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.links = DictInserter.this.net.gatherNodeLinks(this.node);
            this.index = -1;
            this.cur_set = null;
            this.subindex = -1;
        }

        @Override
        public Object getChild() throws DLTException {
            return this.cur_child;
        }

        @Override
        public int getIndex() {
            return this.cur_set.get(this.subindex);
        }

        @Override
        public boolean nextTransition() {
            ++this.subindex;
            while (this.cur_set == null || this.subindex >= this.cur_set.size()) {
                ++this.index;
                if (this.index >= this.links.length) {
                    return false;
                }
                this.cur_set = DictInserter.this.merge_data.sourceToDest[this.links[this.index]];
                this.cur_child = new DictionaryMapping(DictInserter.this.net.transitionValue(this.node, this.links[this.index]), this.trail);
                this.subindex = 0;
            }
            return true;
        }

        @Override
        public void endEnumeration() {
            this.cur_set = null;
            this.cur_child = null;
            this.links = null;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.node;
            n = 31 * n + (this.trail == null ? 0 : this.trail.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DictionaryMapping dictionaryMapping = (DictionaryMapping)object;
            if (!this.getOuterType().equals(dictionaryMapping.getOuterType())) {
                return false;
            }
            if (this.node != dictionaryMapping.node) {
                return false;
            }
            return !(this.trail == null ? dictionaryMapping.trail != null : !this.trail.equals(dictionaryMapping.trail));
        }

        private DictInserter getOuterType() {
            return DictInserter.this;
        }

        public String toString() {
            return DictInserter.this.toString() + this.trail;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }
    }
}

