/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.DecompositionTerm;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.RegExBuilder;
import java.util.List;

public class FSAConjunction {
    final RegExBuilder.RegExElement right;
    final NetGenericFullAccess net;
    final List<DecompositionTerm> terms;
    final RegExBuilder dbuilder;
    int initial_atom_count;
    NonDeterministicBuildNode trailNode;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public FSAConjunction(RegExBuilder regExBuilder, NetGeneric netGeneric, List<DecompositionTerm> list, RegExBuilder.RegExElement regExElement) {
        this.right = regExElement;
        this.dbuilder = regExBuilder;
        this.terms = list;
        this.net = (NetGenericFullAccess)netGeneric;
    }

    public void apply() throws DLTException {
        int n = this.dbuilder.buildRegEx(this.right, 3, 0);
        this.net.getReferences().addReference(-1, n);
        this.initial_atom_count = this.terms.size();
        ConjunctionNode conjunctionNode = new ConjunctionNode(this.net.first_base(), n);
        this.net.transformBranch(NetGeneric.IndexIterator.Root, NonDeterministicNodeAdapter.createAdapter(conjunctionNode, this.net));
        this.net.getReferences().removeReference(-1, n);
    }

    class ConjunctionNode
    implements NonDeterministicBuildNode {
        final int lnode;
        final int rnode;
        int lpos;
        int rpos;
        int cur_index;

        public ConjunctionNode(int n, int n2) {
            this.lnode = n;
            this.rnode = n2;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            this.lpos = -1;
            this.rpos = -1;
            while (this.nextTransition()) {
            }
            FSAConjunction.this.net.setMaxIndex(FSAConjunction.this.terms.size() + 4);
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.lpos = -2;
            this.rpos = -1;
            this.cur_index = -1;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            return false;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            return null;
        }

        @Override
        public boolean nextTransition() {
            if (this.lpos == -2) {
                ++this.lpos;
                if (FSAConjunction.this.net.transitionPresent(this.lnode, 3) && FSAConjunction.this.net.transitionPresent(this.rnode, 3)) {
                    this.cur_index = 3;
                    return true;
                }
            }
            if (this.lpos == -1) {
                while (++this.lpos < FSAConjunction.this.initial_atom_count && !FSAConjunction.this.net.transitionPresent(this.lnode, this.lpos + 4)) {
                }
                this.rpos = -1;
            }
            while (this.lpos < FSAConjunction.this.initial_atom_count) {
                while (++this.rpos < FSAConjunction.this.initial_atom_count) {
                    DecompositionTerm decompositionTerm;
                    if (!FSAConjunction.this.net.transitionPresent(this.rnode, this.rpos + 4) || (decompositionTerm = DecompositionTerm.createConjunction(FSAConjunction.this.terms.get(this.lpos), FSAConjunction.this.terms.get(this.rpos))) == null) continue;
                    int n = FSAConjunction.this.terms.indexOf(decompositionTerm);
                    if (n == -1) {
                        n = FSAConjunction.this.terms.size();
                        FSAConjunction.this.terms.add(decompositionTerm);
                    }
                    this.cur_index = n + 4;
                    return true;
                }
                while (++this.lpos < FSAConjunction.this.initial_atom_count && !FSAConjunction.this.net.transitionPresent(this.lnode, this.lpos + 4)) {
                }
                this.rpos = -1;
            }
            return false;
        }

        @Override
        public Object getChild() throws DLTException {
            if (this.lpos == -1) {
                return FSAConjunction.this.net.transitionValue(this.lnode, 3);
            }
            return new ConjunctionNode(FSAConjunction.this.net.transitionValue(this.lnode, this.lpos + 4), FSAConjunction.this.net.transitionValue(this.rnode, this.rpos + 4));
        }

        @Override
        public int getIndex() {
            return this.cur_index;
        }

        @Override
        public void endEnumeration() {
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.lnode;
            n = 31 * n + this.rnode;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ConjunctionNode conjunctionNode = (ConjunctionNode)object;
            if (!this.getOuterType().equals(conjunctionNode.getOuterType())) {
                return false;
            }
            if (this.lnode != conjunctionNode.lnode) {
                return false;
            }
            return this.rnode == conjunctionNode.rnode;
        }

        private FSAConjunction getOuterType() {
            return FSAConjunction.this;
        }
    }
}

