/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericImpl;

class InPlaceIntersector
extends BuildEngine
implements NetGeneric.ChangeEncapsulator {
    int rroot;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    InPlaceIntersector(NetGenericImpl netGenericImpl, int n) {
        super(netGenericImpl);
        this.rroot = n;
    }

    void reset(int n) {
        this.rroot = n;
    }

    @Override
    public int Apply(int n) throws DLTException {
        if (n == this.rroot) {
            return this.rroot;
        }
        if (n == -1 || this.rroot == -1) {
            return n;
        }
        int n2 = this.buildAndIntegrate(new IntersectNode(n, this.rroot));
        return n2;
    }

    public int intersectBranches(int n, int n2) throws DLTException {
        this.reset(n2);
        return this.Apply(n);
    }

    class IntersectNode
    extends BuildNodeBase {
        int left;
        int right;

        public IntersectNode(int n, int n2) throws DLTException {
            this.left = n;
            this.right = n2;
        }

        @Override
        public String toString() {
            return "<" + this.left + ',' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            int n2 = InPlaceIntersector.this.net.takeTransition(this.left, n, -1);
            int n3 = InPlaceIntersector.this.net.takeTransition(this.right, n, -1);
            if (n2 == -1 || n3 == -1) {
                return IntersectNode.makeAssignedNode(-1);
            }
            if (n2 == n3) {
                return IntersectNode.makeAssignedNode(n3);
            }
            if (n < InPlaceIntersector.this.net.getFirstLinkIndex()) {
                return IntersectNode.makeAssignedNode(InPlaceIntersector.this.net.getPayloadManipulator(n).intersectInternal(n2, n3));
            }
            return new IntersectNode(n2, n3);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth;
            int n2 = InPlaceIntersector.this.net.getMaxIndex();
            do {
                if (++n != n2) continue;
                return false;
            } while (!InPlaceIntersector.this.net.transitionPresent(this.left, n) || !InPlaceIntersector.this.net.transitionPresent(this.right, n));
            this.depth = n;
            return true;
        }

        @Override
        public void startEnumeration() {
            this.depth = 0;
        }

        public int hashCode() {
            return 31 * this.right + this.left;
        }

        public boolean equals(Object object) {
            IntersectNode intersectNode = (IntersectNode)object;
            return this.left == intersectNode.left && this.right == intersectNode.right;
        }
    }
}

