/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericImpl;

class InPlaceMerger
extends BuildEngine
implements NetGeneric.ChangeEncapsulator {
    int rroot;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    InPlaceMerger(NetGenericImpl netGenericImpl, int n) {
        super(netGenericImpl);
        this.rroot = n;
    }

    void reset(int n) {
        this.rroot = n;
    }

    @Override
    public int Apply(int n) throws DLTException {
        if (n == -1 || n == this.rroot) {
            return this.rroot;
        }
        if (this.rroot == -1) {
            return n;
        }
        int n2 = this.buildAndIntegrate(new MergeNode(n, this.rroot));
        return n2;
    }

    public int mergeBranches(int n, int n2) throws DLTException {
        this.reset(n2);
        return this.Apply(n);
    }

    class MergeNode
    extends BuildNodeBase {
        int left;
        int right;

        public MergeNode(int n, int n2) throws DLTException {
            this.left = n;
            this.right = n2;
        }

        @Override
        public String toString() {
            return "<" + this.left + ',' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            int n2 = InPlaceMerger.this.net.takeTransition(this.left, n, -1);
            int n3 = InPlaceMerger.this.net.takeTransition(this.right, n, n2);
            if (n2 == -1 || n2 == n3) {
                return MergeNode.makeAssignedNode(n3);
            }
            if (n < InPlaceMerger.this.net.getFirstLinkIndex()) {
                return MergeNode.makeAssignedNode(InPlaceMerger.this.net.getPayloadManipulator(n).mergeInternal(n2, n3));
            }
            return new MergeNode(n2, n3);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth;
            int n2 = InPlaceMerger.this.net.getMaxIndex();
            do {
                if (++n != n2) continue;
                return false;
            } while (!InPlaceMerger.this.net.transitionPresent(this.left, n) && !InPlaceMerger.this.net.transitionPresent(this.right, n));
            this.depth = n;
            return true;
        }

        @Override
        public void startEnumeration() {
            this.depth = 0;
        }

        public int hashCode() {
            return 31 * this.right + this.left;
        }

        public boolean equals(Object object) {
            MergeNode mergeNode = (MergeNode)object;
            return this.left == mergeNode.left && this.right == mergeNode.right;
        }
    }
}

