/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericImpl;

class InPlaceSubtractor
extends BuildEngine
implements NetGeneric.ChangeEncapsulator {
    int rroot;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    InPlaceSubtractor(NetGenericImpl netGenericImpl, int n) {
        super(netGenericImpl);
        this.rroot = n;
    }

    void reset(int n) {
        this.rroot = n;
    }

    @Override
    public int Apply(int n) throws DLTException {
        if (n == -1 || n == this.rroot) {
            return -1;
        }
        if (this.rroot == -1) {
            return n;
        }
        int n2 = this.buildAndIntegrate(new SubtractNode(n, this.rroot));
        return n2;
    }

    public int subtractBranches(int n, int n2) throws DLTException {
        this.reset(n2);
        return this.Apply(n);
    }

    class SubtractNode
    extends BuildNodeBase {
        int left;
        int right;

        public SubtractNode(int n, int n2) throws DLTException {
            this.left = n;
            this.right = n2;
        }

        @Override
        public String toString() {
            return "<" + this.left + ',' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            int n2 = InPlaceSubtractor.this.net.takeTransition(this.left, n, -1);
            int n3 = InPlaceSubtractor.this.net.takeTransition(this.right, n, -1);
            if (n3 == -1) {
                return SubtractNode.makeAssignedNode(n2);
            }
            if (n2 == -1 || n2 == n3) {
                return SubtractNode.makeAssignedNode(-1);
            }
            if (n < InPlaceSubtractor.this.net.getFirstLinkIndex()) {
                return SubtractNode.makeAssignedNode(InPlaceSubtractor.this.net.getPayloadManipulator(n).subtractInternal(n2, n3));
            }
            return new SubtractNode(n2, n3);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth;
            int n2 = InPlaceSubtractor.this.net.getMaxIndex();
            do {
                if (++n != n2) continue;
                return false;
            } while (!InPlaceSubtractor.this.net.transitionPresent(this.left, n));
            this.depth = n;
            return true;
        }

        @Override
        public void startEnumeration() {
            this.depth = 0;
        }

        public int hashCode() {
            return 31 * this.right + this.left;
        }

        public boolean equals(Object object) {
            SubtractNode subtractNode = (SubtractNode)object;
            return this.left == subtractNode.left && this.right == subtractNode.right;
        }
    }
}

