/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGenericImpl;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.SetIndexManipulable;

public class LoopMaker
extends BuildEngine {
    final SetIndexManipulable loop_nests;
    int loop_base;
    int loop_id;
    long last_printout_time;

    private LoopMaker(NetGenericImpl netGenericImpl, SetIndexManipulable setIndexManipulable) {
        super(netGenericImpl);
        this.loop_nests = setIndexManipulable;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    LoopMaker(NetGenericImpl netGenericImpl) {
        this(netGenericImpl, new SetIndexManipulable());
    }

    PayloadManipulator getPayloadManipulator() {
        return this.loop_nests;
    }

    int allocateLoopNest(int n) {
        return this.loop_nests.add(SetIndexManipulable.EMPTYSET, n);
    }

    int attachLoopEnds(int n, int n2) throws DLTException {
        this.loop_base = n;
        this.loop_id = n2;
        int n3 = this.buildAndIntegrate(new LoopMakeNode(n));
        return n3;
    }

    int attachTrail(int n, int n2, int n3) throws DLTException {
        this.loop_base = n2;
        this.loop_id = n3;
        int n4 = this.buildAndIntegrate(new LoopMakeNode(n));
        return n4;
    }

    class LoopMakeNode
    extends BuildNodeBase {
        final IntArray nodes;

        public LoopMakeNode(int n) throws DLTException {
            if (LoopMaker.this.net.transitionPresent(n, 1) && LoopMaker.this.loop_nests.contains(LoopMaker.this.net.transitionValue(n, 1), LoopMaker.this.loop_id)) {
                this.nodes = new IntArray(2);
                this.nodes.add(n);
                this.nodes.add(LoopMaker.this.loop_base);
            } else {
                this.nodes = new IntArray(1);
                this.nodes.add(n);
            }
        }

        private boolean hasTransition(int n) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!LoopMaker.this.net.transitionPresent(this.nodes.get(i), n)) continue;
                return true;
            }
            return false;
        }

        private LoopMakeNode(IntArray intArray) {
            this.nodes = intArray;
            for (int i = 0; i < intArray.size(); ++i) {
                if (!LoopMaker.this.net.transitionPresent(intArray.get(i), 1) || !LoopMaker.this.loop_nests.contains(LoopMaker.this.net.transitionValue(intArray.get(i), 1), LoopMaker.this.loop_id)) continue;
                intArray.add(LoopMaker.this.loop_base);
                break;
            }
            intArray.removeDuplicates();
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            if (n < LoopMaker.this.net.getFirstLinkIndex()) {
                int n2 = -1;
                for (int i = 0; i < this.nodes.size(); ++i) {
                    int n3 = this.nodes.get(i);
                    if (!LoopMaker.this.net.transitionPresent(n3, n)) continue;
                    n2 = LoopMaker.this.net.getPayloadManipulator(n).mergeInternal(n2, LoopMaker.this.net.transitionValue(n3, n));
                }
                if (n == 1) {
                    n2 = LoopMaker.this.loop_nests.remove(n2, LoopMaker.this.loop_id);
                }
                return LoopMakeNode.makeAssignedNode(n2);
            }
            IntArray intArray = new IntArray(this.nodes.size() + 1);
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!LoopMaker.this.net.transitionPresent(this.nodes.get(i), n)) continue;
                intArray.add(LoopMaker.this.net.transitionValue(this.nodes.get(i), n));
            }
            return new LoopMakeNode(intArray);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth;
            int n2 = LoopMaker.this.net.getMaxIndex();
            do {
                if (++n != n2) continue;
                return false;
            } while (!this.hasTransition(n));
            this.depth = n;
            return true;
        }

        @Override
        public void startEnumeration() {
            this.depth = 0;
        }

        @Override
        public String toString() {
            return "<" + this.nodes + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }

        public int hashCode() {
            return this.nodes.hashCode();
        }

        public boolean equals(Object object) {
            LoopMakeNode loopMakeNode = (LoopMakeNode)object;
            return this.nodes.equals(loopMakeNode.nodes);
        }
    }
}

