/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.NodeAllocator;
import com.ibm.dltj.util.Utils;

class LoopReferenceCounter
implements NodeAllocator {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    public static final int REFERRER_NONE = -1;
    public static final int BASE_EMPTY = -1;
    final ObjectInterface caller;
    private static final int REF_ALLOCATED = -1;
    private static final int REF_FREE = 0;
    int[] ref;
    int[] shared_ref;
    int shared_free_index;

    public LoopReferenceCounter(ObjectInterface objectInterface) {
        this.caller = objectInterface;
        this.reset();
    }

    public void reset() {
        this.ref = null;
        this.shared_ref = null;
        this.shared_free_index = -1;
    }

    public void initialize(int n) {
        this.ref = new int[n];
        this.shared_ref = new int[16];
        this.shared_free_index = 1;
    }

    public boolean initialized() {
        return this.ref != null;
    }

    public void updateIndexLimit(int n) {
        if (this.ref != null) {
            this.ref = Utils.assureIntArrayRoom(this.ref, n, 1, 1);
        }
    }

    int allocateSelfRef() {
        int n;
        for (n = this.shared_free_index; n < this.shared_ref.length && this.shared_ref[n] < 0; ++n) {
        }
        this.shared_ref = Utils.assureIntArrayRoom(this.shared_ref, n, 2, 1);
        this.shared_ref[n] = -1;
        this.shared_free_index = n + 1;
        return n;
    }

    @Override
    public int allocate(int n) {
        assert (!this.allocated(n));
        this.ref[n] = -1;
        return n;
    }

    @Override
    public int deallocate(int n) {
        assert (this.ref[n] == -1);
        this.ref[n] = 0;
        return n;
    }

    public int addReference(int n, int n2) {
        assert (this.allocated(n2));
        if (this.selfReferenced(n2)) {
            if (n == -1 || this.ref[n2] != this.ref[n]) {
                int n3 = this.ref[n2];
                this.shared_ref[n3] = this.shared_ref[n3] - 1;
            }
        } else {
            int n4 = n2;
            this.ref[n4] = this.ref[n4] - 1;
        }
        return n2;
    }

    public int createSelfReference(int n, int n2) {
        assert (this.allocated(n2));
        assert (this.allocated(n));
        if (!this.selfReferenced(n2)) {
            this.ref[n2] = this.allocateSelfRef();
        }
        assert (!this.selfReferenced(n) || this.ref[n] == this.ref[n2]);
        assert (this.selfReferenced(n) || !this.referenced(n) || n == n2);
        this.ref[n] = this.ref[n2];
        return n2;
    }

    public int removeReference(int n, int n2) {
        if (!this.allocated(n2)) {
            return n2;
        }
        if (this.selfReferenced(n2)) {
            int n3 = this.ref[n2];
            if (this.shared_ref[n3] == 0) {
                this.ref[n2] = 0;
                this.caller.deleteNode(n2);
                return n2;
            }
            if (n != -1 && this.ref[n] == n3) {
                return n2;
            }
            assert (this.shared_ref[n3] < -1);
            int n4 = n3;
            this.shared_ref[n4] = this.shared_ref[n4] + 1;
            if (this.shared_ref[n4] == -1) {
                this.ref[n2] = 0;
                this.shared_ref[n3] = 0;
                this.caller.deleteNode(n2);
                this.shared_free_index = Math.min(this.shared_free_index, n3);
            }
        } else {
            int n5 = n2;
            this.ref[n5] = this.ref[n5] + 1;
            if (this.ref[n5] == -1) {
                this.caller.deleteNode(n2);
                this.ref[n2] = 0;
            }
        }
        return n2;
    }

    public int removeReferenceKeeping(int n, int n2, int n3) {
        if (n2 != n3) {
            this.removeReference(n, n2);
            return n2;
        }
        if (this.selfReferenced(n2)) {
            int n4 = this.ref[n2];
            if (n != -1 && this.ref[n] == n4) {
                return n2;
            }
            int n5 = n4;
            this.shared_ref[n5] = this.shared_ref[n5] + 1;
        } else {
            int n6 = n2;
            this.ref[n6] = this.ref[n6] + 1;
        }
        return n2;
    }

    public void moveReferences(int n, int n2) {
        assert (this.allocated(n2));
        assert (this.allocated(n));
        if (this.ref[n2] > 0) {
            assert (this.ref[n] == this.ref[n2]);
        } else if (this.ref[n] > 0) {
            this.ref[n2] = this.ref[n];
        } else {
            int n3 = n2;
            this.ref[n3] = this.ref[n3] + (this.ref[n] - -1);
        }
        this.ref[n] = 0;
    }

    @Override
    public boolean allocated(int n) {
        return this.ref[n] != 0;
    }

    public boolean referenced(int n) {
        return this.ref[n] != 0 && this.ref[n] != -1;
    }

    public boolean singlyReferenced(int n) {
        return this.ref[n] == -2;
    }

    public boolean selfReferenced(int n) {
        return this.ref[n] > 0;
    }

    public boolean sameSelfReference(int n, int n2) {
        return this.ref[n2] > 0 && this.ref[n] == this.ref[n2];
    }

    public boolean selfReferencedM1(int n) {
        return n == -1 || this.ref[n] > 0;
    }

    public boolean sameSelfReferenceM1(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n == -1 || n2 == -1) {
            return false;
        }
        return this.ref[n2] > 0 && this.ref[n] == this.ref[n2];
    }

    public boolean hasSelfReferences() {
        assert (this.initialized());
        for (int n : this.shared_ref) {
            if (n >= 0) continue;
            return true;
        }
        return false;
    }

    public String dump(int n) {
        if (!this.allocated(n)) {
            return "-";
        }
        if (!this.selfReferenced(n)) {
            return "" + (-1 - this.ref[n]);
        }
        return "" + (-1 - this.shared_ref[this.ref[n]]) + "(" + this.ref[n] + ")";
    }

    public boolean verifyCount(int n, int n2) {
        int n3 = this.ref[n];
        if (n3 <= -1) {
            ++n3;
        }
        if (n3 > 0) {
            n3 = this.shared_ref[n3] - -1;
        }
        return n2 == -n3;
    }

    public String dumpVerify(int n, int n2) {
        if (!this.allocated(n)) {
            return "*** not allocated ***";
        }
        if (!this.referenced(n)) {
            return "*";
        }
        int n3 = this.ref[n];
        if (n3 > 0) {
            n3 = this.shared_ref[n3];
        }
        return n2 == -1 - n3 ? "" : "*** refcount mismatch, " + n2 + " ***";
    }

    public boolean equals(LoopReferenceCounter loopReferenceCounter) {
        int n;
        int n2 = this.ref.length;
        if (loopReferenceCounter.ref.length != this.ref.length) {
            n2 = Math.min(this.ref.length, loopReferenceCounter.ref.length);
            int n3 = Math.max(this.ref.length, loopReferenceCounter.ref.length);
            for (n = n2; n < n3; ++n) {
                if (this.ref.length > n && this.allocated(n)) {
                    return false;
                }
                if (loopReferenceCounter.ref.length <= n || !loopReferenceCounter.allocated(n)) continue;
                return false;
            }
        }
        int[] nArray = new int[this.shared_ref.length];
        for (n = 0; n < n2; ++n) {
            if (this.selfReferenced(n)) {
                if (!loopReferenceCounter.selfReferenced(n)) {
                    return false;
                }
                if (nArray[this.ref[n]] == 0) {
                    nArray[this.ref[n]] = loopReferenceCounter.ref[n];
                    if (this.shared_ref[this.ref[n]] == loopReferenceCounter.shared_ref[loopReferenceCounter.ref[n]]) continue;
                    return false;
                }
                if (loopReferenceCounter.ref[n] == nArray[this.ref[n]]) continue;
                return false;
            }
            if (this.ref[n] == loopReferenceCounter.ref[n]) continue;
            return false;
        }
        return true;
    }

    static interface ObjectInterface {
        public void deleteNode(int var1);
    }
}

