/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.MergerNodeAdapter;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericImpl;

public class Merger
extends BuildEngine
implements NetGeneric.ChangeEncapsulator {
    MergerNode rroot;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    Merger(NetGenericImpl netGenericImpl, MergerNode mergerNode) {
        super(netGenericImpl);
        this.rroot = mergerNode;
    }

    void reset(MergerNode mergerNode) {
        this.rroot = mergerNode;
    }

    @Override
    public int Apply(int n) throws DLTException {
        if (this.rroot == null) {
            return n;
        }
        BuildNodeBase buildNodeBase = n == -1 ? new MergerNodeAdapter(this.rroot, this.net) : new NetAndMergerNode(n, this.rroot);
        int n2 = this.buildAndIntegrate(buildNodeBase);
        return n2;
    }

    class NetAndMergerNode
    extends BuildNodeBase {
        int left;
        MergerNode right;

        public NetAndMergerNode(int n, MergerNode mergerNode) {
            this.left = n;
            this.right = mergerNode;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            this.right.startCopy();
        }

        @Override
        public void startEnumeration() {
            this.depth = 0;
        }

        @Override
        public void endEnumeration() {
            super.endEnumeration();
            this.right.finalizeCopy();
        }

        @Override
        public BuildNode getChild() throws DLTException {
            int n = this.depth;
            int n2 = Merger.this.net.takeTransition(this.left, n, -1);
            if (!this.right.transitionPresent(n)) {
                return NetAndMergerNode.makeAssignedNode(n2);
            }
            if (n < Merger.this.net.getFirstLinkIndex()) {
                return NetAndMergerNode.makeAssignedNode(Merger.this.net.getPayloadManipulator(n).merge(n2, this.right.transitionValue(n)));
            }
            return new NetAndMergerNode(n2, this.right.getTransition(n));
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = Merger.this.net.getMaxIndex();
            for (int i = this.depth + 1; i < n; ++i) {
                if (!Merger.this.net.transitionPresent(this.left, i) && !this.right.transitionPresent(i)) continue;
                this.depth = i;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * ((Object)this.right).hashCode() + this.left;
        }

        public boolean equals(Object object) {
            NetAndMergerNode netAndMergerNode = (NetAndMergerNode)object;
            return this.left == netAndMergerNode.left && ((Object)this.right).equals(netAndMergerNode.right);
        }

        @Override
        public String toString() {
            return "<" + this.left + ',' + this.right + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }
    }

    public static interface MergerNode {
        public boolean startCopy() throws DLTException;

        public int[] gatherLinks();

        public boolean transitionPresent(int var1);

        public Object transitionValue(int var1) throws DLTException;

        public MergerNode getTransition(int var1) throws DLTException;

        public void finalizeCopy();

        public int hashCode();

        public boolean equals(Object var1);

        public static class UnchangedNode
        implements MergerNode {
            protected final NetGeneric net;
            protected int node;

            public UnchangedNode(NetGeneric netGeneric, int n) {
                this.net = netGeneric;
                this.node = n;
            }

            @Override
            public boolean startCopy() throws DLTException {
                return true;
            }

            @Override
            public int[] gatherLinks() {
                return this.net.gatherNodeLinks(this.node);
            }

            @Override
            public boolean transitionPresent(int n) {
                return this.net.transitionPresent(this.node, n);
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                return this.net.getPayload(this.node, n, null);
            }

            @Override
            public MergerNode getTransition(int n) {
                return new UnchangedNode(this.net, this.net.transitionValue(this.node, n));
            }

            @Override
            public void finalizeCopy() {
            }

            @Override
            public int hashCode() {
                int n = 1;
                n = 31 * n + this.node;
                return n;
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                UnchangedNode unchangedNode = (UnchangedNode)object;
                return this.node == unchangedNode.node;
            }
        }
    }
}

