/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.IntArray;

class MergerNodeAdapter
extends BuildNodeBase {
    final NetGeneric net;
    final Merger.MergerNode node;
    IntArray links;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MergerNodeAdapter(Merger.MergerNode mergerNode, NetGeneric netGeneric) {
        this.node = mergerNode;
        this.net = netGeneric;
    }

    @Override
    public void updateMaxIndex() throws DLTException {
        this.node.startCopy();
    }

    @Override
    public void startEnumeration() throws DLTException {
        this.links = new IntArray();
        int n = this.net.getFirstLinkIndex();
        for (int i = 1; i < n; ++i) {
            if (!this.node.transitionPresent(i)) continue;
            this.links.add(i);
        }
        int[] nArray = this.node.gatherLinks();
        this.links.addAll(nArray);
        this.depth = -1;
    }

    @Override
    public void endEnumeration() {
        super.endEnumeration();
        this.node.finalizeCopy();
    }

    @Override
    public BuildNode getChild() throws DLTException {
        int n = this.links.get(this.depth);
        if (n < this.net.getFirstLinkIndex()) {
            return MergerNodeAdapter.makeAssignedNode(this.net.getPayloadManipulator(n).merge(-1, this.node.transitionValue(n)));
        }
        return new MergerNodeAdapter(this.node.getTransition(n), this.net);
    }

    @Override
    public int getIndex() {
        return this.links.get(this.depth);
    }

    @Override
    public boolean nextTransition() {
        return ++this.depth < this.links.size();
    }

    public int hashCode() {
        return ((Object)this.node).hashCode();
    }

    public boolean equals(Object object) {
        MergerNodeAdapter mergerNodeAdapter = (MergerNodeAdapter)object;
        return ((Object)this.node).equals(mergerNodeAdapter.node);
    }

    @Override
    public String toString() {
        return "<" + this.node + '>' + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
    }
}

