/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.LoopReferenceCounter;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class MinimizationVerifier {
    final NetGenericFullAccess net;
    final Map<Integer, MinimizerNode> minimizerList = new HashMap<Integer, MinimizerNode>();
    final int fli;
    final int mi;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private MinimizationVerifier(NetGeneric netGeneric) {
        this.net = (NetGenericFullAccess)netGeneric;
        this.fli = netGeneric.getFirstLinkIndex();
        this.mi = netGeneric.getMaxIndex();
    }

    private void separateClasses() {
        HashMap<MinimizerNode, MinimizerNode> hashMap = new HashMap<MinimizerNode, MinimizerNode>();
        while (true) {
            boolean bl = false;
            for (MinimizerNode minimizerNode : this.minimizerList.values()) {
                MinimizerNode minimizerNode2 = (MinimizerNode)hashMap.get(minimizerNode);
                if (minimizerNode2 == null) {
                    hashMap.put(minimizerNode, minimizerNode);
                    minimizerNode2 = minimizerNode;
                }
                minimizerNode.new_class_node = minimizerNode2.node;
                bl = bl || minimizerNode.new_class_node != minimizerNode.class_node;
            }
            if (!bl) {
                return;
            }
            for (MinimizerNode minimizerNode : this.minimizerList.values()) {
                minimizerNode.class_node = minimizerNode.new_class_node;
            }
            hashMap.clear();
        }
    }

    private boolean verifyMinimal() {
        LoopReferenceCounter loopReferenceCounter = this.net.getReferences();
        if (!loopReferenceCounter.initialized()) {
            return true;
        }
        this.minimizerList.put(-1, new MinimizerNode(-1));
        try {
            this.net.forEachNode(new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) throws DLTException {
                    MinimizationVerifier.this.minimizerList.put(n, new MinimizerNode(n));
                    return 0;
                }
            });
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
            return false;
        }
        int n = -1;
        for (MinimizerNode object : this.minimizerList.values()) {
            object.class_node = n;
        }
        this.separateClasses();
        boolean bl = true;
        for (MinimizerNode minimizerNode : this.minimizerList.values()) {
            if (minimizerNode.node == minimizerNode.class_node) continue;
            System.err.format("Node %d is equivalent to node %d.\n", minimizerNode.node, minimizerNode.class_node);
            bl = false;
        }
        return bl;
    }

    public static boolean verifyMinimal(NetGeneric netGeneric) {
        return new MinimizationVerifier(netGeneric).verifyMinimal();
    }

    private class MinimizerNode {
        int node;
        int class_node;
        int new_class_node;

        public MinimizerNode(int n) {
            this.node = n;
        }

        public int hashCode() {
            int n;
            int n2 = 1;
            for (n = 1; n < MinimizationVerifier.this.fli; ++n) {
                n2 = Utils.combineHash(n2, n, MinimizationVerifier.this.net.takeTransition(this.node, n, -1));
            }
            while (n < MinimizationVerifier.this.mi) {
                int n3 = MinimizationVerifier.this.net.takeTransition(this.node, n, -1);
                MinimizerNode minimizerNode = MinimizationVerifier.this.minimizerList.get(n3);
                n3 = minimizerNode.class_node;
                n2 = Utils.combineHash(n2, n, n3);
                ++n;
            }
            return n2;
        }

        public boolean equals(Object object) {
            int n;
            MinimizerNode minimizerNode = (MinimizerNode)object;
            if (this.node == minimizerNode.node) {
                return true;
            }
            for (n = 1; n < MinimizationVerifier.this.fli; ++n) {
                if (MinimizationVerifier.this.net.takeTransition(this.node, n, -1) == MinimizationVerifier.this.net.takeTransition(minimizerNode.node, n, -1)) continue;
                return false;
            }
            while (n < MinimizationVerifier.this.mi) {
                int n2;
                int n3;
                int n4;
                int n5 = MinimizationVerifier.this.net.takeTransition(this.node, n, -1);
                if (n5 != (n4 = MinimizationVerifier.this.net.takeTransition(minimizerNode.node, n, -1)) && (n3 = MinimizationVerifier.this.minimizerList.get((Object)Integer.valueOf((int)n5)).class_node) != (n2 = MinimizationVerifier.this.minimizerList.get((Object)Integer.valueOf((int)n4)).class_node)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            return "" + this.node + '/' + this.class_node;
        }
    }
}

