/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.NodeAllocator;
import com.ibm.dltj.netgeneric.TransitionTable;
import com.ibm.dltj.util.BoundedIntHeap;
import java.io.PrintStream;
import java.util.Arrays;

class NetFitFinder {
    static final int BASE_NO_MATCH = -3;
    static final int BASE_EMPTY = -1;
    static final int VALUE_NOT_PRESENT = -1;
    static final int INDEX_UNMAPPED = 1;
    final NodeAllocator references;
    static final int MAX_LIST_SIZE = 256;
    final BoundedIntHeap deleted;
    final BoundedIntHeap allocated;
    TransitionTable table;
    int max_index;
    private int prev_cell;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    NetFitFinder(NodeAllocator nodeAllocator) {
        this.references = nodeAllocator;
        this.deleted = new BoundedIntHeap(256, 1);
        this.allocated = new BoundedIntHeap(256, 2);
        this.max_index = 0;
    }

    void reset() {
        this.table = null;
        this.deleted.clear();
        this.allocated.clear();
        this.max_index = 0;
    }

    void update(TransitionTable transitionTable, int n) {
        if (this.table != null) {
            int n2 = this.table.getSize();
            this.table = transitionTable;
            this.updateLists(n2);
        }
        this.max_index = n;
    }

    void updateMaxIndex(int n) {
        this.max_index = n;
    }

    void initialize(TransitionTable transitionTable, int n) {
        this.table = transitionTable;
        this.max_index = n;
        assert (this.deleted.isEmpty());
        assert (this.allocated.isEmpty());
        this.updateLists(0);
    }

    private int getLastBase() {
        return this.table.getSize() - this.max_index;
    }

    private boolean transitionPresent(int n, int n2) {
        return this.table.getChar(n + n2) == n2;
    }

    int findFitForCopy(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        assert (n3 != -1 || n4 == -1);
        int n6 = this.max_index;
        int n7 = 0;
        if (n2 != -1) {
            for (int i = 1; i < n6; ++i) {
                if ((n3 != i || n4 == -1) && (n3 == i || !this.transitionPresent(n2, i))) continue;
                ++n7;
            }
        } else if (n3 != -1 && n4 != -1) {
            ++n7;
        }
        int[] nArray = new int[n7];
        n7 = 0;
        if (n2 != -1) {
            for (n5 = 1; n5 < n6; ++n5) {
                if ((n3 != n5 || n4 == -1) && (n3 == n5 || !this.transitionPresent(n2, n5))) continue;
                nArray[n7++] = n5;
            }
        } else if (n3 != -1 && n4 != -1) {
            nArray[n7++] = n3;
        }
        n5 = bl ? n2 - 1 : this.getLastBase();
        return this.findFitForTrans(n, n5, nArray, n7);
    }

    int findFitForMerge(int n, int n2, int n3) {
        int n4 = this.max_index;
        int n5 = 0;
        for (int i = 1; i < n4; ++i) {
            if (!this.transitionPresent(n2, i) && !this.transitionPresent(n3, i)) continue;
            ++n5;
        }
        int[] nArray = new int[n5];
        n5 = 0;
        for (int i = 1; i < n4; ++i) {
            if (!this.transitionPresent(n2, i) && !this.transitionPresent(n3, i)) continue;
            nArray[n5++] = i;
        }
        return this.findFitForTrans(n, this.getLastBase(), nArray, n5);
    }

    int findFitForTrans(int n, int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, n2, nArray2, 0, n4);
        Arrays.sort(nArray2);
        return this.findFitForTrans(n, this.getLastBase(), nArray2, n4);
    }

    int findFitForTransSorted(int n, int[] nArray, int n2) {
        return this.findFitForTrans(n, this.getLastBase(), nArray, n2);
    }

    int findFitForTrans(int n, int n2, int[] nArray, int n3) {
        if (n3 == 0) {
            return -1;
        }
        int n4 = Math.min(this.allocated.getTopKey(), this.deleted.getTopKey());
        int n5 = Math.min(n4 - 1 - nArray[n3 - 1], n2);
        this.prev_cell = 0;
        int n6 = this.findNoLists(n, n5 += nArray[0], nArray, n3);
        if (n6 >= 0) {
            return n6;
        }
        return this.findApplyLists(n, n2, nArray, n3);
    }

    private void updateLists(int n) {
        this.applyLists();
        int n2 = this.prev_cell = n;
        do {
            ++n2;
            while (n2 < this.table.getSize() && this.table.isAssigned(n2)) {
                ++n2;
            }
            this.table.setCell(this.prev_cell, 0, n2);
            this.prev_cell = n2;
        } while (n2 < this.table.getSize());
    }

    private int applyLists(int n) {
        int n2 = this.allocated.getTopKey();
        int n3 = this.deleted.getTopKey();
        while (true) {
            if (n > n3) {
                if (n2 == n3) {
                    assert (this.allocated.getTopValue(1) == 0);
                    while (this.allocated.getTopKey() == n2) {
                        this.allocated.removeTop();
                    }
                    while (this.deleted.getTopKey() == n2) {
                        this.deleted.removeTop();
                    }
                    if (!this.table.isAssigned(n3)) {
                        this.table.setCell(this.prev_cell, 0, n3);
                        this.table.setCell(n3, 0, n);
                        n = n3;
                        break;
                    }
                    n2 = this.allocated.getTopKey();
                    n3 = this.deleted.getTopKey();
                    continue;
                }
                this.table.setCell(this.prev_cell, 0, n3);
                this.table.setCell(n3, 0, n);
                n = n3;
                this.deleted.removeTop();
                break;
            }
            if (n != this.allocated.getTopKey()) break;
            if (n2 == n3) {
                int n4 = 0;
                while (this.allocated.getTopKey() == n2) {
                    if (n4 == 0) {
                        n4 = this.allocated.getTopValue(1);
                    } else assert (this.allocated.getTopValue(1) == 0);
                    this.allocated.removeTop();
                }
                while (this.deleted.getTopKey() == n2) {
                    this.deleted.removeTop();
                }
                if (!this.table.isAssigned(n)) {
                    this.table.setCell(n, 0, n4);
                    break;
                }
                n = n4;
                this.table.setCell(this.prev_cell, 0, n);
                n2 = this.allocated.getTopKey();
                n3 = this.deleted.getTopKey();
                continue;
            }
            n = this.allocated.getTopValue(1);
            this.table.setCell(this.prev_cell, 0, n);
            this.allocated.removeTop();
            n2 = this.allocated.getTopKey();
        }
        return n;
    }

    private void applyLists(int n, int n2) {
        int n3 = this.prev_cell;
        do {
            this.prev_cell = n;
            n = this.table.getLink(n);
        } while ((n = this.applyLists(n)) < n2);
        this.prev_cell = n3;
    }

    private void applyLists() {
        this.prev_cell = 0;
        int n = 0;
        int n2 = Math.min(this.allocated.getTopKey(), this.deleted.getTopKey());
        while (n2 < Integer.MAX_VALUE) {
            while (n < n2) {
                this.prev_cell = n;
                n = this.table.getLink(n);
            }
            n = this.applyLists(n);
            n2 = Math.min(this.allocated.getTopKey(), this.deleted.getTopKey());
        }
    }

    private boolean transFits(int n, int[] nArray, int n2) {
        if (n >= 0 && !this.references.allocated(n)) {
            int n3;
            assert (!this.table.isAssigned(n + nArray[0]));
            for (n3 = 1; n3 < n2 && !this.table.isAssigned(n + nArray[n3]); ++n3) {
            }
            return n3 == n2;
        }
        return false;
    }

    private void allocateNode(int n, int[] nArray, int n2) {
        int n3 = n - nArray[0];
        n = this.table.getLink(n);
        this.table.setCell(this.prev_cell, 0, n);
        int n4 = 1;
        while (n4 < n2) {
            if (n == n3 + nArray[n4]) {
                n = this.table.getLink(n);
                this.table.setCell(this.prev_cell, 0, n);
                ++n4;
                continue;
            }
            assert (n < n3 + nArray[n4]);
            this.prev_cell = n;
            n = this.table.getLink(n);
        }
    }

    private int findNoLists(int n, int n2, int[] nArray, int n3) {
        int n4 = this.table.getLink(this.prev_cell);
        while (n4 <= n2 && !this.transFits(n4 - nArray[0], nArray, n3)) {
            this.prev_cell = n4;
            n4 = this.table.getLink(n4);
        }
        if (n4 > n2) {
            return -3;
        }
        this.allocateNode(n4, nArray, n3);
        return n4 - nArray[0];
    }

    private int findApplyLists(int n, int n2, int[] nArray, int n3) {
        int n4 = this.table.getLink(this.prev_cell);
        int n5 = -3;
        n4 = this.applyLists(n4);
        while (n4 <= n2 && !this.transFits(n5 = n4 - nArray[0], nArray, n3)) {
            this.prev_cell = n4;
            n4 = this.table.getLink(n4);
            n4 = this.applyLists(n4);
        }
        if (n4 > n2) {
            return -3;
        }
        this.applyLists(n4, n5 + nArray[n3 - 1] + 1);
        this.allocateNode(n4, nArray, n3);
        return n5;
    }

    final void freeCell(int n) {
        if (this.deleted.isFull()) {
            this.applyLists();
        }
        this.deleted.allocateCell(n);
    }

    final void grabCell(int n) {
        assert (!this.table.isAssigned(n));
        if (this.allocated.isFull()) {
            this.applyLists();
        }
        int n2 = this.allocated.allocateCell(n);
        this.allocated.setValue(n2, 1, this.table.getLink(n));
    }

    final void freeBase(int n) {
    }

    int getNonZeroAllocation(int n) {
        int n2 = this.allocated.find(n, 0);
        int n3 = 0;
        while (n2 != -1) {
            if (n3 == 0) {
                n3 = this.allocated.getValue(n2, 1);
            } else if (this.allocated.getValue(n2, 1) != 0) {
                return -1;
            }
            n2 = this.allocated.find(n, n2 + 1);
        }
        return n3;
    }

    void verifyAllocations() {
        int n = 0;
        for (int i = 0; i < this.table.getSize(); ++i) {
            int n2;
            if (i == n) {
                n2 = this.allocated.countInstances(i);
                int n3 = this.deleted.countInstances(i);
                int n4 = n2 - n3;
                if (this.table.isAssigned(i)) {
                    if (n4 != 1) {
                        System.out.println("Assigned cell " + i + " in free list");
                        n = 0;
                        continue;
                    }
                    n = this.getNonZeroAllocation(n);
                    continue;
                }
                if (n4 != 0) {
                    System.out.println("Free cell " + i + " with incorrect number of allocated and deleted mentions");
                }
                if (n3 == 0) {
                    n = this.table.getLink(n);
                    continue;
                }
                n = this.getNonZeroAllocation(n);
                continue;
            }
            if (this.table.isAssigned(i) || (n2 = this.allocated.countInstances(i) - this.deleted.countInstances(i)) == -1) continue;
            System.out.println("Free cell " + i + " missing from free list");
        }
    }

    void dumpChain(PrintStream printStream) {
        this.verifyAllocations();
        printStream.print("Free cells chain: \n0");
        int n = this.table.getLink(0);
        block0: while (n < this.table.getSize()) {
            int n2 = n;
            int n3 = n;
            do {
                n = n3;
                n3 = this.table.getLink(n);
                if (!this.table.isAssigned(n) && n3 != 0 || (n3 = this.getNonZeroAllocation(n)) != 0) continue;
                printStream.println(" error in allocated list ***");
                break block0;
            } while (n3 == n + 1 && n3 < this.table.getSize());
            if (n2 == n) {
                printStream.print("->" + n);
            } else {
                printStream.print("->[" + n2 + "-" + n + "]");
            }
            n = n3;
        }
        printStream.println("\nAllocated: " + this.allocated);
        printStream.println("Deleted: " + this.deleted);
    }

    void dumpRegions(PrintStream printStream) {
        int n = this.table.getSize();
        int n2 = n / 10;
        for (int i = 0; i < n; i += n2) {
            if (i + n2 > n) {
                n2 = n - i;
            }
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (this.table.isAssigned(i + j)) continue;
                ++n3;
            }
            printStream.println("Region from cell " + i + " waste " + (double)n3 * 100.0 / (double)n2);
        }
    }
}

