/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.netgeneric.Statistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public interface NetGeneric
extends NetGenericReadOnly,
Statistics,
Initializer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    public static final int VALUE_REMOVE = -1;
    public static final int VALUE_UNCHANGED = -2;
    public static final int VALUE_BREAK = -3;

    public void setMaxIndex(int var1) throws DLTException;

    @Override
    public boolean transitionPresent(int var1, int var2);

    @Override
    public int transitionValue(int var1, int var2);

    @Override
    public int takeTransition(int var1, int var2, int var3);

    public Object getPayload(int var1, int var2, Object var3) throws DLTException;

    public void modifyEntry(IndexIterator var1, ChangeEncapsulator var2) throws DLTException;

    public int getSize();

    public int getSignature();

    public int getBiggestValue();

    public void readNet(DataInput var1, int var2, int var3, int var4) throws DLTException, IOException;

    public long writeNet(DataOutput var1) throws IOException;

    public void attachFSA(IndexIterator var1, Merger.MergerNode var2) throws DLTException;

    public void attachFSA(IndexIterator var1, BuildNode var2) throws DLTException;

    public void transformBranch(IndexIterator var1, Merger.MergerNode var2) throws DLTException;

    public void transformBranch(IndexIterator var1, BuildNode var2) throws DLTException;

    public RegExBuilder getRegExBuilder();

    public boolean isCyclic();

    public void forAllInstances(int var1, ChangeEncapsulator var2) throws DLTException;

    public NetGenericReadOnly getReader();

    public void ensureModifyStarted() throws DLTException;

    public PayloadManipulator getPayloadManipulator(int var1);

    public PayloadManipulator setPayloadManipulator(int var1, PayloadManipulator var2);

    public boolean isEquivalent(BuildNode var1) throws DLTException;

    public static interface ChangeEncapsulator {
        public int Apply(int var1) throws DLTException;

        public static class Setter
        implements ChangeEncapsulator {
            private int val;

            public Setter(int n) {
                this.val = n;
            }

            @Override
            public int Apply(int n) {
                return this.val;
            }
        }
    }

    public static interface IndexIterator {
        public static final IndexIterator Root = new EmptyIterator();

        public int first();

        public int next();

        public static class Array
        implements IndexIterator {
            private final int[] arr;
            private int pos;

            public Array(int[] nArray) {
                this.arr = nArray;
            }

            @Override
            public int first() {
                this.pos = 0;
                return this.arr[0];
            }

            @Override
            public int next() {
                return this.arr[++this.pos];
            }
        }

        public static class EmptyIterator
        implements IndexIterator {
            @Override
            public int first() {
                return 0;
            }

            @Override
            public int next() {
                return 0;
            }
        }
    }
}

