/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NetGenericImpl;
import com.ibm.dltj.netgeneric.NetGenericStaged;
import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class NetGenericFactory {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    static final int SIGNATURE_MASK = 0xFFFFFF;
    static final int SIGNATURE_BITS_IMPL = 0x1A000000;
    static final int SIGNATURE_BITS_STAGED = -2030043136;
    static final int SIGNATURE_BITS_TABLE = 0x1A000000;
    public static final int SIGNATURE_DEFAULT = 448061489;
    public static final int SIGNATURE_STAGED = -2018189263;

    static int toTableSignature(int n) {
        return n & 0xFFFFFF | 0x1A000000;
    }

    public static NetGenericFullAccess create(int n, int n2, Initializer initializer) throws DLTException {
        switch (n & 0xFF000000) {
            case 0x1A000000: {
                return new NetGenericImpl(n2, initializer);
            }
            case -2030043136: {
                return new NetGenericStaged(n2, initializer);
            }
        }
        throw new DLTException(Messages.getString("error.dict.format"));
    }

    public static void load(DataInput dataInput, int n, NetGeneric netGeneric) throws DLTException, IOException {
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = -1;
        if (n3 > 0) {
            n4 = dataInput.readInt();
        }
        while (true) {
            int n5 = --n3;
            --n3;
            if (n5 <= 0) break;
            dataInput.readInt();
        }
        netGeneric.readNet(dataInput, n, n2, n4);
    }

    public static void load(DataInput dataInput, NetGeneric netGeneric) throws DLTException, IOException {
        int n = dataInput.readInt();
        NetGenericFactory.load(dataInput, n, netGeneric);
    }

    public static NetGeneric load(DataInput dataInput, int n, int n2, Initializer initializer) throws DLTException, IOException {
        int n3 = dataInput.readInt();
        NetGenericFullAccess netGenericFullAccess = NetGenericFactory.create(n3, n, initializer);
        netGenericFullAccess.setMaxIndex(n2);
        NetGenericFactory.load(dataInput, n3, netGenericFullAccess);
        return netGenericFullAccess;
    }

    public static long save(DataOutput dataOutput, NetGeneric netGeneric) throws IOException, DLTException {
        dataOutput.writeInt(netGeneric.getSignature());
        dataOutput.writeInt(netGeneric.getSize());
        dataOutput.writeInt(1);
        dataOutput.writeInt(netGeneric.getBiggestValue());
        int n = 12;
        n = (int)((long)n + netGeneric.writeNet(dataOutput));
        return n;
    }

    public static boolean isNetCompact(int n) {
        return TransitionTable.CreateTable(NetGenericFactory.toTableSignature(n), 0, 0) != null;
    }

    public static boolean isStaged(int n) {
        return (n & 0x1A000000) != 0x1A000000;
    }

    public static int getFSTSignature(DataInputStream dataInputStream) throws IOException {
        dataInputStream.mark(16);
        if (dataInputStream.readInt() != -1161904401) {
            dataInputStream.reset();
            return -1;
        }
        dataInputStream.readInt();
        dataInputStream.readInt();
        int n = dataInputStream.readInt();
        dataInputStream.reset();
        return n;
    }
}

