/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeMerger;
import com.ibm.dltj.netgeneric.InPlaceMerger;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.LoopReferenceCounter;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.MinimizationVerifier;
import com.ibm.dltj.netgeneric.NetFitFinder;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.NetGenericReader;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.netgeneric.Statistics;
import com.ibm.dltj.netgeneric.TransitionTable;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class NetGenericImpl
implements NetGenericFullAccess,
LoopReferenceCounter.ObjectInterface {
    public static final int DEFAULT_SIGNATURE = 448061489;
    private static final int REFERRER_NONE = -1;
    private int first_base;
    final int first_link_index;
    private int biggest_value;
    private int max_index = -1;
    PayloadManipulator[] manipulators;
    final Initializer initializer;
    private final IntArray node_history;
    TransitionTable table = null;
    private NetGenericReader reader = null;
    public final LoopReferenceCounter references;
    private final NetFitFinder fits;
    private Map<Object, HashNode> match_map = null;
    protected int GROW_FACTOR = 11;
    protected int SHRINK_FACTOR = 2;
    final InPlaceMerger merger;
    HashMap<Object, IntArray> SCC_match_map = null;
    Statistics transToString = this;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    @Override
    public final int first_base() {
        return this.first_base;
    }

    @Override
    public final boolean isEmpty() {
        return this.first_base == -1;
    }

    @Override
    public final int getBiggestValue() {
        return this.biggest_value;
    }

    @Override
    public final int getFirstLinkIndex() {
        return this.first_link_index;
    }

    @Override
    public final int getMaxIndex() {
        return this.max_index;
    }

    @Override
    public void setMaxIndex(int n) throws DLTException {
        if (n == this.max_index || this.table == null) {
            this.max_index = n;
            return;
        }
        boolean bl = false;
        if (n > this.max_index) {
            int n2 = this.table.getSize();
            int n3 = n2 - this.max_index + 1;
            int n4 = n2 - n + 1;
            boolean bl2 = bl = n4 <= 0 || !this.table.accepts(n, this.biggest_value + 1);
            if (!bl) {
                if (this.references.initialized()) {
                    while (n4 < n3) {
                        if (this.references.allocated(n4)) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                } else {
                    for (int i = n4 + 1; i < n2; ++i) {
                        if (!this.table.isAssigned(i) || i - this.table.getChar(i) < n4) continue;
                        bl = true;
                        break;
                    }
                }
            }
        }
        this.max_index = n;
        if (bl) {
            this.growTable();
        } else {
            this.reader = new NetGenericReader(this.table, this.max_index, this.first_link_index, this.first_base);
            this.fits.updateMaxIndex(n);
        }
    }

    NetGenericImpl(int n, Initializer initializer) {
        assert (n > 1);
        this.first_link_index = n;
        this.max_index = n;
        this.node_history = new IntArray(1);
        this.first_base = -1;
        this.references = new LoopReferenceCounter(this);
        this.fits = new NetFitFinder(this.references);
        this.manipulators = new PayloadManipulator[n];
        Arrays.fill(this.manipulators, PayloadManipulator.Undefined);
        this.initializer = initializer != null ? initializer : this;
        this.merger = new InPlaceMerger(this, -1);
    }

    NetGenericImpl(PayloadManipulator[] payloadManipulatorArray, Initializer initializer) {
        this(payloadManipulatorArray.length, initializer);
        for (int i = 0; i < payloadManipulatorArray.length; ++i) {
            if (payloadManipulatorArray[i] == null) continue;
            this.manipulators[i] = payloadManipulatorArray[i];
        }
    }

    @Override
    public void reset() {
        this.references.reset();
        this.fits.reset();
        this.match_map = null;
        this.first_base = -1;
        this.table = null;
        this.max_index = this.first_link_index;
        this.biggest_value = 0;
    }

    @Override
    public final boolean transitionPresent(int n, int n2) {
        assert (n2 >= 1 && (this.max_index == -1 || n2 < this.max_index));
        return this.table.getChar(n + n2) == n2;
    }

    @Override
    public final int transitionValue(int n, int n2) {
        assert (this.transitionPresent(n, n2));
        return this.table.getLink(n + n2);
    }

    @Override
    public final int takeTransition(int n, int n2, int n3) {
        assert (n2 >= 1 && (this.max_index == -1 || n2 < this.max_index));
        int n4 = this.table.getChar(n + n2);
        int n5 = this.table.getLink(n + n2);
        return n4 == n2 ? n5 : n3;
    }

    @Override
    public final Object getPayload(int n, int n2, Object object) throws DLTException {
        if (!this.transitionPresent(n, n2)) {
            return object;
        }
        return this.manipulators[n2].getObject(this.transitionValue(n, n2));
    }

    @Override
    public final int getEntry(NetGeneric.IndexIterator indexIterator) {
        int n = this.first_base;
        if (n == -1) {
            return -1;
        }
        int n2 = indexIterator.first();
        while (n2 >= this.first_link_index) {
            if (!this.transitionPresent(n, n2)) {
                return -1;
            }
            n = this.transitionValue(n, n2);
            n2 = indexIterator.next();
        }
        if (n2 != 0) {
            if (!this.transitionPresent(n, n2)) {
                return -1;
            }
            n = this.transitionValue(n, n2);
        }
        return n;
    }

    @Override
    public final int gatherNodeLinks(int n, int[] nArray, int n2) {
        int n3 = this.max_index;
        int n4 = n2;
        for (int i = this.first_link_index; i < n3; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            nArray[n4++] = i;
        }
        return n4 - n2;
    }

    @Override
    public final int gatherNodeLinksCount(int n) {
        int n2 = this.max_index;
        int n3 = 0;
        for (int i = this.first_link_index; i < n2; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    public final int[] gatherNodeLinks(int n) {
        int n2 = this.gatherNodeLinksCount(n);
        int[] nArray = new int[n2];
        this.gatherNodeLinks(n, nArray, 0);
        return nArray;
    }

    @Override
    public final void modifyEntry(NetGeneric.IndexIterator indexIterator, NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        this.ensureModifyStarted();
        assert (this.node_history.isEmpty());
        int n = this.first_base;
        if (n != -1) {
            this.node_history.push(n);
            this.first_base = this.propagateChangeContracted(n, indexIterator.first(), 1, indexIterator, changeEncapsulator);
            this.node_history.pop();
            if (this.first_base != -1) {
                this.references.addReference(-1, this.first_base);
            }
            this.references.removeReference(-1, n);
        } else {
            this.first_base = this.propagateChangeContracted(-1, indexIterator.first(), 1, indexIterator, changeEncapsulator);
            if (this.first_base != -1) {
                this.references.addReference(-1, this.first_base);
            }
        }
    }

    @Override
    public void startModify() {
        if (this.table == null) {
            this.newBuffer();
        }
        if (this.biggest_value == -1) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (this.table.getChar(i) >= this.first_link_index) continue;
                this.biggest_value = Math.max(this.biggest_value, this.table.getLink(i));
            }
        }
        this.match_map = new HashMap<Object, HashNode>();
        HashNode hashNode = new HashNode(-1);
        this.match_map.put(hashNode, hashNode);
        this.countAllReferences(this.references);
        for (int i = 0; i <= this.getLastBase(); ++i) {
            if (!this.references.allocated(i)) continue;
            this.addNodeToMatchMap(i);
        }
        this.fits.initialize(this.table, this.getMaxIndex());
        this.node_history.ensureCapacity(32);
    }

    @Override
    public void endModify() {
        this.match_map = null;
        this.SCC_match_map = null;
        if (this.references.initialized() && (long)this.getFreeCellsCount() * 16L > (long)this.getSize()) {
            int n;
            this.moveAllToFront(new int[this.getSize()]);
            for (n = this.getLastBase(); n > 0 && !this.references.allocated(n); --n) {
            }
            assert (this.first_base <= n);
            if (n < this.getLastBase() - this.SHRINK_FACTOR * this.max_index) {
                this.table = TransitionTable.createTableCopy(this.table, this.max_index, n + this.max_index, this.biggest_value + 1);
                this.reader = new NetGenericReader(this.table, this.max_index, this.first_link_index, this.first_base);
            }
        }
        this.references.reset();
        this.fits.reset();
    }

    @Override
    public final int getSize() {
        if (this.table == null) {
            return 0;
        }
        return this.table.getSize();
    }

    @Override
    public final int getSignature() {
        if (this.table == null) {
            this.newBuffer();
        }
        return this.table.getTypeSignature() & 0xFFFFFF | 0x1A000000;
    }

    @Override
    public void readNet(DataInput dataInput, int n, int n2, int n3) throws DLTException, IOException {
        this.biggest_value = n3;
        this.table = TransitionTable.CreateTable(NetGenericFactory.toTableSignature(n), n2, this.biggest_value + 1);
        if (this.table == null) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        this.table.Load(dataInput);
        this.first_base = dataInput.readInt();
        this.reader = new NetGenericReader(this.table, this.max_index, this.first_link_index, this.first_base);
    }

    @Override
    public long writeNet(DataOutput dataOutput) throws IOException {
        if (this.table == null) {
            this.newBuffer();
        }
        this.table.Save(dataOutput);
        dataOutput.writeInt(this.first_base);
        return this.table.getByteSize() + 4;
    }

    @Override
    public final void attachFSA(NetGeneric.IndexIterator indexIterator, Merger.MergerNode mergerNode) throws DLTException {
        this.modifyEntry(indexIterator, new Merger(this, mergerNode));
    }

    @Override
    public final void attachFSA(NetGeneric.IndexIterator indexIterator, BuildNode buildNode) throws DLTException {
        this.modifyEntry(indexIterator, new BuildNodeMerger(this, buildNode));
    }

    @Override
    public final void transformBranch(NetGeneric.IndexIterator indexIterator, Merger.MergerNode mergerNode) throws DLTException {
        this.ensureModifyStarted();
        Merger merger = new Merger(this, mergerNode);
        int n = merger.Apply(-1);
        this.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(n));
    }

    @Override
    public final void transformBranch(NetGeneric.IndexIterator indexIterator, BuildNode buildNode) throws DLTException {
        this.ensureModifyStarted();
        int n = this.merger.buildAndIntegrate(buildNode);
        this.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(n));
    }

    @Override
    public PayloadManipulator getPayloadManipulator(int n) {
        return this.manipulators[n];
    }

    @Override
    public PayloadManipulator setPayloadManipulator(int n, PayloadManipulator payloadManipulator) {
        PayloadManipulator payloadManipulator2 = this.manipulators[n];
        this.manipulators[n] = payloadManipulator;
        return payloadManipulator2;
    }

    @Override
    public RegExBuilder getRegExBuilder() {
        return new RegExBuilder(this, this);
    }

    @Override
    public NetGenericReadOnly getReader() {
        assert (this.reader != null);
        this.reader.updateFirstBase(this.first_base);
        return this.reader;
    }

    public int getLastBase() {
        return this.getSize() - this.getMaxIndex();
    }

    private void newBuffer() {
        if (this.max_index <= 0) {
            this.max_index = this.first_link_index;
        }
        this.table = TransitionTable.createTableCopy(null, this.max_index, Math.max(100, this.max_index), 0);
        this.first_base = -1;
        this.reader = new NetGenericReader(this.table, this.max_index, this.first_link_index, this.first_base);
    }

    private void growTable() {
        this.table = TransitionTable.createTableCopy(this.table, this.max_index, this.table.getSize() + this.max_index * this.GROW_FACTOR, this.biggest_value + 1);
        this.reader = new NetGenericReader(this.table, this.max_index, this.first_link_index, this.first_base);
        this.references.updateIndexLimit(this.table.getSize());
        this.fits.update(this.table, this.max_index);
    }

    public void setNodeCell(int n, int n2, int n3) {
        assert (!this.table.isAssigned(n + n2) || this.table.getChar(n + n2) == n2);
        assert (n3 >= 0);
        this.updateBiggestValue(n2, n3);
        this.table.setCell(n + n2, n2, n3);
    }

    private void updateBiggestValue(int n, int n2) {
        if (n < this.first_link_index && n > 1 && n2 > this.biggest_value) {
            this.biggest_value = n2;
            if (!this.table.accepts(this.max_index, this.biggest_value + 1)) {
                this.growTable();
            }
        }
    }

    public void setOrFree(int n, int n2, int n3) {
        assert (!this.table.isAssigned(n + n2) || this.table.getChar(n + n2) == n2);
        if (n3 != -1) {
            assert (n3 >= 0);
            this.updateBiggestValue(n2, n3);
            this.table.setCell(n + n2, n2, n3);
        } else {
            this.freeCell(n + n2);
        }
    }

    private void setNodeCellRef(int n, int n2, int n3) throws DLTException {
        assert (!this.table.isAssigned(n + n2) || this.table.getChar(n + n2) == n2);
        assert (n3 >= 0);
        if (n2 >= this.first_link_index) {
            this.references.addReference(n, n3);
        } else {
            n3 = this.manipulators[n2].reference(n3);
            this.updateBiggestValue(n2, n3);
        }
        this.table.setCell(n + n2, n2, n3);
    }

    public int reserveFitForMerge(int n, int n2) {
        int n3;
        int n4 = this.fits.findFitForMerge(0, n, n2);
        if (n4 == -3) {
            n3 = this.getSize() - this.max_index + 1;
            this.growTable();
            n4 = this.fits.findFitForMerge(n3, n, n2);
        }
        assert (n4 >= -1);
        assert (n4 <= this.getLastBase());
        for (n3 = 1; n3 < this.max_index; ++n3) {
            if (!this.transitionPresent(n, n3) && !this.transitionPresent(n2, n3)) continue;
            assert (!this.table.isAssigned(n4 + n3));
            this.setNodeCell(n4, n3, 0);
        }
        if (n4 >= 0) {
            this.references.allocate(n4);
        }
        return n4;
    }

    @Override
    public int modifyNode(int n, int n2, int n3) throws DLTException {
        int n4 = this.findFullMatch(n, n2, n3);
        if (n4 >= -1) {
            return n4;
        }
        int n5 = this.makeNodeCopy(n, n2, n3);
        this.addNodeToMatchMap(n5);
        return n5;
    }

    private int allocateFitForCopy(int n, int n2, int n3) {
        int n4 = this.fits.findFitForCopy(0, n, n2, n3, false);
        if (n4 == -3) {
            int n5 = this.getLastBase() + 1;
            this.growTable();
            n4 = this.fits.findFitForCopy(n5, n, n2, n3, false);
        }
        assert (n4 >= -1);
        assert (n4 <= this.getLastBase());
        if (n4 >= 0) {
            this.references.allocate(n4);
        }
        return n4;
    }

    public int reserveFitForCopy(int n, int n2, int n3) {
        int n4 = this.allocateFitForCopy(n, n2, n3);
        for (int i = 1; i < this.getMaxIndex(); ++i) {
            if (i == n2 || !this.transitionPresent(n, i)) continue;
            this.setNodeCell(n4, i, 0);
        }
        if (n2 != -1 && n3 != -1) {
            this.setNodeCell(n4, n2, n3);
        }
        return n4;
    }

    private int allocateFitForTrans(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.fits.findFitForTrans(0, nArray, n, n2);
        if (n3 == -3) {
            int n4 = this.getLastBase() + 1;
            this.growTable();
            n3 = this.fits.findFitForTrans(n4, nArray, n, n2);
        }
        assert (n3 >= -1);
        assert (n3 <= this.getLastBase());
        if (n3 >= 0) {
            this.references.allocate(n3);
        }
        return n3;
    }

    public int reserveFitForTrans(int[] nArray, int n, int n2) {
        int n3 = this.allocateFitForTrans(nArray, n, n2);
        for (int i = n; i < n2; ++i) {
            this.setNodeCell(n3, nArray[i], 0);
        }
        return n3;
    }

    private int makeNodeCopy(int n, int n2, int n3) throws DLTException {
        int n4 = this.allocateFitForCopy(n, n2, n3);
        if (n != -1) {
            for (int i = 1; i < this.max_index; ++i) {
                if (i == n2 || !this.transitionPresent(n, i)) continue;
                assert (!this.table.isAssigned(n4 + i));
                int n5 = this.transitionValue(n, i);
                this.setNodeCellRef(n4, i, n5);
            }
        }
        if (n3 != -1) {
            this.setNodeCellRef(n4, n2, n3);
        }
        return n4;
    }

    private void freeCell(int n) {
        this.fits.freeCell(n);
        this.table.unassign(n);
    }

    private void freeBase(int n) {
        this.fits.freeBase(n);
    }

    @Override
    public void deleteNode(int n) {
        int n2;
        this.removeNodeFromMatchMap(n);
        if (!this.references.allocated(n)) {
            this.removeSCCNode(n);
        } else assert (!this.references.selfReferenced(n));
        for (n2 = 1; n2 < this.first_link_index; ++n2) {
            if (!this.transitionPresent(n, n2)) continue;
            this.manipulators[n2].dereference(this.transitionValue(n, n2));
            this.freeCell(n + n2);
        }
        while (n2 < this.max_index) {
            if (this.transitionPresent(n, n2)) {
                this.references.removeReference(n, this.transitionValue(n, n2));
                this.freeCell(n + n2);
            }
            ++n2;
        }
        this.freeBase(n);
    }

    private void deleteNodeNoMapRef(int n) {
        this.references.deallocate(n);
        for (int i = 1; i < this.max_index; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            this.freeCell(n + i);
        }
        this.freeBase(n);
    }

    private void countAllReferences(LoopReferenceCounter loopReferenceCounter) {
        loopReferenceCounter.initialize(this.getSize());
        if (this.first_base < 0) {
            return;
        }
        SelfReferenceGatherer selfReferenceGatherer = new SelfReferenceGatherer(loopReferenceCounter);
        if (this.first_base != -1) {
            selfReferenceGatherer.gatherSelfReferences(this.first_base());
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.table.isAssigned(i) || this.table.getChar(i) < this.first_link_index) continue;
            int n = this.table.getLink(i);
            loopReferenceCounter.addReference(i - this.table.getChar(i), n);
        }
        loopReferenceCounter.addReference(-1, this.first_base);
    }

    private int findFullMatch(int n, int n2, int n3) {
        HashNode hashNode = this.match_map.get(new HashModifiedNode(n, n2, n3));
        return hashNode == null ? -3 : hashNode.base;
    }

    private void removeNodeFromMatchMap(int n) {
        if (this.match_map == null || n == -1) {
            return;
        }
        HashNode hashNode = this.match_map.remove(new HashNode(n));
        assert (hashNode != null);
    }

    private void addNodeToMatchMap(int n) {
        assert (this.match_map != null);
        assert (n > -1);
        HashNode hashNode = new HashNode(n);
        assert (this.match_map.get(hashNode) == null);
        this.match_map.put(hashNode, hashNode);
    }

    private int findNodeMatch(int n) {
        assert (this.match_map != null);
        assert (n > -1);
        HashNode hashNode = this.match_map.get(new HashNode(n));
        return hashNode == null ? -3 : hashNode.base;
    }

    private void initializeSCCMatchMap() {
        this.SCC_match_map = new HashMap();
        for (int i = 0; i <= this.getLastBase(); ++i) {
            if (!this.references.selfReferenced(i)) continue;
            this.addSCCNode(i);
        }
    }

    public IntArray getSCCMatchCandidates(final int[] nArray, final BuildNode[] buildNodeArray, final int n, final int n2) {
        Object object = new Object(){

            public int hashCode() {
                int n4 = 1;
                for (int i = n; i < n2; ++i) {
                    int n22 = buildNodeArray[i].getAssignedNode();
                    int n3 = nArray[i];
                    n4 = n3 < NetGenericImpl.this.first_link_index || buildNodeArray[i].isFinalized() && !NetGenericImpl.this.references.selfReferenced(n22) ? Utils.combineHash(n4, n3, n22) : Utils.combineHash(n4, n3);
                }
                return n4;
            }

            public boolean equals(Object object) {
                assert (object.getClass() == SCCHashNode.class);
                SCCHashNode sCCHashNode = (SCCHashNode)object;
                int n5 = NetGenericImpl.this.getMaxIndex();
                int n22 = 1;
                for (int i = n; i < n2; ++i) {
                    while (n22 < nArray[i]) {
                        if (NetGenericImpl.this.transitionPresent(sCCHashNode.base, n22)) {
                            return false;
                        }
                        ++n22;
                    }
                    if (!NetGenericImpl.this.transitionPresent(sCCHashNode.base, n22)) {
                        return false;
                    }
                    int n3 = NetGenericImpl.this.transitionValue(sCCHashNode.base, n22);
                    if (buildNodeArray[i].isFinalized()) {
                        int n4 = buildNodeArray[i].getAssignedNode();
                        if (!(n4 == n3 || n22 >= NetGenericImpl.this.first_link_index && NetGenericImpl.this.references.selfReferenced(n4) && NetGenericImpl.this.references.selfReferenced(n3))) {
                            return false;
                        }
                    } else {
                        assert (n22 >= NetGenericImpl.this.first_link_index);
                        if (!NetGenericImpl.this.references.selfReferenced(n3)) {
                            return false;
                        }
                    }
                    ++n22;
                }
                while (n22 < n5) {
                    if (NetGenericImpl.this.transitionPresent(sCCHashNode.base, n22)) {
                        return false;
                    }
                    ++n22;
                }
                return true;
            }
        };
        if (this.SCC_match_map == null) {
            this.initializeSCCMatchMap();
        }
        return this.SCC_match_map.get(object);
    }

    public void addSCCNode(int n, int[] nArray, BuildNode[] buildNodeArray, int n2, int n3) throws DLTException {
        for (int i = n2; i < n3; ++i) {
            int n4 = buildNodeArray[i].getAssignedNode();
            this.setNodeCellRef(n, nArray[i], n4);
        }
        this.addNodeToMatchMap(n);
        this.addSCCNode(n);
    }

    void addSCCNode(int n) {
        SCCHashNode sCCHashNode;
        IntArray intArray;
        if (this.SCC_match_map == null) {
            this.initializeSCCMatchMap();
        }
        if ((intArray = this.SCC_match_map.get(sCCHashNode = new SCCHashNode(n))) == null) {
            intArray = new IntArray();
            this.SCC_match_map.put(sCCHashNode, intArray);
        }
        intArray.add(n);
    }

    private void removeSCCNode(int n) {
        if (this.SCC_match_map != null) {
            SCCHashNode sCCHashNode = new SCCHashNode(n);
            IntArray intArray = this.SCC_match_map.get(sCCHashNode);
            assert (intArray != null);
            if (intArray.size() == 1) {
                this.SCC_match_map.remove(sCCHashNode);
                return;
            }
            int n2 = intArray.indexOf(n);
            assert (n2 >= 0);
            intArray.remove(n2);
            if (n2 == 0) {
                this.SCC_match_map.remove(sCCHashNode);
                this.SCC_match_map.put(new SCCHashNode(intArray.get(0)), intArray);
            }
        }
    }

    private void addNodeReferences(int n) {
        int n2;
        int n3;
        for (n3 = 1; n3 < this.first_link_index; ++n3) {
            if (!this.transitionPresent(n, n3)) continue;
            n2 = this.transitionValue(n, n3);
            int n4 = this.manipulators[n3].reference(n2);
            this.setNodeCell(n, n3, n4);
        }
        while (n3 < this.max_index) {
            if (this.transitionPresent(n, n3)) {
                n2 = this.transitionValue(n, n3);
                this.references.addReference(n, n2);
            }
            ++n3;
        }
    }

    private int propagateChangeContracted(int n, int n2, int n3, NetGeneric.IndexIterator indexIterator, NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        int n4;
        int n5;
        if (n2 == 0) {
            return changeEncapsulator.Apply(n);
        }
        assert (n2 < this.max_index);
        boolean bl = this.node_history.size() < n3 || n == -1 || !this.references.singlyReferenced(n);
        int n6 = n5 = this.transitionPresent(n, n2) ? this.transitionValue(n, n2) : -1;
        if (n2 >= this.first_link_index) {
            if (bl) {
                n4 = this.propagateChangeContracted(n5, indexIterator.next(), n3 + 1, indexIterator, changeEncapsulator);
            } else {
                this.node_history.push(n5);
                n4 = this.propagateChangeContracted(n5, indexIterator.next(), n3 + 1, indexIterator, changeEncapsulator);
                if (this.node_history.size() > n3) {
                    this.node_history.pop();
                } else {
                    bl = true;
                }
            }
        } else {
            n5 = this.transitionPresent(n, n2) ? this.transitionValue(n, n2) : -1;
            n4 = changeEncapsulator.Apply(n5);
        }
        if (n5 == n4) {
            return n;
        }
        assert (n != -1 || n4 != -1);
        int n7 = this.findFullMatch(n, n2, n4);
        if (n7 >= -1) {
            this.checkNodeHistory(n7);
            return n7;
        }
        if (!(bl || this.table.getChar(n + n2) != n2 && this.table.isAssigned(n + n2))) {
            this.removeNodeFromMatchMap(n);
            if (n4 != -1) {
                if (!this.table.isAssigned(n + n2)) {
                    this.fits.grabCell(n + n2);
                }
                this.setNodeCellRef(n, n2, n4);
            } else {
                this.freeCell(n + n2);
            }
            if (n5 >= 0) {
                if (n2 >= this.first_link_index) {
                    this.references.removeReference(n, n5);
                } else {
                    this.manipulators[n2].dereference(n5);
                }
            }
            this.addNodeToMatchMap(n);
            return n;
        }
        int n8 = this.makeNodeCopy(n, n2, n4);
        this.addNodeToMatchMap(n8);
        return n8;
    }

    public void checkNodeHistory(int n) {
        int n2 = this.node_history.indexOf(n);
        if (n2 >= 0) {
            this.node_history.removeRange(n2 + 1, this.node_history.size());
        }
    }

    private int moveAllToFront(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.getLastBase();
        int n6 = this.max_index;
        for (n3 = 0; n3 <= n5; ++n3) {
            if (!this.references.allocated(n3)) continue;
            n2 = this.fits.findFitForCopy(0, n3, -1, -1, true);
            if (n2 != -3 && n2 < n3) {
                this.references.allocate(n2);
                for (n = 1; n < n6; ++n) {
                    if (!this.transitionPresent(n3, n)) continue;
                    this.setNodeCell(n2, n, this.transitionValue(n3, n));
                    this.freeCell(n3 + n);
                }
                this.references.moveReferences(n3, n2);
                this.deleteNode(n3);
            } else {
                n2 = n3;
            }
            if (n2 != n3) {
                ++n4;
            }
            nArray[n3] = n2;
        }
        n3 = this.getSize();
        if (n4 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.table.getChar(n2);
                if (n < this.first_link_index || n < 1 || n >= this.max_index) continue;
                this.table.setCell(n2, n, nArray[this.table.getLink(n2)]);
            }
            this.first_base = nArray[this.first_base];
        }
        return n4;
    }

    public int attachNonloopingNode(int n) {
        int n2 = this.findNodeMatch(n);
        if (n2 == -3) {
            this.addNodeReferences(n);
            this.addNodeToMatchMap(n);
            return n;
        }
        this.deleteNodeNoMapRef(n);
        return n2;
    }

    @Override
    public int addNode(final int[] nArray, final int[] nArray2, final int n) throws DLTException {
        Object object = new Object(){

            public int hashCode() {
                int n2 = 1;
                for (int i = 0; i < n; ++i) {
                    n2 = Utils.combineHash(n2, nArray[i], nArray2[i]);
                }
                return n2;
            }

            public boolean equals(Object object) {
                assert (object.getClass() == HashNode.class);
                HashNode hashNode = (HashNode)object;
                int n3 = NetGenericImpl.this.getMaxIndex();
                int n2 = 1;
                for (int i = 0; i < n; ++i) {
                    while (n2 < nArray[i]) {
                        if (NetGenericImpl.this.transitionPresent(hashNode.base, n2)) {
                            return false;
                        }
                        ++n2;
                    }
                    if (NetGenericImpl.this.takeTransition(hashNode.base, n2, -1) != nArray2[i]) {
                        return false;
                    }
                    ++n2;
                }
                while (n2 < n3) {
                    if (NetGenericImpl.this.transitionPresent(hashNode.base, n2)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
        HashNode hashNode = this.match_map.get(object);
        if (hashNode == null) {
            int n2 = this.allocateFitForTrans(nArray, 0, n);
            for (int i = 0; i < n; ++i) {
                this.setNodeCellRef(n2, nArray[i], nArray2[i]);
            }
            this.addNodeToMatchMap(n2);
            return n2;
        }
        return hashNode.base;
    }

    public int addNode(final int[] nArray, final BuildNode[] buildNodeArray, final int n, final int n2) throws DLTException {
        Object object = new Object(){

            public int hashCode() {
                int n3 = 1;
                for (int i = n; i < n2; ++i) {
                    n3 = Utils.combineHash(n3, nArray[i], buildNodeArray[i].getAssignedNode());
                }
                return n3;
            }

            public boolean equals(Object object) {
                assert (object.getClass() == HashNode.class);
                HashNode hashNode = (HashNode)object;
                int n3 = NetGenericImpl.this.getMaxIndex();
                int n22 = 1;
                for (int i = n; i < n2; ++i) {
                    while (n22 < nArray[i]) {
                        if (NetGenericImpl.this.transitionPresent(hashNode.base, n22)) {
                            return false;
                        }
                        ++n22;
                    }
                    if (NetGenericImpl.this.takeTransition(hashNode.base, n22, -1) != buildNodeArray[i].getAssignedNode()) {
                        return false;
                    }
                    ++n22;
                }
                while (n22 < n3) {
                    if (NetGenericImpl.this.transitionPresent(hashNode.base, n22)) {
                        return false;
                    }
                    ++n22;
                }
                return true;
            }
        };
        HashNode hashNode = this.match_map.get(object);
        if (hashNode == null) {
            int n3 = this.allocateFitForTrans(nArray, n, n2);
            for (int i = n; i < n2; ++i) {
                this.setNodeCellRef(n3, nArray[i], buildNodeArray[i].getAssignedNode());
            }
            this.addNodeToMatchMap(n3);
            return n3;
        }
        this.checkNodeHistory(hashNode.base);
        return hashNode.base;
    }

    @Override
    public int addNode(final int[] nArray, final int n, final int n2) throws DLTException {
        Object object = new Object(){

            public int hashCode() {
                int n3 = 1;
                for (int i = 0; i < n2; ++i) {
                    n3 = Utils.combineHash(n3, nArray[i], n);
                }
                return n3;
            }

            public boolean equals(Object object) {
                assert (object.getClass() == HashNode.class);
                HashNode hashNode = (HashNode)object;
                int n3 = NetGenericImpl.this.getMaxIndex();
                int n22 = 1;
                for (int i = 0; i < n2; ++i) {
                    while (n22 < nArray[i]) {
                        if (NetGenericImpl.this.transitionPresent(hashNode.base, n22)) {
                            return false;
                        }
                        ++n22;
                    }
                    if (NetGenericImpl.this.takeTransition(hashNode.base, n22, -1) != n) {
                        return false;
                    }
                    ++n22;
                }
                while (n22 < n3) {
                    if (NetGenericImpl.this.transitionPresent(hashNode.base, n22)) {
                        return false;
                    }
                    ++n22;
                }
                return true;
            }
        };
        HashNode hashNode = this.match_map.get(object);
        if (hashNode == null) {
            int n3 = this.allocateFitForTrans(nArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                this.setNodeCellRef(n3, nArray[i], n);
            }
            this.addNodeToMatchMap(n3);
            return n3;
        }
        return hashNode.base;
    }

    @Override
    public void forAllInstances(int n, NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        assert (n < this.first_link_index);
        int n2 = this.getLastBase();
        block4: for (int i = 0; i <= n2; ++i) {
            if (!this.transitionPresent(i, n)) continue;
            int n3 = this.transitionValue(i, n);
            int n4 = changeEncapsulator.Apply(n3);
            switch (n4) {
                case -2: {
                    continue block4;
                }
                case -3: {
                    break block4;
                }
                default: {
                    if (n3 == n4) continue block4;
                    if (this.match_map != null) {
                        if (this.references.selfReferenced(i)) {
                            this.removeSCCNode(i);
                            this.removeNodeFromMatchMap(i);
                            this.setOrFree(i, n, n4);
                            this.addNodeToMatchMap(i);
                            this.addSCCNode(i);
                            continue block4;
                        }
                        this.removeNodeFromMatchMap(i);
                        this.setOrFree(i, n, n4);
                        this.addNodeToMatchMap(i);
                        continue block4;
                    }
                    this.setOrFree(i, n, n4);
                }
            }
        }
    }

    private int countAllReferences(int n) {
        int n2 = 0;
        int n3 = this.getSize();
        if (this.references.selfReferenced(n)) {
            int n4;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n4 = 0; n4 < n3; ++n4) {
                if (!this.references.sameSelfReference(n4, n)) continue;
                hashSet.add(n4);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = this.table.getChar(n4);
                if (n5 < this.first_link_index || hashSet.contains(n4 - n5) || !hashSet.contains(this.table.getLink(n4))) continue;
                ++n2;
            }
            if (hashSet.contains(this.first_base)) {
                ++n2;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (this.table.getChar(i) < this.first_link_index || this.table.getLink(i) != n) continue;
                ++n2;
            }
            if (n == this.first_base) {
                ++n2;
            }
        }
        return n2;
    }

    private boolean checkReferences() {
        int n;
        if (!this.references.initialized()) {
            return true;
        }
        for (n = 0; n <= this.getLastBase(); ++n) {
            if (this.table.getChar(n) >= this.getFirstLinkIndex() && !this.references.referenced(this.table.getLink(n))) {
                return false;
            }
            if (this.references.referenced(n) || !this.references.allocated(n)) continue;
            return false;
        }
        int n2 = this.getSize();
        while (n < n2) {
            if (this.table.getChar(n) >= this.getFirstLinkIndex() && !this.references.referenced(this.table.getLink(n))) {
                return false;
            }
            if (this.references.allocated(n)) {
                return false;
            }
            ++n;
        }
        LoopReferenceCounter loopReferenceCounter = new LoopReferenceCounter(this);
        this.countAllReferences(loopReferenceCounter);
        return this.references.equals(loopReferenceCounter);
    }

    private boolean checkMatchMap() {
        if (this.match_map == null) {
            return true;
        }
        for (int i = 0; i <= this.getLastBase(); ++i) {
            Object object;
            if (!this.references.referenced(i) || (object = this.match_map.get(new HashNode(i))) != null && ((HashNode)object).base == i) continue;
            return false;
        }
        for (Object object : this.match_map.keySet()) {
            HashNode hashNode = (HashNode)object;
            if (hashNode.base <= -1 || this.references.referenced(hashNode.base)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSCCMatchMap() {
        if (this.SCC_match_map == null) {
            return true;
        }
        for (int i = 0; i <= this.getLastBase(); ++i) {
            IntArray intArray;
            if (!this.references.selfReferenced(i) || (intArray = this.SCC_match_map.get(new SCCHashNode(i))) != null && intArray.contains(i)) continue;
            return false;
        }
        for (IntArray intArray : this.SCC_match_map.values()) {
            for (int i = 0; i < intArray.size(); ++i) {
                int n = intArray.get(i);
                if (n <= -1 || this.references.selfReferenced(n)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean verifyConsistency() {
        boolean bl = this.checkReferences();
        bl = bl && this.checkMatchMap();
        bl = bl && this.checkSCCMatchMap();
        boolean bl2 = bl = bl && MinimizationVerifier.verifyMinimal(this);
        if (!bl) {
            this.dumpNet(System.err);
        }
        return bl;
    }

    @Override
    public boolean isEquivalent(BuildNode buildNode) throws DLTException {
        int n = this.merger.buildAndIntegrate(buildNode);
        if (n == this.first_base) {
            return true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        System.out.println("equivalence failure");
        this.dumpBranch(System.out, this.first_base, hashSet);
        System.out.println("differences");
        this.dumpBranch(System.out, n, hashSet);
        if (n != -1) {
            this.references.addReference(-1, n);
            this.references.removeReference(-1, n);
        }
        return false;
    }

    @Override
    public String transitionToString(int n, int n2) {
        Object object;
        if (n >= this.getFirstLinkIndex()) {
            return "" + n + "->" + n2;
        }
        try {
            object = this.manipulators[n].getObject(n2);
        }
        catch (DLTException dLTException) {
            object = "" + n2 + '(' + dLTException + ')';
        }
        return "i" + n + "->" + object;
    }

    public void dumpBranch(PrintStream printStream, int n, HashSet<Integer> hashSet) {
        if (n == -1) {
            printStream.println("BASE_EMPTY");
            return;
        }
        Integer n2 = n;
        if (hashSet.contains(n2)) {
            return;
        }
        hashSet.add(n2);
        this.dumpBase(printStream, n, false, false, false);
        for (int i = this.getFirstLinkIndex(); i < this.getMaxIndex(); ++i) {
            if (!this.transitionPresent(n, i)) continue;
            this.dumpBranch(printStream, this.transitionValue(n, i), hashSet);
        }
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.dumpBranch(printStream, n, new HashSet<Integer>());
        printStream.println();
    }

    public boolean dumpBase(PrintStream printStream, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        int n2;
        int n3 = Math.min(this.getMaxIndex(), this.getSize() - n);
        for (n2 = 1; n2 < n3 && !this.transitionPresent(n, n2); ++n2) {
        }
        if (!this.references.initialized() || this.references.selfReferenced(n)) {
            bl = true;
        }
        if (n2 == n3) {
            if (this.references.initialized() && this.references.allocated(n)) {
                printStream.println("Base " + n + " *** free allocated base, reference count " + this.references.dump(n) + " ***");
            }
            return bl;
        }
        if (this.references.initialized()) {
            object = this.references.dump(n) + (bl2 ? this.references.dumpVerify(n, this.countAllReferences(n)) : "");
            printStream.print("Base " + n + "(" + (String)object + " refs): ");
        } else {
            printStream.print("Base " + n + ": ");
        }
        while (n2 < n3) {
            if (this.transitionPresent(n, n2)) {
                int n4 = this.transitionValue(n, n2);
                printStream.print(this.transToString.transitionToString(n2, n4));
                if (n2 >= this.first_link_index && n4 > this.getSize() - this.getMaxIndex()) {
                    printStream.print("*** incorrect link ***");
                }
                printStream.print(' ');
            }
            ++n2;
        }
        if (this.match_map != null && bl3) {
            object = this.match_map.get(new HashNode(n));
            if (object == null) {
                printStream.print(" *** no match ***");
            } else if (((HashNode)object).base != n) {
                printStream.print(" *** match for " + object + " ***");
            }
        }
        if (this.SCC_match_map != null && bl3) {
            object = new SCCHashNode(n);
            IntArray intArray = this.SCC_match_map.get(object);
            if (this.references.selfReferenced(n)) {
                if (intArray == null || !intArray.contains(n)) {
                    printStream.print(" *** no SCC match " + intArray + " ***");
                }
            } else if (intArray != null && intArray.contains(n)) {
                printStream.print(" *** non-SCC node in SCC match map ***");
            }
        }
        if (n + n3 > this.getSize()) {
            printStream.print("*** this base should not be used ***");
        }
        printStream.println();
        return bl;
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        printStream.println("First base: " + this.first_base());
        boolean bl = false;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            bl = this.dumpBase(printStream, i, bl, true, true);
        }
        if (this.match_map != null) {
            this.fits.dumpChain(printStream);
            for (Object object : this.match_map.keySet()) {
                HashNode hashNode = (HashNode)object;
                if (hashNode.base <= -1 || this.references.referenced(hashNode.base)) continue;
                printStream.println("*** Unreferenced match_map entry: " + hashNode + "***");
            }
        }
        if (this.SCC_match_map != null) {
            for (IntArray intArray : this.SCC_match_map.values()) {
                for (int i = 0; i < intArray.size(); ++i) {
                    int n2 = intArray.get(i);
                    if (n2 <= -1 || this.references.selfReferenced(n2)) continue;
                    printStream.println("*** Unreferenced SCC_match_map entry: " + n2 + "***");
                }
            }
        }
        return bl;
    }

    private int getFreeCellsCount() {
        int n = 0;
        int n2 = this.getSize();
        for (int i = 0; i < n2; ++i) {
            if (this.table.isAssigned(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        int n = this.getFreeCellsCount();
        printStream.format("dictionary size %d %s cells %d/%d %s max index %d waste factor %.3f\n", this.table.getByteSize(), this.table.getClass().getSimpleName(), this.getSize() - n, this.getSize(), this.match_map != null ? " states " + this.match_map.size() : "", this.getMaxIndex(), (double)this.getSize() / (double)(this.getSize() - n + 1));
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.transToString = statistics;
    }

    @Override
    public LoopReferenceCounter getReferences() {
        return this.references;
    }

    @Override
    public final void ensureModifyStarted() throws DLTException {
        if (this.match_map == null) {
            this.initializer.startModify();
        }
        assert (this.match_map != null);
    }

    @Override
    public int forEachNode(NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        int n = 0;
        for (int i = 0; i <= this.getLastBase(); ++i) {
            if (!this.references.allocated(i)) continue;
            n |= changeEncapsulator.Apply(i);
        }
        return n;
    }

    @Override
    public BuildNode adaptBuildNode(BuildNode buildNode) {
        return buildNode;
    }

    @Override
    public InPlaceMerger getInPlaceMerger() {
        return this.merger;
    }

    @Override
    public boolean isCyclic() {
        if (this.references.initialized()) {
            return this.references.hasSelfReferences();
        }
        LoopReferenceCounter loopReferenceCounter = new LoopReferenceCounter(this);
        loopReferenceCounter.initialize(this.getSize());
        SelfReferenceGatherer selfReferenceGatherer = new SelfReferenceGatherer(loopReferenceCounter);
        if (this.first_base != -1) {
            selfReferenceGatherer.gatherSelfReferences(this.first_base());
        }
        return loopReferenceCounter.hasSelfReferences();
    }

    private final class SCCHashNode {
        final int base;

        SCCHashNode(int n) {
            this.base = n;
        }

        public int hashCode() {
            int n;
            int n2 = 1;
            if (this.base == -1) {
                return n2;
            }
            TransitionTable transitionTable = NetGenericImpl.this.table;
            int n3 = NetGenericImpl.this.getMaxIndex();
            for (n = 1; n < NetGenericImpl.this.first_link_index; ++n) {
                if (transitionTable.getChar(this.base + n) != n) continue;
                n2 = Utils.combineHash(n2, n, transitionTable.getLink(this.base + n));
            }
            while (n < n3) {
                if (transitionTable.getChar(this.base + n) == n) {
                    int n4 = transitionTable.getLink(this.base + n);
                    n2 = !NetGenericImpl.this.references.allocated(n4) || NetGenericImpl.this.references.selfReferenced(n4) ? Utils.combineHash(n2, n) : Utils.combineHash(n2, n, n4);
                }
                ++n;
            }
            return n2;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            int n;
            if (object.getClass() != SCCHashNode.class) {
                return object.equals(this);
            }
            SCCHashNode sCCHashNode = (SCCHashNode)object;
            if (this.base == sCCHashNode.base) {
                return true;
            }
            int n2 = NetGenericImpl.this.getMaxIndex();
            TransitionTable transitionTable = NetGenericImpl.this.table;
            for (n = 1; n < NetGenericImpl.this.first_link_index; ++n) {
                bl2 = transitionTable.getChar(this.base + n) == n;
                boolean bl3 = bl = transitionTable.getChar(sCCHashNode.base + n) == n;
                if (bl2 == bl && (!bl2 || !bl || transitionTable.getLink(this.base + n) == transitionTable.getLink(sCCHashNode.base + n))) continue;
                return false;
            }
            while (n < n2) {
                int n3;
                int n4;
                bl2 = transitionTable.getChar(this.base + n) == n;
                boolean bl4 = bl = transitionTable.getChar(sCCHashNode.base + n) == n;
                if (bl2 != bl) {
                    return false;
                }
                if (bl2 && (n4 = transitionTable.getLink(this.base + n)) != (n3 = transitionTable.getLink(sCCHashNode.base + n))) {
                    if (!NetGenericImpl.this.references.selfReferenced(n4) && NetGenericImpl.this.references.allocated(n4)) {
                        return false;
                    }
                    if (!NetGenericImpl.this.references.selfReferenced(n3) && NetGenericImpl.this.references.allocated(n3)) {
                        return false;
                    }
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            return "[C" + this.base + ']';
        }
    }

    private final class HashModifiedNode {
        final int base;
        private final int ch;
        private final int newlink;

        HashModifiedNode(int n, int n2, int n3) {
            this.base = n;
            this.ch = n2;
            this.newlink = n3;
        }

        public int hashCode() {
            int n;
            if (this.base == -1) {
                if (this.ch != -1) {
                    return Utils.combineHash(1, this.ch, this.newlink);
                }
                return 1;
            }
            TransitionTable transitionTable = NetGenericImpl.this.table;
            int n2 = 1;
            int n3 = NetGenericImpl.this.getMaxIndex();
            if (this.ch != -1) {
                for (n = 1; n < this.ch; ++n) {
                    if (transitionTable.getChar(this.base + n) != n) continue;
                    n2 = Utils.combineHash(n2, n, transitionTable.getLink(this.base + n));
                }
                if (this.newlink != -1) {
                    n2 = Utils.combineHash(n2, n, this.newlink);
                }
                ++n;
            }
            while (n < n3) {
                if (transitionTable.getChar(this.base + n) == n) {
                    n2 = Utils.combineHash(n2, n, transitionTable.getLink(this.base + n));
                }
                ++n;
            }
            return n2;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            int n;
            HashNode hashNode = (HashNode)object;
            int n2 = NetGenericImpl.this.getMaxIndex();
            TransitionTable transitionTable = NetGenericImpl.this.table;
            if (this.ch != -1) {
                if (this.newlink == -1 ? transitionTable.getChar(hashNode.base + this.ch) == this.ch : transitionTable.getChar(hashNode.base + this.ch) != this.ch || transitionTable.getLink(hashNode.base + this.ch) != this.newlink) {
                    return false;
                }
                for (n = 1; n < this.ch; ++n) {
                    bl2 = transitionTable.getChar(this.base + n) == n;
                    boolean bl3 = bl = transitionTable.getChar(hashNode.base + n) == n;
                    if (bl2 == bl && (!bl2 || !bl || transitionTable.getLink(this.base + n) == transitionTable.getLink(hashNode.base + n))) continue;
                    return false;
                }
                ++n;
            }
            while (n < n2) {
                bl2 = transitionTable.getChar(this.base + n) == n;
                boolean bl4 = bl = transitionTable.getChar(hashNode.base + n) == n;
                if (bl2 != bl || bl2 && transitionTable.getLink(this.base + n) != transitionTable.getLink(hashNode.base + n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            return "[" + this.base + (this.ch == -1 ? "" : " (" + this.ch + "->" + this.newlink + ")") + "]";
        }
    }

    private final class HashNode {
        final int base;

        HashNode(int n) {
            this.base = n;
        }

        public int hashCode() {
            int n = 1;
            if (this.base == -1) {
                return n;
            }
            TransitionTable transitionTable = NetGenericImpl.this.table;
            int n2 = NetGenericImpl.this.getMaxIndex();
            for (int i = 1; i < n2; ++i) {
                if (transitionTable.getChar(this.base + i) != i) continue;
                n = Utils.combineHash(n, i, transitionTable.getLink(this.base + i));
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object.getClass() != HashNode.class) {
                return object.equals(this);
            }
            HashNode hashNode = (HashNode)object;
            int n = NetGenericImpl.this.getMaxIndex();
            TransitionTable transitionTable = NetGenericImpl.this.table;
            for (int i = 1; i < n; ++i) {
                boolean bl;
                boolean bl2 = transitionTable.getChar(this.base + i) == i;
                boolean bl3 = bl = transitionTable.getChar(hashNode.base + i) == i;
                if (bl2 == bl && (!bl2 || transitionTable.getLink(this.base + i) == transitionTable.getLink(hashNode.base + i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "[" + this.base + ']';
        }
    }

    class SelfReferenceGatherer {
        final Map<Integer, Integer> loopMap = new HashMap<Integer, Integer>();
        final LoopReferenceCounter ref;
        int index_counter = 0;
        IntArray stack = new IntArray();

        public SelfReferenceGatherer(LoopReferenceCounter loopReferenceCounter) {
            this.ref = loopReferenceCounter;
        }

        final int gatherSelfReferences(Integer n) {
            int n2;
            int n3 = this.index_counter++;
            this.loopMap.put(n, n3);
            this.ref.allocate(n);
            int n4 = n3 + 1;
            this.stack.push(n);
            for (n2 = NetGenericImpl.this.getFirstLinkIndex(); n2 < NetGenericImpl.this.getMaxIndex(); ++n2) {
                if (!NetGenericImpl.this.transitionPresent(n, n2)) continue;
                Integer n5 = NetGenericImpl.this.transitionValue(n, n2);
                if (this.ref.allocated(n5)) {
                    Integer n6 = this.loopMap.get(n5);
                    if (n6 == null) continue;
                    n4 = Math.min(n4, n6);
                    continue;
                }
                int n7 = this.gatherSelfReferences(n5);
                n4 = Math.min(n4, n7);
            }
            if (n4 > n3) {
                this.loopMap.remove(n);
                assert (this.stack.peek() == n.intValue());
                this.stack.pop();
                return Integer.MAX_VALUE;
            }
            if (n4 == n3) {
                do {
                    n2 = this.stack.pop();
                    this.ref.createSelfReference(n2, n);
                    this.loopMap.remove(n2);
                } while (n2 != n);
                return Integer.MAX_VALUE;
            }
            return n4;
        }
    }
}

