/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.TransitionTable;

final class NetGenericReader
implements NetGenericReadOnly {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    static final int INDEX_UNMAPPED = 1;
    static final int INDEX_DONE = 0;
    final TransitionTable table;
    final int max_index;
    final int first_link_index;
    int first_base;

    NetGenericReader(TransitionTable transitionTable, int n, int n2, int n3) {
        this.table = transitionTable;
        this.max_index = n;
        this.first_link_index = n2;
        this.first_base = n3;
    }

    void updateFirstBase(int n) {
        this.first_base = n;
    }

    @Override
    public final int getFirstLinkIndex() {
        return this.first_link_index;
    }

    @Override
    public final int getMaxIndex() {
        return this.max_index;
    }

    public final int getSize() {
        return this.table.getSize();
    }

    public final int getLastBase() {
        return this.getSize() - this.getMaxIndex();
    }

    @Override
    public final boolean transitionPresent(int n, int n2) {
        assert (n2 >= 1 && (this.max_index == -1 || n2 < this.max_index));
        return this.table.getChar(n + n2) == n2;
    }

    @Override
    public final int transitionValue(int n, int n2) {
        assert (this.transitionPresent(n, n2));
        return this.table.getLink(n + n2);
    }

    @Override
    public final int takeTransition(int n, int n2, int n3) {
        assert (n2 >= 1 && (this.max_index == -1 || n2 < this.max_index));
        int n4 = this.table.getChar(n + n2);
        int n5 = this.table.getLink(n + n2);
        return n4 == n2 ? n5 : n3;
    }

    @Override
    public final int getEntry(NetGeneric.IndexIterator indexIterator) {
        int n = this.first_base;
        int n2 = indexIterator.first();
        while (n2 >= this.first_link_index) {
            if (!this.transitionPresent(n, n2)) {
                return -1;
            }
            n = this.transitionValue(n, n2);
            n2 = indexIterator.next();
        }
        if (n2 != 0) {
            if (!this.transitionPresent(n, n2)) {
                return -1;
            }
            n = this.transitionValue(n, n2);
        }
        return n;
    }

    @Override
    public final int gatherNodeLinks(int n, int[] nArray, int n2) {
        int n3 = this.max_index;
        int n4 = n2;
        for (int i = this.first_link_index; i < n3; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            nArray[n4++] = i;
        }
        return n4 - n2;
    }

    @Override
    public final int gatherNodeLinksCount(int n) {
        int n2 = this.max_index;
        int n3 = 0;
        for (int i = this.first_link_index; i < n2; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    public final int[] gatherNodeLinks(int n) {
        int n2 = this.gatherNodeLinksCount(n);
        int[] nArray = new int[n2];
        this.gatherNodeLinks(n, nArray, 0);
        return nArray;
    }

    @Override
    public int first_base() {
        return this.first_base;
    }

    @Override
    public boolean isEmpty() {
        return this.first_base == -1;
    }
}

